/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.tools.daemon;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.configuration.FileConfig;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.tools.daemon.DaemonException;
import org.codehaus.cargo.tools.daemon.DaemonParameters;
import org.codehaus.cargo.tools.daemon.DaemonStart;
import org.codehaus.cargo.tools.daemon.FormContentType;
import org.codehaus.cargo.tools.daemon.MultipartFormContentType;
import org.codehaus.cargo.tools.daemon.MultipartFormWriter;
import org.codehaus.cargo.tools.daemon.UrlEncodedFormContentType;
import org.codehaus.cargo.tools.daemon.UrlEncodedFormWriter;
import org.codehaus.cargo.util.Base64;
import org.codehaus.cargo.util.DefaultFileHandler;
import org.codehaus.cargo.util.FileHandler;
import org.codehaus.cargo.util.log.LoggedObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DaemonClient
extends LoggedObject {
    private static final String MANAGER_CHARSET = "UTF-8";
    private final URL url;
    private final String username;
    private final String password;
    private final String charset;
    private final FileHandler fileHandler = new DefaultFileHandler();
    private String userAgent;

    public DaemonClient(URL url) {
        this(url, "admin");
    }

    public DaemonClient(URL url, String username) {
        this(url, username, "");
    }

    public DaemonClient(URL url, String username, String password) {
        this(url, username, password, "ISO-8859-1");
    }

    public DaemonClient(URL url, String username, String password, String charset) {
        this.url = url;
        this.username = username;
        this.password = password;
        this.charset = charset;
    }

    public URL getURL() {
        return this.url;
    }

    public String getUserName() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void start(DaemonStart start) throws DaemonException, IOException {
        DaemonParameters parameters = new DaemonParameters();
        InstalledLocalContainer container = start.getContainer();
        boolean autostart = start.isAutostart();
        String handleId = start.getHandleId();
        String installerZipFile = start.getInstallerZipFile();
        List<Deployable> deployables = start.getDeployables();
        LocalConfiguration configuration = container.getConfiguration();
        parameters.setParameter("autostart", String.valueOf(autostart));
        parameters.setParameter("handleId", handleId);
        parameters.setParameter("containerId", container.getId());
        parameters.setParameter("configurationType", configuration.getType().toString());
        parameters.setParameter("timeout", String.valueOf(container.getTimeout()));
        if (container.getHome() != null) {
            parameters.setParameter("containerHome", container.getHome());
        }
        if (configuration.getHome() != null) {
            parameters.setParameter("configurationHome", configuration.getHome());
        }
        if (installerZipFile != null) {
            if (!this.installed(installerZipFile)) {
                parameters.setFile("installerZipFileData", installerZipFile);
            }
            parameters.setParameter("installerZipFile", this.fileHandler.getName(installerZipFile));
        }
        if (deployables != null) {
            parameters.setParameter("deployableFiles", this.setupDeployables(parameters, deployables));
        }
        this.setupConfigFiles(parameters, configuration);
        if (container instanceof InstalledLocalContainer) {
            this.setupExtraClasspath(parameters, container);
            this.setupSharedClasspath(parameters, container);
        }
        this.setupAdditionalClasspath(parameters, start.getAdditionalClasspathEntries());
        parameters.setParameter("configurationProperties", this.setupConfigurationProperties(configuration));
        parameters.setParameter("containerProperties", this.setupContainerProperties(container));
        parameters.setParameter("containerOutput", container.getOutput());
        parameters.setParameter("containerLogLevel", container.getLogger().getLevel().toString());
        if (container.isAppend()) {
            parameters.setParameter("containerAppend", "on");
        } else {
            parameters.setParameter("containerAppend", "off");
        }
        this.invoke("start", parameters);
    }

    private void setupAdditionalClasspath(DaemonParameters parameters, List<String> additionalClasspathEntries) {
        if (additionalClasspathEntries == null || additionalClasspathEntries.size() == 0) {
            return;
        }
        StringBuilder classpathJSON = new StringBuilder();
        classpathJSON.append("[");
        for (int i = 0; i < additionalClasspathEntries.size(); ++i) {
            String additionalClasspath = additionalClasspathEntries.get(i);
            if (i != 0) {
                classpathJSON.append(",");
            }
            classpathJSON.append("\"");
            classpathJSON.append(additionalClasspath);
            classpathJSON.append("\"");
        }
        classpathJSON.append("]");
        parameters.setParameter("additionalClasspath", classpathJSON.toString());
    }

    private void resolveFiles(List<String> classpaths, Map<String, String> files, String[] paths, String prefix) {
        for (String path : paths) {
            String relativePath = this.fileHandler.getName(path);
            if (prefix != null) {
                relativePath = this.fileHandler.append(prefix, relativePath);
            }
            if (classpaths != null) {
                classpaths.add(relativePath);
            }
            if (this.fileHandler.isDirectory(path)) {
                String[] children = this.fileHandler.getChildren(path);
                if (children == null || children.length == 0) continue;
                this.resolveFiles(null, files, children, relativePath);
                continue;
            }
            files.put(relativePath, path);
        }
    }

    private void resolveFile(Map<String, String> files, String file, String relativePath) {
        if (this.fileHandler.isDirectory(file)) {
            String[] children = this.fileHandler.getChildren(file);
            if (children != null && children.length != 0) {
                for (String child : children) {
                    this.resolveFile(files, child, this.fileHandler.append(relativePath, this.fileHandler.getName(child)));
                }
            }
        } else {
            files.put(relativePath, file);
        }
    }

    private void addListParameter(DaemonParameters parameters, String parameterName, List<String> list) {
        int i = 0;
        if (list == null || list.size() == 0) {
            return;
        }
        StringBuilder listJSON = new StringBuilder();
        listJSON.append("[");
        for (String item : list) {
            if (i != 0) {
                listJSON.append(",");
            }
            listJSON.append("\"" + item + "\"");
            ++i;
        }
        listJSON.append("]");
        parameters.setParameter(parameterName, listJSON.toString());
    }

    private void addFilesParameter(DaemonParameters parameters, String parameterName, String filePrefix, Map<String, String> files) {
        StringBuilder propertiesJSON = new StringBuilder();
        propertiesJSON.append("[");
        int fileId = 0;
        for (Map.Entry<String, String> entry : files.entrySet()) {
            String relativePath = entry.getKey();
            String absolutePath = entry.getValue();
            if (fileId != 0) {
                propertiesJSON.append(",");
            }
            propertiesJSON.append("\"" + relativePath + "\"");
            parameters.setFile(filePrefix + fileId, absolutePath);
            ++fileId;
        }
        propertiesJSON.append("]");
        parameters.setParameter(parameterName, propertiesJSON.toString());
    }

    private void setupExtraClasspath(DaemonParameters parameters, InstalledLocalContainer container) {
        String[] extraClasspaths = container.getExtraClasspath();
        if (extraClasspaths == null || extraClasspaths.length == 0) {
            return;
        }
        HashMap<String, String> files = new HashMap<String, String>();
        ArrayList<String> relativeClasspaths = new ArrayList<String>();
        this.resolveFiles(relativeClasspaths, files, extraClasspaths, null);
        this.addFilesParameter(parameters, "extraFiles", "extraFileData_", files);
        this.addListParameter(parameters, "extraClasspath", relativeClasspaths);
    }

    private void setupSharedClasspath(DaemonParameters parameters, InstalledLocalContainer container) {
        String[] sharedClasspaths = container.getSharedClasspath();
        if (sharedClasspaths == null || sharedClasspaths.length == 0) {
            return;
        }
        HashMap<String, String> files = new HashMap<String, String>();
        ArrayList<String> relativeClasspaths = new ArrayList<String>();
        this.resolveFiles(relativeClasspaths, files, sharedClasspaths, null);
        this.addFilesParameter(parameters, "sharedFiles", "sharedFileData_", files);
        this.addListParameter(parameters, "sharedClasspath", relativeClasspaths);
    }

    private String setupDeployables(DaemonParameters parameters, List<Deployable> deployables) {
        StringBuilder propertiesJSON = new StringBuilder();
        propertiesJSON.append("[");
        for (int i = 0; i < deployables.size(); ++i) {
            Deployable deployable = deployables.get(i);
            if (i != 0) {
                propertiesJSON.append(",");
            }
            propertiesJSON.append("{");
            if (deployable instanceof WAR) {
                WAR war = (WAR)deployable;
                propertiesJSON.append("\"context\":\"" + war.getContext() + "\",");
            }
            propertiesJSON.append("\"type\":\"" + deployable.getType().toString() + "\",");
            propertiesJSON.append("\"filename\":\"" + this.fileHandler.getName(deployable.getFile()) + "\"");
            propertiesJSON.append("}");
            parameters.setFile("deployableFileData_" + i, deployable.getFile());
        }
        propertiesJSON.append("]");
        return propertiesJSON.toString();
    }

    private void setupConfigFiles(DaemonParameters parameters, LocalConfiguration configuration) {
        List fileConfigs = configuration.getFileProperties();
        if (fileConfigs == null || fileConfigs.size() == 0) {
            return;
        }
        HashMap<String, String> files = new HashMap<String, String>();
        int i = 0;
        for (FileConfig fileConfig : fileConfigs) {
            String file = fileConfig.getFile();
            String relativePath = this.fileHandler.getName(file);
            this.resolveFile(files, file, relativePath);
        }
        StringBuilder propertiesJSON = new StringBuilder();
        propertiesJSON.append("[");
        for (FileConfig fileConfig : fileConfigs) {
            if (i != 0) {
                propertiesJSON.append(",");
            }
            String file = this.fileHandler.getName(fileConfig.getFile());
            String toFile = fileConfig.getToFile();
            String toDirectory = fileConfig.getToDir();
            boolean overwrite = fileConfig.getOverwrite();
            boolean filter = fileConfig.getConfigfile();
            String encoding = fileConfig.getEncoding();
            propertiesJSON.append("{");
            if (toFile != null) {
                propertiesJSON.append("\"tofile\":\"" + toFile + "\",");
            }
            if (toDirectory != null) {
                propertiesJSON.append("\"todir\":\"" + toDirectory + "\",");
            }
            propertiesJSON.append("\"overwrite\":\"" + overwrite + "\",");
            propertiesJSON.append("\"filter\":\"" + filter + "\",");
            if (encoding != null) {
                propertiesJSON.append("\"encoding\":\"" + encoding + "\",");
            }
            propertiesJSON.append("\"file\":\"" + file + "\"");
            propertiesJSON.append("}");
            ++i;
        }
        propertiesJSON.append("]");
        parameters.setParameter("configurationFileProperties", propertiesJSON.toString());
        this.addFilesParameter(parameters, "configurationFiles", "configurationFileData_", files);
    }

    private String setupConfigurationProperties(LocalConfiguration configuration) {
        StringBuilder propertiesJSON = new StringBuilder();
        Map properties = configuration.getProperties();
        int i = 0;
        propertiesJSON.append("{");
        for (Map.Entry entry : properties.entrySet()) {
            if (i != 0) {
                propertiesJSON.append(",");
            }
            propertiesJSON.append("\"" + (String)entry.getKey() + "\":\"" + (String)entry.getValue() + "\"");
            ++i;
        }
        propertiesJSON.append("}");
        return propertiesJSON.toString();
    }

    private String setupContainerProperties(InstalledLocalContainer container) {
        StringBuilder propertiesJSON = new StringBuilder();
        Map properties = container.getSystemProperties();
        int i = 0;
        propertiesJSON.append("{");
        for (Map.Entry entry : properties.entrySet()) {
            if (i != 0) {
                propertiesJSON.append(",");
            }
            propertiesJSON.append("\"" + (String)entry.getKey() + "\":\"" + (String)entry.getValue() + "\"");
            ++i;
        }
        propertiesJSON.append("}");
        return propertiesJSON.toString();
    }

    private boolean installed(String file) throws DaemonException, IOException {
        DaemonParameters parameters = new DaemonParameters();
        parameters.setParameter("file", this.fileHandler.getName(file));
        String response = this.invoke("installed", parameters);
        if (response != null) {
            response = response.trim();
        }
        return "OK - INSTALLED".equals(response);
    }

    public void stop(String handleId) throws DaemonException, IOException {
        DaemonParameters parameters = new DaemonParameters();
        parameters.setParameter("handleId", handleId);
        this.invoke("stop", parameters);
    }

    protected String invoke(String path, DaemonParameters parameters) throws DaemonException, IOException {
        String response;
        FormContentType contentType = null;
        UrlEncodedFormWriter urlEncodedFormWriter = null;
        URL invokeURL = this.url.toString().endsWith("/") ? new URL(this.url + path) : new URL(this.url + "/" + path);
        HttpURLConnection connection = (HttpURLConnection)invokeURL.openConnection();
        connection.setAllowUserInteraction(false);
        connection.setDoInput(true);
        connection.setUseCaches(false);
        if (parameters == null) {
            connection.setDoOutput(false);
            connection.setRequestMethod("GET");
        } else {
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            if (parameters.isMultipartForm()) {
                contentType = new MultipartFormContentType();
                connection.setChunkedStreamingMode(0);
            } else {
                contentType = new UrlEncodedFormContentType();
                urlEncodedFormWriter = new UrlEncodedFormWriter();
                for (Map.Entry<String, String> entry : parameters.getParameters().entrySet()) {
                    urlEncodedFormWriter.addField(entry.getKey(), entry.getValue());
                }
                connection.setRequestProperty("Content-Length", String.valueOf(urlEncodedFormWriter.getLength()));
            }
        }
        if (contentType != null) {
            connection.setRequestProperty("Content-Type", contentType.getContentType());
        }
        if (this.userAgent != null) {
            connection.setRequestProperty("User-Agent", this.userAgent);
        }
        if (this.username != null) {
            String authorization = DaemonClient.toAuthorization(this.username, this.password);
            connection.setRequestProperty("Authorization", authorization);
        }
        connection.connect();
        if (contentType instanceof MultipartFormContentType) {
            MultipartFormWriter writer = new MultipartFormWriter((MultipartFormContentType)contentType, connection.getOutputStream());
            for (Map.Entry<String, String> entry : parameters.getParameters().entrySet()) {
                writer.writeField(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : parameters.getFiles().entrySet()) {
                writer.writeFile(entry.getKey(), "application/octet-stream", this.fileHandler.getName(entry.getValue()), this.fileHandler.getInputStream(entry.getValue()));
            }
            writer.close();
        } else if (contentType instanceof UrlEncodedFormContentType) {
            urlEncodedFormWriter.write(connection.getOutputStream());
        }
        try {
            this.getLogger().info("Trying to read input data", ((Object)((Object)this)).getClass().getName());
            response = this.toString(connection.getInputStream(), MANAGER_CHARSET);
        }
        catch (IOException e) {
            if (connection.getResponseCode() == 401) {
                throw new DaemonException("The username and password you provided are not correct (error 401)", e);
            }
            if (connection.getResponseCode() == 403) {
                throw new DaemonException("The username you provided is not allowed to use the text-based Cargo daemon manager (error 403)", e);
            }
            throw new DaemonException(connection.getResponseMessage(), e);
        }
        this.getLogger().info("Response is " + response, ((Object)((Object)this)).getClass().getName());
        if (!response.startsWith("OK -")) {
            String scriptEndString = "</script>";
            int scriptEnd = response.indexOf(scriptEndString);
            if (scriptEnd != -1) {
                response = response.substring(scriptEnd + scriptEndString.length()).trim();
            }
            throw new DaemonException("Failed parsing response for " + invokeURL + ". Response was: " + response);
        }
        return response;
    }

    private static String toAuthorization(String username, String password) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(username).append(':');
        if (password != null) {
            buffer.append(password);
        }
        return "Basic " + new String(Base64.encodeBase64((byte[])buffer.toString().getBytes()));
    }

    private String toString(InputStream in, String charset) throws IOException {
        int n;
        InputStreamReader reader = new InputStreamReader(in, charset);
        StringBuilder buffer = new StringBuilder();
        char[] chars = new char[1024];
        while ((n = reader.read(chars, 0, chars.length)) != -1) {
            buffer.append(chars, 0, n);
        }
        return buffer.toString();
    }
}

