/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.automation;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.impl.XMLParser;
import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.LocaleDatabase;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.data.ResourceManager;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.api.handler.AbstractUIHandler;
import com.izforge.izpack.api.installer.DataValidator;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.core.substitutor.VariableSubstitutorImpl;
import com.izforge.izpack.data.PanelAction;
import com.izforge.izpack.installer.automation.PanelAutomation;
import com.izforge.izpack.installer.base.InstallerBase;
import com.izforge.izpack.installer.console.ConsolePanelAutomationHelper;
import com.izforge.izpack.installer.data.UninstallDataWriter;
import com.izforge.izpack.installer.language.ConditionCheck;
import com.izforge.izpack.installer.manager.DataValidatorFactory;
import com.izforge.izpack.installer.manager.PanelActionFactory;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.OsConstraintHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public class AutomatedInstaller
extends InstallerBase {
    private TreeMap<String, Integer> panelInstanceCount;
    private AutomatedInstallData idata;
    private boolean result = false;
    private ConditionCheck checkCondition;
    private UninstallDataWriter uninstallDataWriter;
    private VariableSubstitutor variableSubstitutor;

    public AutomatedInstaller(ResourceManager resourceManager, ConditionCheck checkCondition, UninstallDataWriter uninstallDataWriter, VariableSubstitutor variableSubstitutor) {
        super(resourceManager);
        this.checkCondition = checkCondition;
        this.uninstallDataWriter = uninstallDataWriter;
        this.panelInstanceCount = new TreeMap();
        this.variableSubstitutor = variableSubstitutor;
    }

    public void init(String inputFilename) throws Exception {
        File input = new File(inputFilename);
        this.idata.setXmlData(this.getXMLData(input));
        this.idata.setLocaleISO3(this.idata.getXmlData().getAttribute("langpack", "eng"));
        InputStream in = this.resourceManager.getLangPack(this.idata.getLocaleISO3());
        this.idata.setLangpack(new LocaleDatabase(in));
        this.idata.setVariable("ISO3_LANG", this.idata.getLocaleISO3());
        this.resourceManager.setLocale(this.idata.getLocaleISO3());
    }

    @Override
    public void showMissingRequirementMessage(String message) {
        Debug.log((Object)("Missing installer requirement: " + message));
        System.out.println(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInstall() throws Exception {
        boolean reboot;
        VariableSubstitutorImpl subst = new VariableSubstitutorImpl(this.idata.getVariables());
        InstallerBase.refreshDynamicVariables(this.idata, new VariableSubstitutor[]{subst});
        if (!this.checkCondition.checkInstallerRequirements(this)) {
            System.out.println("[ Automated installation FAILED! ]");
            System.exit(-1);
            return;
        }
        System.out.println("[ Starting automated installation ]");
        Debug.log((Object)"[ Starting automated installation ]");
        ConsolePanelAutomationHelper uihelper = new ConsolePanelAutomationHelper();
        try {
            this.result = true;
            for (Panel p : this.idata.getPanelsOrder()) {
                RulesEngine rules = this.idata.getRules();
                if (p.hasCondition() && !rules.isConditionTrue(p.getCondition(), this.idata.getVariables())) {
                    Debug.log((Object)("Condition for panel " + p.getPanelid() + "is not fulfilled, skipping panel!"));
                    if (this.panelInstanceCount.containsKey(p.className)) {
                        this.panelInstanceCount.put(p.className, this.panelInstanceCount.get(p.className) + 1);
                        continue;
                    }
                    this.panelInstanceCount.put(p.className, 1);
                    continue;
                }
                if (!OsConstraintHelper.oneMatchesCurrentSystem((List)p.getOsConstraints())) continue;
                PanelAutomation automationHelper = this.getPanelAutomationHelper(p);
                if (automationHelper == null) {
                    this.executePreValidateActions(p, uihelper);
                    this.validatePanel(p);
                    this.executePostValidateActions(p, uihelper);
                    continue;
                }
                IXMLElement panelRoot = this.updateInstanceCount(p);
                this.installPanel(p, automationHelper, panelRoot);
                AutomatedInstaller.refreshDynamicVariables(this.idata, new VariableSubstitutor[]{subst});
            }
            if (this.uninstallDataWriter.isUninstallRequired()) {
                this.result = this.uninstallDataWriter.write();
            }
            if (this.result) {
                System.out.println("[ Automated installation done ]");
            } else {
                System.out.println("[ Automated installation FAILED! ]");
            }
            reboot = false;
        }
        catch (Exception e) {
            boolean reboot2;
            try {
                this.result = false;
                System.err.println(e.toString());
                e.printStackTrace();
                if (this.result) {
                    System.out.println("[ Automated installation done ]");
                } else {
                    System.out.println("[ Automated installation FAILED! ]");
                }
                reboot2 = false;
            }
            catch (Throwable throwable) {
                if (this.result) {
                    System.out.println("[ Automated installation done ]");
                } else {
                    System.out.println("[ Automated installation FAILED! ]");
                }
                boolean reboot3 = false;
                if (this.idata.isRebootNecessary()) {
                    System.out.println("[ There are file operations pending after reboot ]");
                    switch (this.idata.getInfo().getRebootAction()) {
                        case 3: {
                            reboot3 = true;
                        }
                    }
                    if (reboot3) {
                        System.out.println("[ Rebooting now automatically ]");
                    }
                }
                Housekeeper.getInstance().shutDown(this.result ? 0 : 1, reboot3);
                throw throwable;
            }
            if (this.idata.isRebootNecessary()) {
                System.out.println("[ There are file operations pending after reboot ]");
                switch (this.idata.getInfo().getRebootAction()) {
                    case 3: {
                        reboot2 = true;
                    }
                }
                if (reboot2) {
                    System.out.println("[ Rebooting now automatically ]");
                }
            }
            Housekeeper.getInstance().shutDown(this.result ? 0 : 1, reboot2);
        }
        if (this.idata.isRebootNecessary()) {
            System.out.println("[ There are file operations pending after reboot ]");
            switch (this.idata.getInfo().getRebootAction()) {
                case 3: {
                    reboot = true;
                }
            }
            if (reboot) {
                System.out.println("[ Rebooting now automatically ]");
            }
        }
        Housekeeper.getInstance().shutDown(this.result ? 0 : 1, reboot);
    }

    private void installPanel(Panel p, PanelAutomation automationHelper, IXMLElement panelRoot) throws InstallerException {
        this.executePreActivateActions(p, null);
        Debug.log((Object)("automationHelperInstance.runAutomated :" + automationHelper.getClass().getName() + " entered."));
        automationHelper.runAutomated(this.idata, panelRoot);
        Debug.log((Object)("automationHelperInstance.runAutomated :" + automationHelper.getClass().getName() + " successfully done."));
        this.executePreValidateActions(p, null);
        this.validatePanel(p);
        this.executePostValidateActions(p, null);
    }

    private IXMLElement updateInstanceCount(Panel p) {
        String panelClassName = p.className;
        List panelRoots = this.idata.getXmlData().getChildrenNamed(panelClassName);
        int panelRootNo = 0;
        if (this.panelInstanceCount.containsKey(panelClassName)) {
            panelRootNo = this.panelInstanceCount.get(panelClassName);
        }
        IXMLElement panelRoot = (IXMLElement)panelRoots.get(panelRootNo);
        this.panelInstanceCount.put(panelClassName, panelRootNo + 1);
        return panelRoot;
    }

    private PanelAutomation getPanelAutomationHelper(Panel p) {
        Class<?> automationHelperClass = null;
        PanelAutomation automationHelperInstance = null;
        String praefix = "com.izforge.izpack.panels.";
        if (p.className.contains(".")) {
            praefix = "";
        }
        String automationHelperClassName = praefix + p.className + "AutomationHelper";
        try {
            Debug.log((Object)("AutomationHelper:" + automationHelperClassName));
            automationHelperClass = Class.forName(automationHelperClassName);
        }
        catch (ClassNotFoundException e) {
            Debug.log((Object)("ClassNotFoundException-skip :" + automationHelperClassName));
        }
        this.executePreConstructActions(p, null);
        if (automationHelperClass != null) {
            try {
                Debug.log((Object)("Instantiate :" + automationHelperClassName));
                automationHelperInstance = (PanelAutomation)automationHelperClass.newInstance();
            }
            catch (IllegalAccessException e) {
                Debug.log((Object)("ERROR: no default constructor for " + automationHelperClassName + ", skipping..."));
            }
            catch (InstantiationException e) {
                Debug.log((Object)("ERROR: no default constructor for " + automationHelperClassName + ", skipping..."));
            }
        }
        return automationHelperInstance;
    }

    private void validatePanel(Panel p) throws InstallerException {
        String dataValidator;
        DataValidator.Status validationResult;
        DataValidator validator2;
        try {
            InstallerBase.refreshDynamicVariables(this.idata, new VariableSubstitutor[]{new VariableSubstitutorImpl(this.idata.getVariables())});
        }
        catch (Exception e) {
            throw new InstallerException((Throwable)e);
        }
        List dynConds = this.idata.getDynamicinstallerrequirements();
        if (dynConds != null) {
            for (DataValidator validator2 : dynConds) {
                String errorMessage;
                validationResult = validator2.validateData(this.idata);
                if (validationResult == DataValidator.Status.OK) continue;
                try {
                    errorMessage = this.idata.getLangpack().getString("data.validation.error.title") + ": " + this.variableSubstitutor.substitute(this.idata.getLangpack().getString(validator2.getErrorMessageId()));
                }
                catch (Exception e) {
                    throw new InstallerException((Throwable)e);
                }
                if (validationResult == DataValidator.Status.WARNING && validator2.getDefaultAnswer()) {
                    System.out.println(errorMessage + " - ignoring");
                    return;
                }
                this.result = false;
                throw new InstallerException(errorMessage);
            }
        }
        if ((dataValidator = p.getValidator()) != null && (validationResult = (validator2 = DataValidatorFactory.createDataValidator(dataValidator)).validateData(this.idata)) != DataValidator.Status.OK) {
            String errorMessage;
            try {
                errorMessage = this.idata.getLangpack().getString("data.validation.error.title") + ": " + this.variableSubstitutor.substitute(this.idata.getLangpack().getString(validator2.getErrorMessageId()));
            }
            catch (Exception e) {
                throw new InstallerException((Throwable)e);
            }
            if (validationResult == DataValidator.Status.WARNING && validator2.getDefaultAnswer()) {
                System.out.println(errorMessage + " - ignoring");
                return;
            }
            this.result = false;
            throw new InstallerException(errorMessage);
        }
    }

    public IXMLElement getXMLData(File input) throws IOException {
        FileInputStream in = new FileInputStream(input);
        XMLParser parser = new XMLParser();
        IXMLElement rtn = parser.parse((InputStream)in, input.getAbsolutePath());
        in.close();
        return rtn;
    }

    public boolean getResult() {
        return this.result;
    }

    private List<PanelAction> createPanelActionsFromStringList(Panel panel, List<String> actions) {
        ArrayList<PanelAction> actionList = null;
        if (actions != null) {
            actionList = new ArrayList<PanelAction>();
            for (String actionClassName : actions) {
                PanelAction action = PanelActionFactory.createPanelAction(actionClassName);
                action.initialize(panel.getPanelActionConfiguration(actionClassName));
                actionList.add(action);
            }
        }
        return actionList;
    }

    private void executePreConstructActions(Panel panel, AbstractUIHandler handler) {
        List<PanelAction> preConstructActions = this.createPanelActionsFromStringList(panel, panel.getPreConstructionActions());
        if (preConstructActions != null) {
            for (PanelAction preConstructAction : preConstructActions) {
                preConstructAction.executeAction(this.idata, handler);
            }
        }
    }

    private void executePreActivateActions(Panel panel, AbstractUIHandler handler) {
        List<PanelAction> preActivateActions = this.createPanelActionsFromStringList(panel, panel.getPreActivationActions());
        if (preActivateActions != null) {
            for (PanelAction preActivateAction : preActivateActions) {
                preActivateAction.executeAction(this.idata, handler);
            }
        }
    }

    private void executePreValidateActions(Panel panel, AbstractUIHandler handler) {
        List<PanelAction> preValidateActions = this.createPanelActionsFromStringList(panel, panel.getPreValidationActions());
        if (preValidateActions != null) {
            for (PanelAction preValidateAction : preValidateActions) {
                preValidateAction.executeAction(this.idata, handler);
            }
        }
    }

    private void executePostValidateActions(Panel panel, AbstractUIHandler handler) {
        List<PanelAction> postValidateActions = this.createPanelActionsFromStringList(panel, panel.getPostValidationActions());
        if (postValidateActions != null) {
            for (PanelAction postValidateAction : postValidateActions) {
                postValidateAction.executeAction(this.idata, handler);
            }
        }
    }
}

