/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.base;

import com.izforge.izpack.api.GuiId;
import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.DynamicInstallerRequirementValidator;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.data.ResourceManager;
import com.izforge.izpack.api.handler.AbstractUIHandler;
import com.izforge.izpack.api.installer.DataValidator;
import com.izforge.izpack.api.installer.ISummarisable;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.core.substitutor.VariableSubstitutorImpl;
import com.izforge.izpack.data.PanelAction;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.LayoutConstants;
import com.izforge.izpack.gui.MultiLineLabel;
import com.izforge.izpack.installer.base.HelpWindow;
import com.izforge.izpack.installer.base.InstallerFrame;
import com.izforge.izpack.installer.base.LayoutHelper;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.util.Debug;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class IzPanel
extends JPanel
implements AbstractUIHandler,
LayoutConstants,
ISummarisable {
    private static final long serialVersionUID = 3256442495255786038L;
    protected LayoutHelper layoutHelper;
    protected Component initialFocus = null;
    protected GUIInstallData installData;
    protected InstallerFrame parent;
    protected JLabel headLineLabel;
    protected boolean hidden;
    public static final String HEADLINE = "headline";
    private DataValidator validationService = null;
    private List<PanelAction> preActivateActions = null;
    private List<PanelAction> preValidateActions = null;
    private List<PanelAction> postValidateActions = null;
    public static final String DELIMITER = ".";
    public Panel metadata;
    protected ResourceManager resourceManager;
    protected VariableSubstitutor variableSubstitutor;
    private String helpUrl = null;
    private Map<String, String> helps = null;
    private HelpWindow helpWindow = null;

    public IzPanel(InstallerFrame parent, GUIInstallData installData, ResourceManager resourceManager) {
        this(parent, installData, (LayoutManager2)null, resourceManager);
    }

    public IzPanel(InstallerFrame parent, GUIInstallData installData, LayoutManager2 layoutManager, ResourceManager resourceManager) {
        this.init(parent, installData, resourceManager);
        if (layoutManager != null) {
            this.getLayoutHelper().startLayout(layoutManager);
        }
        this.variableSubstitutor = new VariableSubstitutorImpl(this.installData.getVariables());
    }

    public IzPanel(InstallerFrame parent, GUIInstallData installData, String iconName, ResourceManager resourceManager) {
        this(parent, installData, iconName, -1, resourceManager);
    }

    public IzPanel(InstallerFrame parent, GUIInstallData installData, String iconName, int instance, ResourceManager resourceManager) {
        this(parent, installData, resourceManager);
        this.buildHeadline(iconName, instance);
    }

    protected boolean buildHeadline(String imageIconName, int instanceNumber) {
        String headline;
        boolean result = false;
        if (this.parent.isHeading(this)) {
            return false;
        }
        String headlineSearchBaseKey = this.getClassName() + DELIMITER + HEADLINE;
        if (instanceNumber > -1) {
            String instanceSearchKey = headlineSearchBaseKey + DELIMITER + Integer.toString(instanceNumber);
            String instanceHeadline = this.getString(instanceSearchKey);
            if (Debug.isLOG()) {
                System.out.println("found headline: " + instanceHeadline + DELIMITER + " for instance # " + instanceNumber);
            }
            headline = !instanceSearchKey.equals(instanceHeadline) ? instanceHeadline : this.getString(headlineSearchBaseKey);
        } else {
            headline = this.getString(headlineSearchBaseKey);
        }
        if (headline != null) {
            this.headLineLabel = imageIconName != null && !"".equals(imageIconName) ? new JLabel(headline, this.getImageIcon(imageIconName), 10) : new JLabel(headline);
            Font font = this.headLineLabel.getFont();
            float size = font.getSize();
            int style = 0;
            font = font.deriveFont(style, size * 1.5f);
            this.headLineLabel.setFont(font);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.fill = 2;
            gbc.anchor = 17;
            gbc.insets = new Insets(0, 0, 0, 0);
            this.headLineLabel.setName(HEADLINE);
            ((GridBagLayout)this.getLayout()).addLayoutComponent(this.headLineLabel, gbc);
            this.add(this.headLineLabel);
        }
        return result;
    }

    private String getClassName() {
        String[] splitClassName = this.getClass().getCanonicalName().split("\\.");
        return splitClassName[splitClassName.length - 1];
    }

    public String getString(String key) {
        return this.installData.getLangpack().getString(key);
    }

    public ImageIcon getImageIcon(String iconName) {
        return (ImageIcon)this.parent.getIcons().get((Object)iconName);
    }

    protected void initLayoutHelper() {
        this.layoutHelper = new LayoutHelper(this);
    }

    protected void init(InstallerFrame parent, GUIInstallData idata, ResourceManager resourceManager) {
        this.installData = idata;
        this.parent = parent;
        this.resourceManager = resourceManager;
        this.metadata = idata.currentPanel;
        idata.currentPanel = null;
        this.initLayoutHelper();
    }

    protected boolean isValidated() {
        return true;
    }

    public boolean panelValidated() {
        return this.isValidated() && this.validatePanel();
    }

    public void panelActivate() {
    }

    public void panelDeactivate() {
    }

    public void makeXMLData(IXMLElement panelRoot) {
    }

    public int askQuestion(String title, String question, int choices) {
        return this.askQuestion(title, question, choices, -1);
    }

    public int askQuestion(String title, String question, int choices, int default_choice) {
        int jo_choices = 0;
        if (choices == 37) {
            jo_choices = 0;
        } else if (choices == 38) {
            jo_choices = 1;
        }
        int user_choice = JOptionPane.showConfirmDialog(this, question, title, jo_choices, 3);
        if (user_choice == 2) {
            return 45;
        }
        if (user_choice == 0) {
            return 47;
        }
        if (user_choice == -1) {
            return 49;
        }
        if (user_choice == 1) {
            return 49;
        }
        return default_choice;
    }

    public boolean emitNotificationFeedback(String message) {
        return JOptionPane.showConfirmDialog(this, message, this.installData.getLangpack().getString("installer.Message"), 2, 2) == 0;
    }

    public void emitNotification(String message) {
        JOptionPane.showMessageDialog(this, message);
    }

    public boolean emitWarning(String title, String message) {
        return JOptionPane.showConfirmDialog(this, message, title, 2, 2) == 0;
    }

    public void emitError(String title, String message) {
        JOptionPane.showMessageDialog(this, message, title, 0);
    }

    public void emitErrorAndBlockNext(String title, String message) {
        this.parent.lockNextButton();
        this.emitError(title, message);
    }

    public Component getInitialFocus() {
        return this.initialFocus;
    }

    public void setInitialFocus(Component component) {
        this.initialFocus = component;
    }

    public String getI18nStringForClass(String subkey) {
        String retval = null;
        Class<?> clazz = this.getClass();
        while (retval == null && !clazz.getName().endsWith(".IzPanel")) {
            retval = this.getI18nStringForClass(clazz.getName(), subkey, null);
            clazz = clazz.getSuperclass();
        }
        return retval;
    }

    public String getI18nStringForClass(String subkey, String alternateClass) {
        return this.getI18nStringForClass(this.getClass().getName(), subkey, alternateClass);
    }

    private String getI18nStringForClass(String curClassName, String subkey, String alternateClass) {
        int nameStart = curClassName.lastIndexOf(46) + 1;
        curClassName = curClassName.substring(nameStart, curClassName.length());
        StringBuffer buffer = new StringBuffer();
        buffer.append(curClassName).append(DELIMITER).append(subkey);
        String fullkey = buffer.toString();
        String panelid = null;
        if (this.getMetadata() != null) {
            panelid = this.getMetadata().getPanelid();
        }
        String retval = null;
        if (panelid != null) {
            buffer.append(DELIMITER);
            buffer.append(panelid);
            retval = this.installData.getLangpack().getString(buffer.toString());
        }
        if (retval == null || retval.startsWith(fullkey)) {
            retval = this.installData.getLangpack().getString(fullkey);
        }
        if (retval == null || retval.startsWith(fullkey)) {
            if (alternateClass == null) {
                return null;
            }
            buffer.delete(0, buffer.length());
            buffer.append(alternateClass).append(DELIMITER).append(subkey);
            retval = this.installData.getLangpack().getString(buffer.toString());
        }
        if (retval != null && retval.indexOf(36) > -1) {
            try {
                retval = this.variableSubstitutor.substitute(retval);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return retval;
    }

    public InstallerFrame getInstallerFrame() {
        return this.parent;
    }

    public JLabel createLabel(String subkey, String alternateClass, String iconId, int pos) {
        ImageIcon imageIcon = iconId != null ? (ImageIcon)this.parent.getIcons().get((Object)iconId) : null;
        String msg = this.getI18nStringForClass(subkey, alternateClass);
        JLabel label = LabelFactory.create((String)msg, (Icon)imageIcon, (int)pos);
        if (label != null) {
            label.setFont(this.getControlTextFont());
        }
        return label;
    }

    public JLabel createLabel(String subkey, String alternateClass, String iconId, int pos, boolean isFullLine) {
        ImageIcon imageIcon = iconId != null ? (ImageIcon)this.parent.getIcons().get((Object)iconId) : null;
        String msg = this.getI18nStringForClass(subkey, alternateClass);
        JLabel label = LabelFactory.create((String)msg, (Icon)imageIcon, (int)pos, (boolean)isFullLine);
        if (label != null) {
            label.setFont(this.getControlTextFont());
        }
        return label;
    }

    public JLabel createLabel(String textId, String iconId, int pos) {
        return this.createLabel(textId, iconId, pos, false);
    }

    public JLabel createLabel(String textId, String iconId, int pos, boolean isFullLine) {
        ImageIcon imageIcon = iconId != null ? (ImageIcon)this.parent.getIcons().get((Object)iconId) : null;
        JLabel label = LabelFactory.create((String)this.installData.getLangpack().getString(textId), (Icon)imageIcon, (int)pos, (boolean)isFullLine);
        if (label != null) {
            label.setFont(this.getControlTextFont());
        }
        return label;
    }

    public MultiLineLabel createMultiLineLabelLang(String textId) {
        return this.createMultiLineLabel(this.installData.getLangpack().getString(textId));
    }

    public MultiLineLabel createMultiLineLabel(String text) {
        return this.createMultiLineLabel(text, null, 2);
    }

    public MultiLineLabel createMultiLineLabel(String text, String iconId, int pos) {
        MultiLineLabel multiLineLabel = null;
        multiLineLabel = new MultiLineLabel(text, 0, 0);
        multiLineLabel.setFont(this.getControlTextFont());
        return multiLineLabel;
    }

    public Font getControlTextFont() {
        Font fontObj = IzPanel.getLAF() != null ? MetalLookAndFeel.getControlTextFont() : this.getFont();
        float val = LabelFactory.getLabelFontSize();
        if (val != 1.0f) {
            fontObj = fontObj.deriveFont(fontObj.getSize2D() * val);
        }
        return fontObj;
    }

    protected static MetalLookAndFeel getLAF() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (lookAndFeel instanceof MetalLookAndFeel) {
            return (MetalLookAndFeel)lookAndFeel;
        }
        return null;
    }

    @Deprecated
    public GridBagConstraints getDefaultGridBagConstraints() {
        return (GridBagConstraints)this.layoutHelper.getDefaultConstraints();
    }

    @Deprecated
    public void setDefaultGridBagConstraints(GridBagConstraints constraints) {
        this.layoutHelper.setDefaultConstraints(constraints);
    }

    @Deprecated
    public void resetGridCounter() {
        this.layoutHelper.resetGridCounter();
    }

    @Deprecated
    public GridBagConstraints getNewGridBagConstraints(int gridx, int gridy) {
        return (GridBagConstraints)this.layoutHelper.getNewConstraints(gridx, gridy);
    }

    @Deprecated
    public GridBagConstraints getNewGridBagConstraints(int gridx, int gridy, int gridwidth, int gridheight) {
        return (GridBagConstraints)this.layoutHelper.getNewConstraints(gridx, gridy, gridwidth, gridheight);
    }

    @Deprecated
    public GridBagConstraints getNextXGridBagConstraints() {
        return (GridBagConstraints)this.layoutHelper.getNextXConstraints();
    }

    @Deprecated
    public GridBagConstraints getNextYGridBagConstraints() {
        return (GridBagConstraints)this.layoutHelper.getNextYConstraints();
    }

    @Deprecated
    public GridBagConstraints getNextYGridBagConstraints(int gridwidth, int gridheight) {
        return (GridBagConstraints)this.layoutHelper.getNextYConstraints(gridwidth, gridheight);
    }

    @Deprecated
    public void startGridBagLayout() {
        this.layoutHelper.startLayout(new GridBagLayout());
    }

    @Deprecated
    public void completeGridBagLayout() {
        this.layoutHelper.completeLayout();
    }

    public String getSummaryBody() {
        return null;
    }

    public String getSummaryCaption() {
        String caption = this.parent.isHeading(this) && this.installData.guiPrefs.modifier.containsKey("useHeadingForSummary") && ((String)this.installData.guiPrefs.modifier.get("useHeadingForSummary")).equalsIgnoreCase("yes") ? this.getI18nStringForClass(HEADLINE, this.getClass().getName()) : this.getI18nStringForClass("summaryCaption", this.getClass().getName());
        return caption;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public LayoutHelper getLayoutHelper() {
        return this.layoutHelper;
    }

    public Panel getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Panel p) {
        this.metadata = p;
    }

    public DataValidator getValidationService() {
        return this.validationService;
    }

    public void setValidationService(DataValidator validationService) {
        this.validationService = validationService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean validatePanel() {
        Cursor newCursor;
        Cursor originalCursor;
        Container guiComponent;
        boolean returnValue = true;
        List dynConds = this.installData.getDynamicinstallerrequirements();
        if (dynConds != null) {
            guiComponent = this.getTopLevelAncestor();
            originalCursor = guiComponent.getCursor();
            newCursor = Cursor.getPredefinedCursor(3);
            try {
                guiComponent.setCursor(newCursor);
                this.parent.refreshDynamicVariables();
                for (DynamicInstallerRequirementValidator validator : dynConds) {
                    returnValue = this.processValidationState(validator.validateData((AutomatedInstallData)this.installData));
                }
            }
            finally {
                guiComponent.setCursor(originalCursor);
            }
        }
        if (this.validationService != null && returnValue) {
            guiComponent = this.getTopLevelAncestor();
            originalCursor = guiComponent.getCursor();
            newCursor = Cursor.getPredefinedCursor(3);
            try {
                guiComponent.setCursor(newCursor);
                returnValue = this.processValidationState(this.validationService.validateData((AutomatedInstallData)this.installData));
            }
            finally {
                guiComponent.setCursor(originalCursor);
            }
        } else {
            returnValue = true;
        }
        return returnValue;
    }

    private boolean processValidationState(DataValidator.Status state) {
        boolean returnValue = false;
        if (state == DataValidator.Status.OK) {
            returnValue = true;
        } else {
            Debug.trace((Object)"Validation did not pass!");
            if (this.validationService.getWarningMessageId() != null && state == DataValidator.Status.WARNING) {
                String warningMessage;
                try {
                    warningMessage = this.variableSubstitutor.substitute(this.installData.getLangpack().getString(this.validationService.getWarningMessageId()));
                }
                catch (Exception e) {
                    warningMessage = this.installData.getLangpack().getString(this.validationService.getWarningMessageId());
                }
                if (this.emitWarning(this.getString("data.validation.warning.title"), warningMessage)) {
                    returnValue = true;
                    Debug.trace((Object)"... but user decided to go on!");
                }
            } else {
                String errorMessage;
                try {
                    errorMessage = this.variableSubstitutor.substitute(this.installData.getLangpack().getString(this.validationService.getErrorMessageId()));
                }
                catch (Exception e) {
                    errorMessage = this.installData.getLangpack().getString(this.validationService.getErrorMessageId());
                }
                this.emitError(this.getString("data.validation.error.title"), errorMessage);
            }
        }
        return returnValue;
    }

    protected String parseText(String string_to_parse) {
        try {
            string_to_parse = this.variableSubstitutor.substitute(string_to_parse);
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        return string_to_parse;
    }

    public void setHelps(Map<String, String> helps) {
        this.helps = helps;
    }

    public boolean canShowHelp() {
        return this.helpUrl != null;
    }

    public void showHelp() {
        if (this.helpUrl != null) {
            URL resourceUrl = this.resourceManager.getLocalizedURL(this.helpUrl);
            this.getHelpWindow().showHelp(this.getString("installer.help"), resourceUrl);
        }
    }

    private HelpWindow getHelpWindow() {
        if (this.helpWindow != null) {
            return this.helpWindow;
        }
        this.helpWindow = new HelpWindow((Frame)this.parent, this.getString("installer.help.close"));
        this.helpWindow.setName(GuiId.HELP_WINDOWS.id);
        return this.helpWindow;
    }

    public void addPreActivationAction(PanelAction preActivateAction) {
        if (this.preActivateActions == null) {
            this.preActivateActions = new ArrayList<PanelAction>();
        }
        this.preActivateActions.add(preActivateAction);
    }

    public void addPreValidationAction(PanelAction preValidateAction) {
        if (this.preValidateActions == null) {
            this.preValidateActions = new ArrayList<PanelAction>();
        }
        this.preValidateActions.add(preValidateAction);
    }

    public void addPostValidationAction(PanelAction postValidateAction) {
        if (this.postValidateActions == null) {
            this.postValidateActions = new ArrayList<PanelAction>();
        }
        this.postValidateActions.add(postValidateAction);
    }

    protected final void executePreActivationActions() {
        if (this.preActivateActions != null) {
            for (PanelAction preActivateAction : this.preActivateActions) {
                preActivateAction.executeAction((AutomatedInstallData)this.installData, (AbstractUIHandler)this);
            }
        }
    }

    protected final void executePreValidationActions() {
        if (this.preValidateActions != null) {
            for (PanelAction preValidateAction : this.preValidateActions) {
                preValidateAction.executeAction((AutomatedInstallData)this.installData, (AbstractUIHandler)this);
            }
        }
    }

    protected final void executePostValidationActions() {
        if (this.postValidateActions != null) {
            for (PanelAction postValidateAction : this.postValidateActions) {
                postValidateAction.executeAction((AutomatedInstallData)this.installData, (AbstractUIHandler)this);
            }
        }
    }

    public void setHelpUrl(String helpUrl) {
        this.helpUrl = helpUrl;
    }

    @Override
    public String toString() {
        return "IzPanel{class=" + this.getClassName() + ", hidden=" + this.hidden + '}';
    }

    public static class Filler
    extends JComponent {
        private static final long serialVersionUID = 3258416144414095153L;
    }
}

