/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.console;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.LocaleDatabase;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.data.ResourceManager;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.api.installer.DataValidator;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.core.substitutor.VariableSubstitutorImpl;
import com.izforge.izpack.installer.base.InstallerBase;
import com.izforge.izpack.installer.console.PanelConsole;
import com.izforge.izpack.installer.language.ConditionCheck;
import com.izforge.izpack.installer.manager.DataValidatorFactory;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.OsConstraintHelper;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public class ConsoleInstaller
extends InstallerBase {
    private AutomatedInstallData installdata;
    private boolean result = false;
    private Properties properties;
    private PrintWriter printWriter;
    private final RulesEngine rules;
    private ConditionCheck checkCondition;
    private VariableSubstitutor variableSubstitutor;

    public ConsoleInstaller(AutomatedInstallData installdata, RulesEngine rules, ResourceManager resourceManager, ConditionCheck checkCondition) throws Exception {
        super(resourceManager);
        this.checkCondition = checkCondition;
        this.installdata = installdata;
        this.rules = rules;
        if (this.installdata.getLocaleISO3() == null) {
            this.installdata.setLocaleISO3((String)resourceManager.getAvailableLangPacks().get(0));
        }
        InputStream in = resourceManager.getInputStream("langpacks/" + this.installdata.getLocaleISO3() + ".xml");
        this.installdata.setLangpack(new LocaleDatabase(in));
        this.installdata.setVariable("ISO3_LANG", this.installdata.getLocaleISO3());
        resourceManager.setLocale(this.installdata.getLocaleISO3());
        if (!checkCondition.checkInstallerRequirements(this)) {
            this.variableSubstitutor = new VariableSubstitutorImpl(this.installdata.getVariables());
        }
        if (this.installdata.getRules() == null) {
            this.installdata.setRules(this.rules);
        }
    }

    @Override
    public void showMissingRequirementMessage(String message) {
        Debug.log((Object)("Missing installer requirement: " + message));
        System.out.println(message);
    }

    protected void iterateAndPerformAction(String strAction) throws Exception {
        if (!this.checkCondition.checkInstallerRequirements(this)) {
            System.out.println("[ Console installation FAILED! ]");
            return;
        }
        Debug.log((Object)("[ Starting console installation ] " + strAction));
        try {
            this.result = true;
            this.installdata.setCurPanelNumber(-1);
            for (Panel panel : this.installdata.getPanelsOrder()) {
                this.installdata.setCurPanelNumber(this.installdata.getCurPanelNumber() + 1);
                String praefix = "com.izforge.izpack.panels.";
                if (panel.className.contains(".")) {
                    praefix = "";
                }
                if (!OsConstraintHelper.oneMatchesCurrentSystem((List)panel.getOsConstraints())) continue;
                String panelClassName = panel.className;
                String consoleHelperClassName = praefix + panelClassName + "ConsoleHelper";
                Class<?> consoleHelperClass = null;
                Debug.log((Object)("ConsoleHelper:" + consoleHelperClassName));
                try {
                    consoleHelperClass = Class.forName(consoleHelperClassName);
                }
                catch (ClassNotFoundException e) {
                    Debug.log((Object)("ClassNotFoundException-skip :" + consoleHelperClassName));
                    continue;
                }
                PanelConsole consoleHelperInstance = null;
                if (consoleHelperClass != null) {
                    try {
                        Debug.log((Object)("Instantiate :" + consoleHelperClassName));
                        consoleHelperInstance = (PanelConsole)consoleHelperClass.newInstance();
                    }
                    catch (Exception e) {
                        Debug.log((Object)("ERROR: no default constructor for " + consoleHelperClassName + ", skipping..."));
                        continue;
                    }
                }
                if (consoleHelperInstance != null && this.canShow(panel)) {
                    try {
                        Debug.log((Object)("consoleHelperInstance." + strAction + ":" + consoleHelperClassName + " entered."));
                        boolean bActionResult = true;
                        boolean bIsConditionFulfilled = true;
                        String strCondition = panel.getCondition();
                        if (strCondition != null) {
                            RulesEngine rules = this.installdata.getRules();
                            bIsConditionFulfilled = rules.isConditionTrue(strCondition);
                        }
                        if (strAction.equals("doInstall") && bIsConditionFulfilled) {
                            do {
                                bActionResult = consoleHelperInstance.runConsole(this.installdata);
                            } while (!this.validatePanel(panel));
                        } else if (strAction.equals("doGeneratePropertiesFile")) {
                            bActionResult = consoleHelperInstance.runGeneratePropertiesFile(this.installdata, this.printWriter);
                            if (!this.validatePanel(panel)) {
                                bActionResult = false;
                            }
                        } else if (strAction.equals("doInstallFromPropertiesFile") && bIsConditionFulfilled) {
                            bActionResult = consoleHelperInstance.runConsoleFromProperties(this.installdata, this.properties);
                            if (!this.validatePanel(panel)) {
                                bActionResult = false;
                            }
                        }
                        if (!bActionResult) {
                            this.result = false;
                            return;
                        }
                        Debug.log((Object)("consoleHelperInstance." + strAction + ":" + consoleHelperClassName + " successfully done."));
                    }
                    catch (Exception e) {
                        Debug.log((Object)("ERROR: console installation failed for panel " + panelClassName));
                        e.printStackTrace();
                        this.result = false;
                    }
                }
                ConsoleInstaller.refreshDynamicVariables(this.installdata, new VariableSubstitutor[]{new VariableSubstitutorImpl(this.installdata.getVariables())});
            }
            if (this.result) {
                System.out.println("[ Console installation done ]");
            } else {
                System.out.println("[ Console installation FAILED! ]");
            }
        }
        catch (Exception e) {
            this.result = false;
            System.err.println(e.toString());
            e.printStackTrace();
            System.out.println("[ Console installation FAILED! ]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInstall() throws Exception {
        try {
            this.iterateAndPerformAction("doInstall");
        }
        finally {
            this.checkedReboot();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGeneratePropertiesFile(String strFile) throws Exception {
        try {
            this.printWriter = new PrintWriter(strFile);
            this.iterateAndPerformAction("doGeneratePropertiesFile");
            this.printWriter.flush();
            this.printWriter.close();
        }
        catch (Throwable throwable) {
            this.printWriter.close();
            Housekeeper.getInstance().shutDown(this.result ? 0 : 1);
            throw throwable;
        }
        Housekeeper.getInstance().shutDown(this.result ? 0 : 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInstallFromPropertiesFile(String strFile) throws Exception {
        FileInputStream in = new FileInputStream(strFile);
        try {
            this.properties = new Properties();
            this.properties.load(in);
            this.iterateAndPerformAction("doInstallFromPropertiesFile");
        }
        finally {
            in.close();
            this.checkedReboot();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInstallFromSystemProperties() throws Exception {
        try {
            this.properties = System.getProperties();
            this.iterateAndPerformAction("doInstallFromPropertiesFile");
        }
        finally {
            this.checkedReboot();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInstallFromSystemPropertiesMerge(String strFile) throws Exception {
        FileInputStream in = new FileInputStream(strFile);
        try {
            this.properties = new Properties();
            this.properties.load(in);
            this.mergeAndOverwriteFromSysProperties();
            this.iterateAndPerformAction("doInstallFromPropertiesFile");
        }
        finally {
            in.close();
            this.checkedReboot();
        }
    }

    public boolean canShow(Panel p) {
        String panelid = p.getPanelid();
        if (p.hasCondition()) {
            return this.rules.isConditionTrue(p.getCondition());
        }
        if (!this.rules.canShowPanel(panelid, this.installdata.getVariables())) {
            Debug.trace((Object)("Skip panel with panelid=" + panelid));
            return false;
        }
        Debug.trace((Object)("Showing panel with panelid=" + panelid));
        return true;
    }

    private boolean validatePanel(Panel p) throws InstallerException {
        String dataValidator;
        DataValidator.Status validationResult;
        DataValidator validator2;
        try {
            InstallerBase.refreshDynamicVariables(this.installdata, new VariableSubstitutor[]{new VariableSubstitutorImpl(this.installdata.getVariables())});
        }
        catch (Exception e) {
            throw new InstallerException((Throwable)e);
        }
        List dynConds = this.installdata.getDynamicinstallerrequirements();
        if (dynConds != null) {
            for (DataValidator validator2 : dynConds) {
                String errorMessage;
                validationResult = validator2.validateData(this.installdata);
                if (validationResult == DataValidator.Status.OK) continue;
                try {
                    errorMessage = this.installdata.getLangpack().getString("data.validation.error.title") + ": " + this.variableSubstitutor.substitute(this.installdata.getLangpack().getString(validator2.getErrorMessageId()));
                }
                catch (Exception e) {
                    throw new InstallerException((Throwable)e);
                }
                if (validationResult == DataValidator.Status.WARNING && validator2.getDefaultAnswer()) {
                    System.out.println(errorMessage + " - ignoring");
                }
                return false;
            }
        }
        if ((dataValidator = p.getValidator()) != null && (validationResult = (validator2 = DataValidatorFactory.createDataValidator(dataValidator)).validateData(this.installdata)) != DataValidator.Status.OK) {
            if (validationResult == DataValidator.Status.WARNING && validator2.getDefaultAnswer()) {
                System.out.println("Configuration said, it's ok to go on, if validation is not successfull");
            } else {
                System.out.println("Validation failed, please verify your input");
                return false;
            }
        }
        return true;
    }

    private void mergeAndOverwriteFromSysProperties() {
        Properties systemProperties = System.getProperties();
        Enumeration<?> e = systemProperties.propertyNames();
        while (e.hasMoreElements()) {
            String newval;
            String key = (String)e.nextElement();
            String oldval = (String)this.properties.setProperty(key, newval = systemProperties.getProperty(key));
            if (oldval == null) continue;
            System.out.println("Warning: Property " + key + " overwritten: '" + oldval + "' --> '" + newval + "'");
        }
    }

    private void checkedReboot() {
        boolean reboot = false;
        if (this.installdata.isRebootNecessary()) {
            System.out.println("[ There are file operations pending after reboot ]");
            switch (this.installdata.getInfo().getRebootAction()) {
                case 3: {
                    reboot = true;
                }
            }
            if (reboot) {
                System.out.println("[ Rebooting now automatically ]");
            }
        }
        Housekeeper.getInstance().shutDown(this.result ? 0 : 1, reboot);
    }

    public void run(int type, String path) throws Exception {
        switch (type) {
            case 1: {
                this.doGeneratePropertiesFile(path);
                break;
            }
            case 2: {
                this.doInstallFromPropertiesFile(path);
                break;
            }
            case 3: {
                this.doInstallFromSystemProperties();
                break;
            }
            case 4: {
                this.doInstallFromSystemPropertiesMerge(path);
                break;
            }
            default: {
                this.doInstall();
            }
        }
    }

    public void setLangCode(String langCode) {
        this.installdata.setLocaleISO3(langCode);
    }
}

