/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.container.impl;

import com.izforge.izpack.api.container.BindeableContainer;
import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.ResourceManager;
import com.izforge.izpack.api.event.InstallerListener;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.data.CustomData;
import com.izforge.izpack.installer.data.UninstallData;
import com.izforge.izpack.merge.resolve.ClassPathCrawler;
import com.izforge.izpack.util.OsConstraintHelper;
import com.izforge.izpack.util.file.FileUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;

public class EventFiller {
    private ResourceManager resourceManager;
    private ClassPathCrawler classPathCrawler;
    private BindeableContainer bindeableContainer;
    private AutomatedInstallData installdata;
    private final UninstallData uninstallData;

    public EventFiller(ResourceManager resourceManager, ClassPathCrawler classPathCrawler, BindeableContainer bindeableContainer, AutomatedInstallData installdata, UninstallData uninstallData) {
        this.resourceManager = resourceManager;
        this.classPathCrawler = classPathCrawler;
        this.bindeableContainer = bindeableContainer;
        this.installdata = installdata;
        this.uninstallData = uninstallData;
    }

    public void loadCustomData() throws InstallerException {
        List customData = (List)this.readObject("customData");
        this.installdata.setInstallerListener(new ArrayList());
        for (CustomData data : customData) {
            if (data.osConstraints != null && !OsConstraintHelper.oneMatchesCurrentSystem((List)data.osConstraints)) continue;
            switch (data.type) {
                case 0: {
                    this.addInstallerListener(data.listenerName);
                    break;
                }
                case 1: {
                    this.uninstallData.addUninstallerListener(data);
                    break;
                }
                case 3: {
                    this.uninstallData.addJar(data);
                    break;
                }
                case 2: {
                    this.uninstallData.addNativeLibrary((String)data.contents.get(0));
                }
            }
        }
        this.notifyInstallerListeners();
    }

    private void notifyInstallerListeners() throws InstallerException {
        for (InstallerListener listener : this.installdata.getInstallerListener()) {
            try {
                listener.afterInstallerInitialization(this.installdata);
            }
            catch (InstallerException exception) {
                throw exception;
            }
            catch (Exception exception) {
                throw new InstallerException((Throwable)exception);
            }
        }
    }

    private void addInstallerListener(String className) {
        Class aClass = this.classPathCrawler.searchClassInClassPath(className);
        this.bindeableContainer.addComponent(aClass);
        List listeners = this.installdata.getInstallerListener();
        listeners.add((InstallerListener)this.bindeableContainer.getComponent(aClass));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object readObject(String path) {
        Object model;
        ObjectInputStream objIn = null;
        try {
            InputStream inputStream = this.resourceManager.getInputStream(path);
            objIn = new ObjectInputStream(inputStream);
            model = objIn.readObject();
        }
        catch (ClassNotFoundException exception) {
            try {
                throw new IzPackException((Throwable)exception);
                catch (IOException exception2) {
                    throw new IzPackException((Throwable)exception2);
                }
            }
            catch (Throwable throwable) {
                FileUtils.close(objIn);
                throw throwable;
            }
        }
        FileUtils.close((Closeable)objIn);
        return model;
    }
}

