/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.container.impl;

import com.izforge.izpack.api.container.BindeableContainer;
import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.ResourceManager;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.core.container.AbstractContainer;
import com.izforge.izpack.core.container.ConditionContainer;
import com.izforge.izpack.core.container.filler.ResolverContainerFiller;
import com.izforge.izpack.core.substitutor.VariableSubstitutorImpl;
import com.izforge.izpack.installer.automation.AutomatedInstaller;
import com.izforge.izpack.installer.base.InstallDataConfiguratorWithRules;
import com.izforge.izpack.installer.base.InstallerController;
import com.izforge.izpack.installer.base.InstallerFrame;
import com.izforge.izpack.installer.console.ConsoleInstaller;
import com.izforge.izpack.installer.container.impl.EventFiller;
import com.izforge.izpack.installer.container.provider.GUIInstallDataProvider;
import com.izforge.izpack.installer.container.provider.IconsProvider;
import com.izforge.izpack.installer.container.provider.RulesProvider;
import com.izforge.izpack.installer.data.UninstallData;
import com.izforge.izpack.installer.data.UninstallDataWriter;
import com.izforge.izpack.installer.language.ConditionCheck;
import com.izforge.izpack.installer.language.LanguageDialog;
import com.izforge.izpack.installer.manager.PanelManager;
import com.izforge.izpack.installer.unpacker.IUnpacker;
import com.izforge.izpack.merge.MergeManagerImpl;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import org.picocontainer.Characteristics;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.injectors.Provider;
import org.picocontainer.injectors.ProviderAdapter;

public class InstallerContainer
extends AbstractContainer {
    public void fillContainer(MutablePicoContainer pico) {
        Class<?> unpackerclass;
        this.pico = pico;
        pico.addAdapter((ComponentAdapter)new ProviderAdapter((Provider)new GUIInstallDataProvider())).addAdapter((ComponentAdapter)new ProviderAdapter((Provider)new IconsProvider())).addAdapter((ComponentAdapter)new ProviderAdapter((Provider)new RulesProvider()));
        pico.addComponent(PanelManager.class).addComponent(InstallDataConfiguratorWithRules.class).addComponent(ConditionCheck.class).addComponent(InstallerController.class).addComponent(MergeManagerImpl.class).addComponent(UninstallData.class).addComponent(MutablePicoContainer.class, (Object)pico, new Parameter[0]).addComponent(ConditionContainer.class).addComponent(VariableSubstitutor.class, VariableSubstitutorImpl.class, new Parameter[0]).addComponent(Properties.class).addComponent(ResourceManager.class).addComponent(ConsoleInstaller.class).addComponent(UninstallDataWriter.class).addComponent(AutomatedInstaller.class).addComponent(EventFiller.class).addComponent(BindeableContainer.class, (Object)this, new Parameter[0]);
        new ResolverContainerFiller().fillContainer(pico);
        AutomatedInstallData installdata = (AutomatedInstallData)pico.getComponent(AutomatedInstallData.class);
        VariableSubstitutor substitutor = (VariableSubstitutor)pico.getComponent(VariableSubstitutor.class);
        String unpackerclassname = installdata.getInfo().getUnpackerClassName();
        try {
            unpackerclass = Class.forName(unpackerclassname);
        }
        catch (ClassNotFoundException e) {
            throw new IzPackException((Throwable)e);
        }
        pico.addConfig("title", (Object)this.getTitle(installdata, substitutor)).addConfig("frame", (Object)this.initFrame());
        pico.addComponent(IUnpacker.class, unpackerclass, new Parameter[0]).addComponent(InstallerFrame.class).as(new Properties[]{Characteristics.USE_NAMES}).addComponent(LanguageDialog.class);
        EventFiller eventFiller = (EventFiller)pico.getComponent(EventFiller.class);
        try {
            eventFiller.loadCustomData();
        }
        catch (InstallerException exception) {
            throw new IzPackException((Throwable)exception);
        }
    }

    private JFrame initFrame() {
        ResourceManager resourceManager = (ResourceManager)this.pico.getComponent(ResourceManager.class);
        JFrame frame = new JFrame();
        ImageIcon imageIcon = resourceManager.getImageIconResource("JFrameIcon", new String[]{"/com/izforge/izpack/img/JFrameIcon.png"});
        frame.setIconImage(imageIcon.getImage());
        Dimension frameSize = frame.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2 - 10);
        return frame;
    }

    private String getTitle(AutomatedInstallData automatedInstallData, VariableSubstitutor vs) {
        String key = "installer.reversetitle";
        String message = automatedInstallData.getLangpack().getString("installer.reversetitle");
        if (message.contains("installer.reversetitle")) {
            return automatedInstallData.getLangpack().getString("installer.title") + automatedInstallData.getInfo().getAppName();
        }
        try {
            return vs.substitute(message);
        }
        catch (Exception e) {
            return message;
        }
    }
}

