/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.container.provider;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.impl.XMLParser;
import com.izforge.izpack.api.data.ResourceManager;
import com.izforge.izpack.gui.IconsDatabase;
import com.izforge.izpack.installer.base.InstallerFrame;
import com.izforge.izpack.util.Debug;
import java.io.InputStream;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import org.picocontainer.injectors.Provider;

public class IconsProvider
implements Provider {
    private static final String CUSTOM_ICONS_RESOURCEFILE = "customicons.xml";

    public IconsDatabase provide(ResourceManager resourceManager) throws Exception {
        IconsDatabase icons = new IconsDatabase();
        this.loadIcons(icons);
        this.loadCustomIcons(icons, resourceManager);
        return icons;
    }

    private void loadIcons(IconsDatabase iconsDatabase) throws Exception {
        InputStream inXML = this.getClass().getResourceAsStream("icons.xml");
        this.parseXML(inXML, iconsDatabase);
    }

    private void loadCustomIcons(IconsDatabase icons, ResourceManager resourceManager) throws Exception {
        InputStream inXML = null;
        try {
            inXML = resourceManager.getInputStream(CUSTOM_ICONS_RESOURCEFILE);
        }
        catch (Throwable exception) {
            Debug.trace((Object)"Resource customicons.xml not defined. No custom icons available.");
            return;
        }
        Debug.trace((Object)"Custom icons available.");
        this.parseXML(inXML, icons);
    }

    private void parseXML(InputStream inXML, IconsDatabase icons) {
        ImageIcon img;
        URL url;
        XMLParser parser = new XMLParser();
        IXMLElement data = parser.parse(inXML);
        for (IXMLElement icon : data.getChildrenNamed("icon")) {
            url = InstallerFrame.class.getResource(icon.getAttribute("res"));
            img = new ImageIcon(url);
            Debug.trace((Object)("Icon with id found: " + icon.getAttribute("id")));
            icons.put((Object)icon.getAttribute("id"), (Object)img);
        }
        for (IXMLElement icon : data.getChildrenNamed("sysicon")) {
            url = InstallerFrame.class.getResource(icon.getAttribute("res"));
            img = new ImageIcon(url);
            UIManager.put(icon.getAttribute("id"), img);
        }
    }
}

