/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.container.provider;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.impl.XMLParser;
import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.ResourceManager;
import com.izforge.izpack.api.rules.Condition;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.core.container.ConditionContainer;
import com.izforge.izpack.core.rules.RulesEngineImpl;
import com.izforge.izpack.merge.resolve.ClassPathCrawler;
import com.izforge.izpack.util.Debug;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Map;
import org.picocontainer.injectors.Provider;

public class RulesProvider
implements Provider {
    private static final String CONDITIONS_SPECRESOURCENAME = "conditions.xml";

    public RulesEngine provide(AutomatedInstallData installData, ClassPathCrawler classPathCrawler, ConditionContainer conditionContainer, ResourceManager resourceManager) {
        RulesEngineImpl result = new RulesEngineImpl(installData, classPathCrawler, conditionContainer);
        Map<String, Condition> conditions = this.readConditions(resourceManager);
        if (conditions != null && !conditions.isEmpty()) {
            result.readConditionMap(conditions);
        } else {
            IXMLElement xml = this.readConditions();
            if (xml != null) {
                result.analyzeXml(xml);
            }
        }
        installData.setRules((RulesEngine)result);
        return result;
    }

    private Map<String, Condition> readConditions(ResourceManager resourceManager) {
        Map rules = null;
        try {
            InputStream in = resourceManager.getInputStream("rules");
            if (in != null) {
                ObjectInputStream objIn = new ObjectInputStream(in);
                rules = (Map)objIn.readObject();
                objIn.close();
            }
        }
        catch (Exception exception) {
            Debug.trace((Object)"Cannot find optional rules");
        }
        return rules;
    }

    private IXMLElement readConditions() {
        IXMLElement conditions = null;
        try {
            InputStream input = ClassLoader.getSystemResourceAsStream(CONDITIONS_SPECRESOURCENAME);
            if (input != null) {
                XMLParser xmlParser = new XMLParser();
                conditions = xmlParser.parse(input);
            }
        }
        catch (Exception e) {
            Debug.trace((Object)"Can not find optional resource conditions.xml");
        }
        return conditions;
    }
}

