/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.language;

import com.izforge.izpack.api.data.InstallerRequirement;
import com.izforge.izpack.api.data.ResourceManager;
import com.izforge.izpack.api.installer.InstallerRequirementDisplay;
import com.izforge.izpack.api.rules.Condition;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.FileUtil;
import java.awt.Font;
import java.io.File;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class ConditionCheck {
    private GUIInstallData installdata;
    private ResourceManager resourceManager;
    private RulesEngine rules;

    public ConditionCheck(GUIInstallData installdata, ResourceManager resourceManager, RulesEngine rules) {
        this.installdata = installdata;
        this.resourceManager = resourceManager;
        this.rules = rules;
    }

    public void check() throws Exception {
        this.checkJavaVersion();
        this.checkJDKAvailable();
        this.checkLockFile();
        this.checkLangPackAvaible();
    }

    public void checkLockFile() throws Exception {
        String appName = this.installdata.getInfo().getAppName();
        File file = FileUtil.getLockFile((String)appName);
        if (file.exists()) {
            Debug.trace((Object)"Lock File Exists, asking user for permission to proceed.");
            StringBuffer msg = new StringBuffer();
            msg.append("<html>");
            msg.append("The " + appName + " installer you are attempting to run seems to have a copy already running.<br><br>");
            msg.append("This could be from a previous failed installation attempt or you may have accidentally launched <br>");
            msg.append("the installer twice. <b>The recommended action is to select 'Exit'</b> and wait for the other copy of <br>");
            msg.append("the installer to start. If you are sure there is no other copy of the installer running, click <br>");
            msg.append("the 'Continue' button to allow this installer to run. <br><br>");
            msg.append("Are you sure you want to continue with this installation?");
            msg.append("</html>");
            JLabel label = new JLabel(msg.toString());
            label.setFont(new Font("Sans Serif", 0, 12));
            Object[] optionValues = new Object[]{"Continue", "Exit"};
            int selectedOption = JOptionPane.showOptionDialog(null, label, "Warning", 0, 2, null, optionValues, optionValues[1]);
            Debug.trace((Object)("Selected option: " + selectedOption));
            if (selectedOption == 0) {
                Debug.trace((Object)"Setting temp file to delete on exit");
                file.deleteOnExit();
            } else {
                Debug.trace((Object)"Leaving temp file alone and exiting");
                System.exit(1);
            }
        } else {
            try {
                if (file.createNewFile()) {
                    Debug.trace((Object)"Temp file created");
                    file.deleteOnExit();
                } else {
                    Debug.trace((Object)"Temp file could not be created");
                    Debug.trace((Object)"*** Multiple instances of installer will be allowed ***");
                }
            }
            catch (Exception e) {
                Debug.trace((Object)("Temp file could not be created: " + e));
                Debug.trace((Object)"*** Multiple instances of installer will be allowed ***");
            }
        }
    }

    private void checkJavaVersion() throws Exception {
        String required;
        String version = System.getProperty("java.version");
        if (version.compareTo(required = this.installdata.getInfo().getJavaVersion()) < 0) {
            StringBuffer msg = new StringBuffer();
            msg.append("The application that you are trying to install requires a ");
            msg.append(required);
            msg.append(" version or later of the Java platform.\n");
            msg.append("You are running a ");
            msg.append(version);
            msg.append(" version of the Java platform.\n");
            msg.append("Please upgrade to a newer version.");
            System.out.println(msg.toString());
            JOptionPane.showMessageDialog(null, msg.toString(), "Error", 0);
            System.exit(1);
        }
    }

    private void checkJDKAvailable() {
        String[] message;
        int status;
        if (!this.installdata.getInfo().isJdkRequired()) {
            return;
        }
        FileExecutor exec = new FileExecutor();
        String[] params = new String[]{"javac", "-help"};
        String[] output = new String[2];
        if (exec.executeCommand(params, output) != 0 && (status = JOptionPane.showConfirmDialog(null, message = new String[]{"It looks like your system does not have a Java Development Kit (JDK) available.", "The software that you plan to install requires a JDK for both its installation and execution.", "\n", "Do you still want to proceed with the installation process?"}, "Warning", 0, 2)) == 1) {
            System.exit(1);
        }
    }

    public boolean checkInstallerRequirements(InstallerRequirementDisplay display) throws Exception {
        boolean result = true;
        for (InstallerRequirement installerrequirement : this.installdata.getInstallerrequirements()) {
            String conditionid = installerrequirement.getCondition();
            Condition condition = this.rules.getCondition(conditionid);
            if (condition == null) {
                Debug.log((Object)(conditionid + " not a valid condition."));
                throw new Exception(conditionid + " could not be found as a defined condition");
            }
            if (condition.isTrue()) continue;
            String message = installerrequirement.getMessage();
            if (message != null && message.length() > 0) {
                String localizedMessage = this.installdata.getLangpack().getString(message);
                display.showMissingRequirementMessage(localizedMessage);
            }
            result = false;
            break;
        }
        return result;
    }

    public boolean checkLangPackAvaible() throws Exception {
        List availableLangPacks = this.resourceManager.getAvailableLangPacks();
        return availableLangPacks.size() != 0;
    }
}

