/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.language;

import com.izforge.izpack.api.GuiId;
import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.LocaleDatabase;
import com.izforge.izpack.api.data.ResourceManager;
import com.izforge.izpack.api.installer.InstallerRequirementDisplay;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.core.substitutor.VariableSubstitutorImpl;
import com.izforge.izpack.installer.base.InstallerBase;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.language.ConditionCheck;
import com.izforge.izpack.util.Debug;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class LanguageDialog
extends JDialog
implements ActionListener,
InstallerRequirementDisplay {
    private static final long serialVersionUID = 3256443616359887667L;
    private JComboBox comboBox;
    private HashMap<String, String> iso3Toiso2 = null;
    private boolean isoMapExpanded = false;
    private static HashMap isoTable;
    private static final String[][] LANG_CODES;
    private GUIInstallData installdata;
    private static final String[] LANGUAGE_DISPLAY_TYPES;
    private JFrame frame;
    private ConditionCheck conditionCheck;
    private ResourceManager resourceManager;

    public LanguageDialog(JFrame frame, ResourceManager resourceManager, GUIInstallData installDataGUI, ConditionCheck conditionCheck) throws Exception {
        super(frame);
        this.frame = frame;
        this.resourceManager = resourceManager;
        this.installdata = installDataGUI;
        this.conditionCheck = conditionCheck;
        this.setName(GuiId.DIALOG_PICKER.id);
        this.initLanguageDialog();
    }

    private void initLanguageDialog() {
        this.addWindowListener(new WindowHandler());
        JPanel contentPane = (JPanel)this.getContentPane();
        this.setTitle("Language Selection");
        GridBagLayout layout = new GridBagLayout();
        contentPane.setLayout(layout);
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 10;
        gbConstraints.insets = new Insets(5, 5, 5, 5);
        gbConstraints.fill = 2;
        gbConstraints.gridx = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.weighty = 1.0;
        gbConstraints.ipadx = 0;
        gbConstraints.ipady = 6;
        ImageIcon img = this.getImage();
        JLabel imgLabel = new JLabel(img);
        gbConstraints.gridy = 0;
        contentPane.add(imgLabel);
        String firstMessage = "Please select your language";
        if (this.getLangType().equals(LANGUAGE_DISPLAY_TYPES[0])) {
            firstMessage = "Please select your language below";
        }
        JLabel label1 = new JLabel(firstMessage, 10);
        gbConstraints.gridy = 1;
        gbConstraints.insets = new Insets(15, 5, 5, 5);
        layout.addLayoutComponent(label1, gbConstraints);
        contentPane.add(label1);
        gbConstraints.insets = new Insets(5, 5, 5, 5);
        Object[] listAvaibleLangPacks = this.resourceManager.getAvailableLangPacks().toArray();
        listAvaibleLangPacks = this.reviseItems(listAvaibleLangPacks);
        this.comboBox = new JComboBox<Object>(listAvaibleLangPacks);
        this.comboBox.setName(GuiId.COMBO_BOX_LANG_FLAG.id);
        if (this.useFlags()) {
            this.comboBox.setRenderer(new FlagRenderer(this.resourceManager));
        }
        gbConstraints.gridy = 3;
        layout.addLayoutComponent(this.comboBox, gbConstraints);
        contentPane.add(this.comboBox);
        gbConstraints.insets = new Insets(15, 5, 15, 5);
        JButton okButton = new JButton("OK");
        okButton.setName(GuiId.BUTTON_LANG_OK.id);
        okButton.addActionListener(this);
        gbConstraints.fill = 0;
        gbConstraints.gridy = 4;
        gbConstraints.anchor = 10;
        layout.addLayoutComponent(okButton, gbConstraints);
        contentPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        if (System.getProperty("mrj.version") == null) {
            this.pack();
        }
        this.setSize(this.getPreferredSize());
        Dimension frameSize = this.getSize();
        Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        this.setLocation(center.x - frameSize.width / 2, center.y - frameSize.height / 2 - 10);
        this.setResizable(true);
        this.setSelection(Locale.getDefault().getISO3Language().toLowerCase());
        this.setModal(true);
        this.toFront();
    }

    private Object[] reviseItems(Object[] items) {
        String langType = this.getLangType();
        if (langType.equals(LANGUAGE_DISPLAY_TYPES[0])) {
            return items;
        }
        if (langType.equals(LANGUAGE_DISPLAY_TYPES[1])) {
            return this.expandItems(items, new JComboBox().getFont());
        }
        if (langType.equals(LANGUAGE_DISPLAY_TYPES[2])) {
            return this.expandItems(items, null);
        }
        return items;
    }

    private Object[] expandItems(Object[] items, Font testFont) {
        int i;
        if (this.iso3Toiso2 == null) {
            this.iso3Toiso2 = new HashMap(32);
            isoTable = new HashMap();
            for (i = 0; i < LANG_CODES.length; ++i) {
                this.iso3Toiso2.put(LANG_CODES[i][0], LANG_CODES[i][1]);
            }
        }
        for (i = 0; i < items.length; ++i) {
            Object it = this.expandItem(items[i], testFont);
            isoTable.put(it, items[i]);
            items[i] = it;
        }
        return items;
    }

    private Object expandItem(Object item, Font testFont) {
        String iso2Str = this.iso3Toiso2.get(item);
        if (iso2Str == null && !this.isoMapExpanded) {
            this.isoMapExpanded = true;
            Locale[] locales = Locale.getAvailableLocales();
            for (int i = 0; i < locales.length; ++i) {
                this.iso3Toiso2.put(locales[i].getISO3Language(), locales[i].getLanguage());
            }
            iso2Str = this.iso3Toiso2.get(item);
        }
        if (iso2Str == null) {
            return item;
        }
        Locale locale = new Locale(iso2Str);
        if (testFont == null) {
            return locale.getDisplayLanguage();
        }
        String str = locale.getDisplayLanguage(locale);
        int cdut = testFont.canDisplayUpTo(str);
        if (cdut > -1) {
            str = locale.getDisplayLanguage();
        }
        return str;
    }

    public ImageIcon getImage() {
        ImageIcon img;
        try {
            img = this.resourceManager.getImageIconResource("installer.langsel.img", new String[0]);
        }
        catch (Exception err) {
            img = null;
        }
        return img;
    }

    public Object getSelection() {
        Object retval = null;
        if (isoTable != null) {
            retval = isoTable.get(this.comboBox.getSelectedItem());
        }
        return retval != null ? retval : this.comboBox.getSelectedItem();
    }

    public void setSelection(Object item) {
        Object mapped = null;
        if (isoTable != null) {
            for (Object key : isoTable.keySet()) {
                if (!isoTable.get(key).equals(item)) continue;
                mapped = key;
                break;
            }
        }
        if (mapped == null) {
            mapped = item;
        }
        this.comboBox.setSelectedItem(mapped);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String selectedPack = (String)this.getSelection();
        if (selectedPack == null) {
            throw new RuntimeException("installation canceled");
        }
        try {
            this.propagateLocale(selectedPack);
            this.installdata.configureGuiButtons();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.dispose();
    }

    public void runPicker() {
        this.frame.setVisible(false);
        this.setVisible(true);
    }

    protected String getLangType() {
        if (this.installdata.guiPrefs.modifier.containsKey("langDisplayType")) {
            String val = (String)this.installdata.guiPrefs.modifier.get("langDisplayType");
            val = val.toLowerCase();
            for (String aLANGUAGE_DISPLAY_TYPES : LANGUAGE_DISPLAY_TYPES) {
                if (!val.equalsIgnoreCase(aLANGUAGE_DISPLAY_TYPES)) continue;
                return val;
            }
            Debug.trace((Object)("Value for language display type not valid; value: " + val));
        }
        return LANGUAGE_DISPLAY_TYPES[0];
    }

    protected boolean useFlags() {
        return !this.installdata.guiPrefs.modifier.containsKey("useFlags") || !"no".equalsIgnoreCase((String)this.installdata.guiPrefs.modifier.get("useFlags"));
    }

    public void initLangPack() throws Exception {
        this.conditionCheck.check();
        List availableLangPacks = this.resourceManager.getAvailableLangPacks();
        int npacks = availableLangPacks.size();
        if (npacks != 1) {
            this.runPicker();
        }
        InstallerBase.refreshDynamicVariables((AutomatedInstallData)this.installdata, new VariableSubstitutor[]{new VariableSubstitutorImpl(this.installdata.getVariables())});
        if (!this.conditionCheck.checkInstallerRequirements(this)) {
            Debug.log((Object)"not all installerconditions are fulfilled.");
            System.exit(-1);
            return;
        }
    }

    private void propagateLocale(String selectedPack) throws Exception {
        InputStream in = this.resourceManager.getInputStream("langpacks/" + selectedPack + ".xml");
        this.installdata.setAndProcessLocal(selectedPack, new LocaleDatabase(in));
        this.resourceManager.setLocale(selectedPack);
    }

    public void showMissingRequirementMessage(String message) {
        JOptionPane.showMessageDialog(null, message);
    }

    static {
        LANG_CODES = new String[][]{{"cat", "ca"}, {"chn", "zh"}, {"cze", "cs"}, {"dan", "da"}, {"deu", "de"}, {"eng", "en"}, {"fin", "fi"}, {"fra", "fr"}, {"hun", "hu"}, {"ita", "it"}, {"jpn", "ja"}, {"mys", "ms"}, {"ned", "nl"}, {"nor", "no"}, {"pol", "pl"}, {"por", "pt"}, {"rom", "or"}, {"rus", "ru"}, {"spa", "es"}, {"svk", "sk"}, {"swe", "sv"}, {"tur", "tr"}, {"ukr", "uk"}};
        LANGUAGE_DISPLAY_TYPES = new String[]{"iso3", "native", "default"};
    }

    private static class FlagRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 3832899961942782769L;
        private TreeMap<String, ImageIcon> icons = new TreeMap();
        private TreeMap<String, ImageIcon> grayIcons = new TreeMap();
        private ResourceManager resourceManager;

        public FlagRenderer(ResourceManager resourceManager) {
            this.resourceManager = resourceManager;
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String iso3 = (String)value;
            this.setText(iso3);
            if (isoTable != null) {
                iso3 = (String)isoTable.get(iso3);
            }
            if (isSelected) {
                this.setForeground(list.getSelectionForeground());
                this.setBackground(list.getSelectionBackground());
            } else {
                this.setForeground(list.getForeground());
                this.setBackground(list.getBackground());
            }
            if (!this.icons.containsKey(iso3)) {
                ImageIcon icon = this.resourceManager.getImageIconResource("flag." + iso3, new String[0]);
                this.icons.put(iso3, icon);
                icon = new ImageIcon(GrayFilter.createDisabledImage(icon.getImage()));
                this.grayIcons.put(iso3, icon);
            }
            if (isSelected || index == -1) {
                this.setIcon(this.icons.get(iso3));
            } else {
                this.setIcon(this.grayIcons.get(iso3));
            }
            return this;
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            System.exit(0);
        }
    }
}

