/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.manager;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.api.container.BindeableContainer;
import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.handler.AbstractUIHandler;
import com.izforge.izpack.api.handler.AbstractUIProgressHandler;
import com.izforge.izpack.api.merge.Mergeable;
import com.izforge.izpack.data.PanelAction;
import com.izforge.izpack.installer.base.IzPanel;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.manager.DataValidatorFactory;
import com.izforge.izpack.installer.manager.PanelActionFactory;
import com.izforge.izpack.installer.unpacker.IUnpacker;
import com.izforge.izpack.merge.ClassResolver;
import com.izforge.izpack.merge.resolve.ClassPathCrawler;
import com.izforge.izpack.merge.resolve.MergeableResolver;
import com.izforge.izpack.merge.resolve.PathResolver;
import com.izforge.izpack.merge.resolve.ResolveUtils;
import com.izforge.izpack.util.OsConstraintHelper;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.picocontainer.Parameter;

public class PanelManager {
    private GUIInstallData installdata;
    private BindeableContainer installerContainer;
    private int lastVis;
    private ClassPathCrawler classPathCrawler;
    private static final Logger LOGGER = Logger.getLogger(PanelManager.class.getName());
    protected ArrayList<Integer> visiblePanelMapping;
    private PathResolver pathResolver;

    public PanelManager(GUIInstallData installDataGUI, BindeableContainer installerContainer, PathResolver pathResolver, MergeableResolver mergeableResolver, ClassPathCrawler classPathCrawler) throws ClassNotFoundException {
        this.installdata = installDataGUI;
        this.installerContainer = installerContainer;
        this.pathResolver = pathResolver;
        this.classPathCrawler = classPathCrawler;
        this.visiblePanelMapping = new ArrayList();
    }

    public PanelManager loadPanelsInContainer() throws ClassNotFoundException {
        List panelsOrder = this.installdata.getPanelsOrder();
        HashMap<Object, Class> mapPanel = new HashMap<Object, Class>();
        for (Panel panel : panelsOrder) {
            if (!OsConstraintHelper.oneMatchesCurrentSystem((List)panel.getOsConstraints())) continue;
            Class panelClass = this.classPathCrawler.searchClassInClassPath(panel.getClassName());
            if (panel.getPanelid() != null) {
                mapPanel.put(panel.getPanelid(), panelClass);
                continue;
            }
            mapPanel.put(panelClass, panelClass);
        }
        this.loadClassesInSamePackage(mapPanel);
        return this;
    }

    private void loadClassesInSamePackage(Map<Object, Class> mapPanel) {
        HashSet mergeableSet = new HashSet();
        final HashSet<Package> packageSet = new HashSet<Package>();
        for (Map.Entry<Object, Class> entry : mapPanel.entrySet()) {
            mergeableSet.addAll(this.pathResolver.getMergeablePackage(entry.getValue().getPackage()));
            packageSet.add(entry.getValue().getPackage());
        }
        HashSet<File> files = new HashSet<File>();
        for (Mergeable mergeable : mergeableSet) {
            files.addAll(mergeable.recursivelyListFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return ClassResolver.isFilePathInsidePackageSet((String)ResolveUtils.convertPathToPosixPath((File)pathname), (Set)packageSet);
                }
            }));
        }
        this.processPanelFiles(files, mapPanel);
    }

    private void processPanelFiles(Set<File> files, Map<Object, Class> mapPanel) {
        for (File file : files) {
            boolean isAbstract;
            if (!file.getAbsolutePath().endsWith(".class")) continue;
            Class aClass = this.classPathCrawler.searchClassInClassPath(ClassResolver.processFileToClassName((File)file));
            boolean bl = isAbstract = (aClass.getModifiers() & 0x400) == 1024;
            if (aClass.isInterface() || isAbstract) continue;
            mapPanel.put(aClass, aClass);
        }
        for (Map.Entry entry : mapPanel.entrySet()) {
            LOGGER.log(Level.INFO, "Adding class " + entry + " in container");
            this.installerContainer.addComponent(entry.getKey(), entry.getValue(), new Parameter[0]);
        }
    }

    public void instantiatePanels() throws ClassNotFoundException {
        List panelsOrder = this.installdata.getPanelsOrder();
        int curVisPanelNumber = 0;
        this.lastVis = 0;
        int count = 0;
        for (Panel panel : panelsOrder) {
            if (OsConstraintHelper.oneMatchesCurrentSystem((List)panel.getOsConstraints())) {
                Class aClass = this.classPathCrawler.searchClassInClassPath(panel.getClassName());
                this.executePreBuildActions(panel);
                IzPanel izPanel = panel.getPanelid() != null ? (IzPanel)this.installerContainer.getComponent((Object)panel.getPanelid()) : (IzPanel)this.installerContainer.getComponent(aClass);
                izPanel.setMetadata(panel);
                String dataValidator = panel.getValidator();
                if (dataValidator != null) {
                    izPanel.setValidationService(DataValidatorFactory.createDataValidator(dataValidator));
                }
                izPanel.setHelpUrl(panel.getHelpUrl(this.installdata.getLocaleISO3()));
                this.preValidateAction(panel, izPanel);
                this.postValidateAction(panel, izPanel);
                this.installdata.getPanels().add(izPanel);
                if (izPanel.isHidden()) {
                    this.visiblePanelMapping.add(count, -1);
                } else {
                    this.visiblePanelMapping.add(count, curVisPanelNumber);
                    ++curVisPanelNumber;
                    this.lastVis = count;
                }
                ++count;
                XMLElementImpl panelRoot = new XMLElementImpl(panel.getClassName(), this.installdata.getXmlData());
                String panelId = panel.getPanelid();
                if (panelId != null) {
                    panelRoot.setAttribute("id", panelId);
                }
                this.installdata.getXmlData().addChild((IXMLElement)panelRoot);
            }
            this.visiblePanelMapping.add(count, this.lastVis);
        }
    }

    public void executePreBuildActions(Panel panel) {
        List preConstgructionActions = panel.getPreConstructionActions();
        if (preConstgructionActions != null) {
            for (String preConstgructionAction : preConstgructionActions) {
                PanelAction action = PanelActionFactory.createPanelAction(preConstgructionAction);
                action.initialize(panel.getPanelActionConfiguration(preConstgructionAction));
                action.executeAction(AutomatedInstallData.getInstance(), null);
            }
        }
    }

    private void preValidateAction(Panel panel, IzPanel izPanel) {
        List preActivateActions = panel.getPreActivationActions();
        if (preActivateActions != null) {
            for (String panelActionClass : preActivateActions) {
                PanelAction action = PanelActionFactory.createPanelAction(panelActionClass);
                action.initialize(panel.getPanelActionConfiguration(panelActionClass));
                izPanel.addPreActivationAction(action);
            }
        }
    }

    private void postValidateAction(Panel panel, IzPanel izPanel) {
        List postValidateActions = panel.getPostValidationActions();
        if (postValidateActions != null) {
            for (String panelActionClass : postValidateActions) {
                PanelAction action = PanelActionFactory.createPanelAction(panelActionClass);
                action.initialize(panel.getPanelActionConfiguration(panelActionClass));
                izPanel.addPostValidationAction(action);
            }
        }
    }

    public boolean isVisible(int panelNumber) {
        return this.visiblePanelMapping.get(panelNumber) != -1;
    }

    public boolean isLast(int panelNumber) {
        return this.visiblePanelMapping.get(this.installdata.getPanels().size()) == panelNumber;
    }

    public int getPanelVisibilityNumber(int panel) {
        return this.visiblePanelMapping.get(panel);
    }

    public void setAbstractUIHandlerInContainer(AbstractUIHandler abstractUIHandlerInContainer) {
    }

    public int getCountVisiblePanel() {
        return this.lastVis;
    }

    public IUnpacker getUnpacker(AbstractUIProgressHandler listener) {
        this.setAbstractUIHandlerInContainer((AbstractUIHandler)listener);
        return (IUnpacker)this.installerContainer.getComponent(IUnpacker.class);
    }
}

