/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.multiunpacker;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.handler.AbstractUIProgressHandler;
import com.izforge.izpack.installer.base.InstallerFrame;
import com.izforge.izpack.installer.base.IzPanel;
import com.izforge.izpack.installer.multiunpacker.NextMediaDialog;
import com.izforge.izpack.installer.unpacker.IMultiVolumeUnpackerHelper;
import com.izforge.izpack.util.Debug;
import java.awt.Frame;
import java.io.File;
import javax.swing.JOptionPane;

public class MultiVolumeUnpackerHelper
implements IMultiVolumeUnpackerHelper {
    private AutomatedInstallData idata;
    private AbstractUIProgressHandler handler;

    @Override
    public File enterNextMediaMessage(String volumename, boolean lastcorrupt) {
        if (lastcorrupt) {
            InstallerFrame parent = null;
            if (this.handler != null && this.handler instanceof IzPanel) {
                parent = ((IzPanel)this.handler).getInstallerFrame();
            }
            JOptionPane.showMessageDialog(parent, this.idata.getLangpack().getString("nextmedia.corruptmedia"), this.idata.getLangpack().getString("nextmedia.corruptmedia.title"), 0);
        }
        Debug.trace((Object)("Enter next media: " + volumename));
        File nextvolume = new File(volumename);
        NextMediaDialog nextMediaDialog = null;
        while (!nextvolume.exists() || lastcorrupt) {
            if (this.handler != null && this.handler instanceof IzPanel) {
                InstallerFrame installframe = ((IzPanel)this.handler).getInstallerFrame();
                nextMediaDialog = new NextMediaDialog((Frame)installframe, this.idata, volumename);
            } else {
                nextMediaDialog = new NextMediaDialog(null, this.idata, volumename);
            }
            nextMediaDialog.setVisible(true);
            String nextmediainput = nextMediaDialog.getNextMedia();
            if (nextmediainput != null) {
                nextvolume = new File(nextmediainput);
            } else {
                Debug.trace((Object)"Input from NextMediaDialog was null");
                nextvolume = new File(volumename);
            }
            if (volumename.equals(nextvolume.getAbsolutePath()) && lastcorrupt) continue;
            lastcorrupt = false;
        }
        return nextvolume;
    }

    @Override
    public File enterNextMediaMessage(String volumename) {
        return this.enterNextMediaMessage(volumename, false);
    }

    @Override
    public void init(AutomatedInstallData idata, AbstractUIProgressHandler handler) {
        this.idata = idata;
        this.handler = handler;
    }
}

