/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.unpacker;

import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.data.ParsableFile;
import com.izforge.izpack.installer.unpacker.Unpacker;
import com.izforge.izpack.util.OsConstraintHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;

public class ScriptParser {
    private Collection<ParsableFile> files;
    private VariableSubstitutor vs;

    public ScriptParser(Collection<ParsableFile> files, VariableSubstitutor vs) {
        this.files = files;
        this.vs = vs;
    }

    public void parseFiles() throws Exception {
        for (ParsableFile pfile : this.files) {
            if (Unpacker.isInterruptDesired()) {
                return;
            }
            if (!OsConstraintHelper.oneMatchesCurrentSystem((List)pfile.osConstraints)) continue;
            File file = new File(pfile.path);
            File parsedFile = File.createTempFile("izpp", null, file.getParentFile());
            FileInputStream inFile = new FileInputStream(file);
            BufferedInputStream in = new BufferedInputStream(inFile, 5120);
            FileOutputStream outFile = new FileOutputStream(parsedFile);
            BufferedOutputStream out = new BufferedOutputStream(outFile, 5120);
            this.vs.substitute((InputStream)in, (OutputStream)out, pfile.type, pfile.encoding);
            in.close();
            out.close();
            file.delete();
            if (parsedFile.renameTo(file)) continue;
            throw new IOException("Could not rename file " + parsedFile + " to " + file);
        }
    }
}

