/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.unpacker;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.OverrideType;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.data.PackFile;
import com.izforge.izpack.api.data.ResourceManager;
import com.izforge.izpack.api.event.InstallerListener;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.api.handler.AbstractUIHandler;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.data.ExecutableFile;
import com.izforge.izpack.data.ParsableFile;
import com.izforge.izpack.data.UpdateCheck;
import com.izforge.izpack.installer.data.UninstallData;
import com.izforge.izpack.installer.unpacker.ScriptParser;
import com.izforge.izpack.installer.unpacker.UnpackerBase;
import com.izforge.izpack.installer.web.WebAccessor;
import com.izforge.izpack.installer.web.WebRepositoryAccessor;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsConstraintHelper;
import com.izforge.izpack.util.os.FileQueue;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;

public class Unpacker
extends UnpackerBase {
    private static final String tempSubPath = "/IzpackWebTemp";
    private Pack200.Unpacker unpacker;

    public Unpacker(AutomatedInstallData idata, ResourceManager resourceManager, RulesEngine rules, VariableSubstitutor variableSubstitutor, UninstallData udata) {
        super(idata, resourceManager, rules, variableSubstitutor, udata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.addToInstances();
        try {
            FileQueue fq = null;
            ArrayList<ParsableFile> parsables = new ArrayList<ParsableFile>();
            ArrayList<ExecutableFile> executables = new ArrayList<ExecutableFile>();
            ArrayList<UpdateCheck> updatechecks = new ArrayList<UpdateCheck>();
            List packs = this.idata.getSelectedPacks();
            int npacks = packs.size();
            this.handler.startAction("Unpacking", npacks);
            List customActions = this.idata.getInstallerListener();
            this.informListeners((List<InstallerListener>)customActions, 7, this.idata, (Integer)npacks, this.handler);
            packs = this.idata.getSelectedPacks();
            npacks = packs.size();
            for (int i = 0; i < npacks; ++i) {
                String name;
                Pack p = (Pack)packs.get(i);
                if (p.hasCondition() && this.rules != null && !this.rules.isConditionTrue(p.getCondition())) continue;
                this.informListeners((List<InstallerListener>)customActions, 5, (Pack)packs.get(i), (Integer)npacks, this.handler);
                ObjectInputStream objIn = new ObjectInputStream(this.getPackAsStream(p.id, p.uninstall));
                int nfiles = objIn.readInt();
                Pack pack = (Pack)packs.get(i);
                String stepname = pack.name;
                if (pack.id != null && !"".equals(pack.id) && (name = this.idata.getLangpack().getString(pack.id)) != null && !"".equals(name)) {
                    stepname = name;
                }
                if (pack.isHidden()) {
                    stepname = "";
                }
                this.handler.nextStep(stepname, i + 1, nfiles);
                for (int j = 0; j < nfiles; ++j) {
                    PackFile pf = (PackFile)objIn.readObject();
                    if (pf.hasCondition() && this.rules != null && !this.rules.isConditionTrue(pf.getCondition())) {
                        if (pf.isBackReference()) continue;
                        objIn.skip(pf.length());
                        continue;
                    }
                    if (OsConstraintHelper.oneMatchesCurrentSystem((List)pf.osConstraints())) {
                        FileOutputStream out;
                        File pathFile;
                        String path = IoHelper.translatePath((String)pf.getTargetPath(), (VariableSubstitutor)this.variableSubstitutor);
                        File dest = pathFile = new File(path);
                        if (!pf.isDirectory()) {
                            dest = pathFile.getParentFile();
                        }
                        this.handleMkDirs(pf, dest);
                        this.udata.addFile(path, pack.uninstall);
                        if (pf.isDirectory()) continue;
                        this.informListeners((List<InstallerListener>)customActions, 1, pathFile, pf, null);
                        this.handler.progress(j, path);
                        if (pathFile.exists() && pf.override() != OverrideType.OVERRIDE_TRUE && !this.isOverwriteFile(pf, pathFile)) {
                            if (pf.isBackReference() || ((Pack)packs.get((int)i)).loose) continue;
                            if (pf.isPack200Jar()) {
                                objIn.skip(4L);
                                continue;
                            }
                            objIn.skip(pf.length());
                            continue;
                        }
                        this.handleOverrideRename(pf, pathFile);
                        InputStream pis = objIn;
                        if (pf.isBackReference()) {
                            InputStream is = this.getPackAsStream(pf.previousPackId, pack.uninstall);
                            pis = new ObjectInputStream(is);
                            is.skip(pf.offsetInPreviousPack - 4L);
                        } else if (((Pack)packs.get((int)i)).loose) {
                            File resolvedFile = new File(this.getAbsolutInstallSource(), pf.getRelativeSourcePath());
                            if (!resolvedFile.exists()) {
                                File userDir = new File(System.getProperty("user.dir"));
                                resolvedFile = new File(userDir, pf.getRelativeSourcePath());
                            }
                            if (resolvedFile.exists()) {
                                pis = new FileInputStream(resolvedFile);
                                pf = new PackFile(resolvedFile.getParentFile(), resolvedFile, pf.getTargetPath(), pf.osConstraints(), pf.override(), pf.overrideRenameTo(), pf.blockable(), pf.getAdditionals());
                            } else {
                                System.out.println("Could not find loosely bundled file: " + pf.getRelativeSourcePath());
                                if (this.handler.emitWarning("File not found", "Could not find loosely bundled file: " + pf.getRelativeSourcePath())) continue;
                                throw new InstallerException("Installation cancelled");
                            }
                        }
                        File tmpFile = null;
                        if (this.blockableForCurrentOs(pf)) {
                            tmpFile = File.createTempFile("__FQ__", null, pathFile.getParentFile());
                            out = new FileOutputStream(tmpFile);
                        } else {
                            out = new FileOutputStream(pathFile);
                        }
                        if (pf.isPack200Jar()) {
                            int key = objIn.readInt();
                            InputStream pack200Input = this.resourceManager.getInputStream("/packs/pack200-" + key);
                            Pack200.Unpacker unpacker = this.getPack200Unpacker();
                            JarOutputStream jarOut = new JarOutputStream(out);
                            unpacker.unpack(pack200Input, jarOut);
                            jarOut.close();
                        } else {
                            byte[] buffer = new byte[5120];
                            long bytesCopied = 0L;
                            while (bytesCopied < pf.length()) {
                                if (this.performInterrupted()) {
                                    out.close();
                                    if (pis != objIn) {
                                        pis.close();
                                    }
                                    return;
                                }
                                bytesCopied = this.writeBuffer(pf, buffer, out, pis, bytesCopied);
                            }
                            out.close();
                        }
                        if (pis != objIn) {
                            pis.close();
                        }
                        this.handleTimeStamp(pf, pathFile, tmpFile);
                        fq = this.handleBlockable(pf, pathFile, tmpFile, fq, customActions);
                        continue;
                    }
                    if (pf.isBackReference()) continue;
                    objIn.skip(pf.length());
                }
                int numParsables = objIn.readInt();
                for (int k = 0; k < numParsables; ++k) {
                    ParsableFile pf = (ParsableFile)objIn.readObject();
                    if (pf.hasCondition() && this.rules != null && !this.rules.isConditionTrue(pf.getCondition())) continue;
                    pf.path = IoHelper.translatePath((String)pf.path, (VariableSubstitutor)this.variableSubstitutor);
                    parsables.add(pf);
                }
                this.loadExecutables(objIn, executables);
                int numUpdateChecks = objIn.readInt();
                for (int k = 0; k < numUpdateChecks; ++k) {
                    UpdateCheck updateCheck = (UpdateCheck)objIn.readObject();
                    updatechecks.add(updateCheck);
                }
                objIn.close();
                if (this.performInterrupted()) {
                    return;
                }
                this.informListeners((List<InstallerListener>)customActions, 6, (Pack)packs.get(i), (Integer)i, this.handler);
            }
            if (fq != null) {
                fq.execute();
                this.idata.setRebootNecessary(fq.isRebootNecessary());
            }
            ScriptParser parser = new ScriptParser(parsables, this.variableSubstitutor);
            parser.parseFiles();
            if (this.performInterrupted()) {
                return;
            }
            FileExecutor executor = new FileExecutor(executables);
            if (executor.executeFiles(0, (AbstractUIHandler)this.handler) != 0) {
                this.handler.emitError("File execution failed", "The installation was not completed");
                this.result = false;
            }
            if (this.performInterrupted()) {
                return;
            }
            this.performUpdateChecks(updatechecks);
            if (this.performInterrupted()) {
                return;
            }
            this.informListeners((List<InstallerListener>)customActions, 8, this.idata, (Integer)npacks, this.handler);
            if (this.performInterrupted()) {
                return;
            }
            this.writeInstallationInformation();
            this.handler.stopAction();
        }
        catch (Exception err) {
            this.handler.stopAction();
            String message = err.getMessage();
            if ("Installation cancelled".equals(message)) {
                this.handler.emitNotification("Installation cancelled");
            } else {
                if (message == null || "".equals(message)) {
                    message = "Internal error occured : " + err.toString();
                }
                this.handler.emitError("An error occured", message);
                err.printStackTrace();
            }
            this.result = false;
            Housekeeper.getInstance().shutDown(4);
        }
        finally {
            this.removeFromInstances();
        }
    }

    private Pack200.Unpacker getPack200Unpacker() {
        if (this.unpacker == null) {
            this.unpacker = Pack200.newUnpacker();
        }
        return this.unpacker;
    }

    private InputStream getPackAsStream(String packid, boolean uninstall) throws Exception {
        InputStream in;
        String webDirURL = this.idata.getInfo().getWebDirURL();
        packid = "-" + packid;
        if (webDirURL == null) {
            in = this.resourceManager.getInputStream("packs/pack" + packid);
        } else {
            String tempfile;
            String baseName = this.idata.getInfo().getInstallerBase();
            String packURL = webDirURL + "/" + baseName + ".pack" + packid + ".jar";
            String tempFolder = IoHelper.translatePath((String)(this.idata.getInfo().getUninstallerPath() + tempSubPath), (VariableSubstitutor)this.variableSubstitutor);
            try {
                tempfile = WebRepositoryAccessor.getCachedUrl(packURL, tempFolder);
                this.udata.addFile(tempfile, uninstall);
            }
            catch (Exception e) {
                if ("Cancelled".equals(e.getMessage())) {
                    throw new InstallerException("Installation cancelled", (Throwable)e);
                }
                throw new InstallerException("Installation failed", (Throwable)e);
            }
            URL url = new URL("jar:" + tempfile + "!/packs/pack" + packid);
            in = new WebAccessor(null).openInputStream(url);
            if (in == null) {
                throw new InstallerException(url.toString() + " not available", (Throwable)new FileNotFoundException(url.toString()));
            }
        }
        if (in != null && this.idata.getInfo().getPackDecoderClassName() != null) {
            Class<?> decoder = Class.forName(this.idata.getInfo().getPackDecoderClassName());
            Class[] paramsClasses = new Class[]{Class.forName("java.io.InputStream")};
            Constructor<?> constructor = decoder.getDeclaredConstructor(paramsClasses);
            BufferedInputStream buffer = new BufferedInputStream(in);
            Object[] params = new Object[]{buffer};
            Object instance = null;
            instance = constructor.newInstance(params);
            if (!InputStream.class.isInstance(instance)) {
                throw new InstallerException("'" + this.idata.getInfo().getPackDecoderClassName() + "' must be derived from " + InputStream.class.toString());
            }
            in = instance;
        }
        return in;
    }
}

