/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.unpacker;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.Blockable;
import com.izforge.izpack.api.data.OverrideType;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.data.PackFile;
import com.izforge.izpack.api.data.ResourceManager;
import com.izforge.izpack.api.event.InstallerListener;
import com.izforge.izpack.api.handler.AbstractUIProgressHandler;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.api.unpacker.IDiscardInterruptable;
import com.izforge.izpack.data.ExecutableFile;
import com.izforge.izpack.data.UpdateCheck;
import com.izforge.izpack.installer.data.UninstallData;
import com.izforge.izpack.installer.unpacker.IUnpacker;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.file.DirectoryScanner;
import com.izforge.izpack.util.file.GlobPatternMapper;
import com.izforge.izpack.util.file.types.FileSet;
import com.izforge.izpack.util.os.FileQueue;
import com.izforge.izpack.util.os.FileQueueMove;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public abstract class UnpackerBase
implements IUnpacker,
IDiscardInterruptable {
    protected AutomatedInstallData idata;
    protected AbstractUIProgressHandler handler;
    protected UninstallData udata;
    protected File absolute_installpath;
    private File absolutInstallSource;
    protected boolean result = true;
    protected static HashMap<Object, String> instances = new HashMap();
    protected static boolean interruptDesired = false;
    protected static boolean discardInterrupt = false;
    protected static final String LANG_FILE_NAME = "packsLang.xml";
    public static final String ALIVE = "alive";
    public static final String INTERRUPT = "doInterrupt";
    public static final String INTERRUPTED = "interruppted";
    protected RulesEngine rules;
    protected ResourceManager resourceManager;
    protected VariableSubstitutor variableSubstitutor;

    public UnpackerBase(AutomatedInstallData idata, ResourceManager resourceManager, RulesEngine rules, VariableSubstitutor variableSubstitutor, UninstallData udata) {
        this.idata = idata;
        this.resourceManager = resourceManager;
        this.rules = rules;
        this.variableSubstitutor = variableSubstitutor;
        this.udata = udata;
    }

    @Override
    public void setRules(RulesEngine rules) {
        this.rules = rules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap getRunningInstances() {
        HashMap<Object, String> hashMap = instances;
        synchronized (hashMap) {
            return (HashMap)instances.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToInstances() {
        HashMap<Object, String> hashMap = instances;
        synchronized (hashMap) {
            instances.put(this, ALIVE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromInstances() {
        HashMap<Object, String> hashMap = instances;
        synchronized (hashMap) {
            instances.remove(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setInterruptAll() {
        HashMap<Object, String> hashMap = instances;
        synchronized (hashMap) {
            for (Object key : instances.keySet()) {
                if (!instances.get(key).equals(ALIVE)) continue;
                instances.put(key, INTERRUPT);
            }
            UnpackerBase.setInterruptDesired(true);
        }
    }

    public static boolean interruptAll(long waitTime) {
        long t0 = System.currentTimeMillis();
        if (UnpackerBase.isDiscardInterrupt()) {
            return false;
        }
        UnpackerBase.setInterruptAll();
        while (!UnpackerBase.isInterruptReady()) {
            if (System.currentTimeMillis() - t0 > waitTime) {
                return true;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {}
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isInterruptReady() {
        HashMap<Object, String> hashMap = instances;
        synchronized (hashMap) {
            for (Object key : instances.keySet()) {
                if (instances.get(key).equals(INTERRUPTED)) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean performInterrupted() {
        HashMap<Object, String> hashMap = instances;
        synchronized (hashMap) {
            String doIt = instances.get(this);
            if (doIt != null && (doIt.equals(INTERRUPT) || doIt.equals(INTERRUPTED))) {
                instances.put(this, INTERRUPTED);
                this.result = false;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldInterrupt() {
        HashMap<Object, String> hashMap = instances;
        synchronized (hashMap) {
            String doIt = instances.get(this);
            return doIt != null && (doIt.equals(INTERRUPT) || doIt.equals(INTERRUPTED));
            {
            }
        }
    }

    @Override
    public boolean getResult() {
        return this.result;
    }

    protected void informListeners(List<InstallerListener> customActions, int action, File file, PackFile packFile, AbstractUIProgressHandler abstractUIProgressHandler) throws Exception {
        for (InstallerListener installerListener : customActions) {
            if (this.shouldInterrupt()) {
                return;
            }
            switch (action) {
                case 1: {
                    installerListener.beforeFile(file, packFile);
                    break;
                }
                case 2: {
                    installerListener.afterFile(file, packFile);
                    break;
                }
                case 3: {
                    installerListener.beforeDir(file, packFile);
                    break;
                }
                case 4: {
                    installerListener.afterDir(file, packFile);
                }
            }
        }
    }

    protected void informListeners(List<InstallerListener> customActions, int action, Pack pack, Integer integer, AbstractUIProgressHandler abstractUIProgressHandler) throws Exception {
        for (InstallerListener customAction : customActions) {
            switch (action) {
                case 5: {
                    customAction.beforePack(pack, integer, abstractUIProgressHandler);
                    break;
                }
                case 6: {
                    customAction.afterPack(pack, integer, abstractUIProgressHandler);
                }
            }
        }
    }

    protected void informListeners(List<InstallerListener> customActions, int action, AutomatedInstallData pack, Integer integer, AbstractUIProgressHandler abstractUIProgressHandler) throws Exception {
        for (InstallerListener customAction : customActions) {
            switch (action) {
                case 7: {
                    customAction.beforePacks(pack, integer, abstractUIProgressHandler);
                    break;
                }
                case 8: {
                    customAction.afterPacks(pack, abstractUIProgressHandler);
                }
            }
        }
    }

    protected boolean mkDirsWithEnhancement(File dest, PackFile pf, List<InstallerListener> customActions) throws Exception {
        boolean ok = true;
        if (!dest.exists()) {
            File parent = dest.getParentFile();
            if (parent != null) {
                ok = this.mkDirsWithEnhancement(parent, pf, customActions);
            }
            if (ok) {
                this.informListeners(customActions, 3, dest, pf, null);
                ok = dest.mkdir();
                if (!ok) {
                    this.handler.emitError("Error creating directories", "Could not create directory\n" + dest);
                    this.handler.stopAction();
                } else {
                    this.informListeners(customActions, 4, dest, pf, null);
                }
            }
        } else {
            ok = true;
        }
        return ok;
    }

    public static synchronized boolean isDiscardInterrupt() {
        return discardInterrupt;
    }

    public synchronized void setDiscardInterrupt(boolean di) {
        discardInterrupt = di;
        UnpackerBase.setInterruptDesired(false);
    }

    public static boolean isInterruptDesired() {
        return interruptDesired;
    }

    private static void setInterruptDesired(boolean interruptDesired) {
        UnpackerBase.interruptDesired = interruptDesired;
    }

    @Override
    public abstract void run();

    protected void performUpdateChecks(ArrayList<UpdateCheck> updatechecks) {
        if (updatechecks != null && updatechecks.size() > 0) {
            FileSet fileset = new FileSet();
            ArrayList<File> files_to_delete = new ArrayList<File>();
            ArrayList<File> dirs_to_delete = new ArrayList<File>();
            try {
                fileset.setDir(new File(this.idata.getInstallPath()).getAbsoluteFile());
                for (UpdateCheck uc : updatechecks) {
                    if (uc.includesList != null) {
                        for (String incl : uc.includesList) {
                            fileset.createInclude().setName(this.variableSubstitutor.substitute(incl));
                        }
                    }
                    if (uc.excludesList == null) continue;
                    for (String excl : uc.excludesList) {
                        fileset.createExclude().setName(this.variableSubstitutor.substitute(excl));
                    }
                }
                DirectoryScanner ds = fileset.getDirectoryScanner();
                ds.scan();
                String[] srcFiles = ds.getIncludedFiles();
                String[] srcDirs = ds.getIncludedDirectories();
                TreeSet<File> installed_files = new TreeSet<File>();
                for (String fname : this.udata.getInstalledFilesList()) {
                    File f = new File(fname);
                    if (!f.isAbsolute()) {
                        f = new File(this.absolute_installpath, fname);
                    }
                    installed_files.add(f);
                }
                for (String srcFile : srcFiles) {
                    File newFile = new File(ds.getBasedir(), srcFile);
                    if (installed_files.contains(newFile)) continue;
                    files_to_delete.add(newFile);
                }
                for (String srcDir : srcDirs) {
                    File newDir = new File(ds.getBasedir(), srcDir);
                    if (installed_files.contains(newDir)) continue;
                    dirs_to_delete.add(newDir);
                }
            }
            catch (Exception e) {
                this.handler.emitError("Error while performing update checks", e.getMessage());
            }
            for (File f : files_to_delete) {
                f.delete();
            }
            for (File d : dirs_to_delete) {
                d.delete();
            }
        }
    }

    public void writeInstallationInformation() throws IOException, ClassNotFoundException {
        if (!this.idata.getInfo().isWriteInstallationInformation()) {
            Debug.trace((Object)"skip writing installation information");
            return;
        }
        Debug.trace((Object)"writing installation information");
        String installdir = this.idata.getInstallPath();
        ArrayList<Pack> installedpacks = new ArrayList<Pack>(this.idata.getSelectedPacks());
        File installationinfo = new File(installdir + File.separator + ".installationinformation");
        if (!installationinfo.exists()) {
            Debug.trace((Object)("creating info file" + installationinfo.getAbsolutePath()));
            installationinfo.createNewFile();
        } else {
            Debug.trace((Object)"installation information found");
            FileInputStream fin = new FileInputStream(installationinfo);
            ObjectInputStream oin = new ObjectInputStream(fin);
            List packs = (List)oin.readObject();
            Iterator i$ = packs.iterator();
            while (i$.hasNext()) {
                Pack pack1;
                Pack pack = pack1 = (Pack)i$.next();
                installedpacks.add(pack);
            }
            oin.close();
            fin.close();
        }
        FileOutputStream fout = new FileOutputStream(installationinfo);
        ObjectOutputStream oout = new ObjectOutputStream(fout);
        oout.writeObject(installedpacks);
        oout.writeObject(this.idata.getVariables());
        Debug.trace((Object)"done.");
        oout.close();
        fout.close();
    }

    protected File getAbsolutInstallSource() throws Exception {
        if (this.absolutInstallSource == null) {
            URI uri = this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI();
            if (!"file".equals(uri.getScheme())) {
                throw new Exception("Unexpected scheme in JAR file URI: " + uri);
            }
            this.absolutInstallSource = new File(uri.getSchemeSpecificPart()).getAbsoluteFile();
            if (this.absolutInstallSource.getName().endsWith(".jar")) {
                this.absolutInstallSource = this.absolutInstallSource.getParentFile();
            }
        }
        return this.absolutInstallSource;
    }

    protected boolean blockableForCurrentOs(PackFile pf) {
        return pf.blockable() != Blockable.BLOCKABLE_NONE && OsVersion.IS_WINDOWS;
    }

    @Override
    public void setHandler(AbstractUIProgressHandler handler) {
        this.handler = handler;
    }

    protected void handleMkDirs(PackFile pf, File dest) throws Exception {
        if (!dest.exists()) {
            if (!this.idata.getInstallerListener().isEmpty()) {
                this.mkDirsWithEnhancement(dest, pf, this.idata.getInstallerListener());
            } else if (!dest.mkdirs()) {
                this.handler.emitError("Error creating directories", "Could not create directory\n" + dest.getPath());
                this.handler.stopAction();
                this.result = false;
                return;
            }
        }
    }

    protected long writeBuffer(PackFile pf, byte[] buffer, FileOutputStream out, InputStream pis, long bytesCopied) throws IOException {
        int maxBytes = (int)Math.min(pf.length() - bytesCopied, (long)buffer.length);
        int bytesInBuffer = pis.read(buffer, 0, maxBytes);
        if (bytesInBuffer == -1) {
            throw new IOException("Unexpected end of stream (installer corrupted?)");
        }
        out.write(buffer, 0, bytesInBuffer);
        return bytesCopied += (long)bytesInBuffer;
    }

    protected boolean isOverwriteFile(PackFile pf, File file) {
        boolean overwritefile = false;
        if (pf.override() != OverrideType.OVERRIDE_FALSE) {
            if (pf.override() == OverrideType.OVERRIDE_TRUE) {
                overwritefile = true;
            } else if (pf.override() == OverrideType.OVERRIDE_UPDATE) {
                overwritefile = file.lastModified() < pf.lastModified();
            } else {
                int answer;
                int def_choice = -1;
                if (pf.override() == OverrideType.OVERRIDE_ASK_FALSE) {
                    def_choice = 49;
                }
                if (pf.override() == OverrideType.OVERRIDE_ASK_TRUE) {
                    def_choice = 47;
                }
                overwritefile = (answer = this.handler.askQuestion(this.idata.getLangpack().getString("InstallPanel.overwrite.title") + " - " + file.getName(), this.idata.getLangpack().getString("InstallPanel.overwrite.question") + file.getAbsolutePath(), 37, def_choice)) == 47;
            }
        }
        return overwritefile;
    }

    protected void handleOverrideRename(PackFile pf, File file) {
        if (file.exists() && pf.overrideRenameTo() != null) {
            GlobPatternMapper mapper = new GlobPatternMapper();
            mapper.setFrom("*");
            mapper.setTo(pf.overrideRenameTo());
            mapper.setCaseSensitive(true);
            String[] newFileNameArr = mapper.mapFileName(file.getName());
            if (newFileNameArr != null) {
                String newFileName = newFileNameArr[0];
                File newPathFile = new File(file.getParent(), newFileName);
                if (newPathFile.exists()) {
                    newPathFile.delete();
                }
                if (!file.renameTo(newPathFile)) {
                    this.handler.emitError("Error renaming file", "The file " + file + " could not be renamed to " + newPathFile);
                }
            } else {
                this.handler.emitError("Error renaming file", "File name " + file.getName() + " cannot be mapped using the expression \"" + pf.overrideRenameTo() + "\"");
            }
        }
    }

    protected void handleTimeStamp(PackFile pf, File file, File tmpFile) {
        if (pf.lastModified() >= 0L) {
            if (this.blockableForCurrentOs(pf)) {
                tmpFile.setLastModified(pf.lastModified());
            } else {
                file.setLastModified(pf.lastModified());
            }
        }
    }

    protected FileQueue handleBlockable(PackFile pf, File file, File tmpFile, FileQueue fq, List<InstallerListener> customActions) throws Exception {
        if (this.blockableForCurrentOs(pf)) {
            if (fq == null) {
                fq = new FileQueue();
            }
            FileQueueMove fqmv = new FileQueueMove(tmpFile, file);
            if (this.blockableForCurrentOs(pf)) {
                fqmv.setForceInUse(true);
            }
            fqmv.setOverwrite(true);
            fq.add(fqmv);
            Debug.log((Object)(tmpFile.getAbsolutePath() + " -> " + file.getAbsolutePath() + " added to file queue for being copied after reboot"));
            tmpFile.deleteOnExit();
        } else {
            this.informListeners(customActions, 2, file, pf, null);
        }
        return fq;
    }

    protected void loadExecutables(ObjectInputStream objIn, ArrayList<ExecutableFile> executables) throws IOException, ClassNotFoundException {
        int numExecutables = objIn.readInt();
        for (int k = 0; k < numExecutables; ++k) {
            ExecutableFile ef = (ExecutableFile)objIn.readObject();
            if (ef.hasCondition() && this.rules != null && !this.rules.isConditionTrue(ef.getCondition())) continue;
            ef.path = IoHelper.translatePath((String)ef.path, (VariableSubstitutor)this.variableSubstitutor);
            if (null != ef.argList && !ef.argList.isEmpty()) {
                String arg = null;
                for (int j = 0; j < ef.argList.size(); ++j) {
                    arg = (String)ef.argList.get(j);
                    arg = IoHelper.translatePath((String)arg, (VariableSubstitutor)this.variableSubstitutor);
                    ef.argList.set(j, arg);
                }
            }
            executables.add(ef);
            if (ef.executionStage != 2) continue;
            this.udata.addExecutable(ef);
        }
    }
}

