/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.web;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.impl.XMLParser;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.exception.CompilerException;
import com.izforge.izpack.api.substitutor.SubstitutionType;
import com.izforge.izpack.data.ExecutableFile;
import com.izforge.izpack.data.PackInfo;
import com.izforge.izpack.data.ParsableFile;
import com.izforge.izpack.data.UpdateCheck;
import com.izforge.izpack.installer.web.WebAccessor;
import com.izforge.izpack.util.OsConstraintHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class WebRepositoryAccessor {
    private String installXmlUrl;
    private String baseUrl;
    private String installXmlString;
    private String packsInfo;
    private ArrayList<PackInfo> packs;
    private static boolean YES = true;
    private static boolean NO = false;
    private static final String installFilename = "install.xml";
    private static final String packsinfoFilename = "packsinfo.xml";
    private static final int BUFFER_SIZE = 1000000;

    public WebRepositoryAccessor(String urlbase) {
        this.installXmlUrl = urlbase + "/" + installFilename;
        this.baseUrl = urlbase;
    }

    public ArrayList<PackInfo> getOnlinePacks() {
        this.readConfig();
        this.packs = this.parsePacks();
        this.readPacksInfo();
        this.parsePacksInfo();
        return this.packs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String stringFromURL(String url) {
        int max = 1000000;
        byte[] raw = new byte[max];
        InputStream in = null;
        try {
            int r;
            WebAccessor webAccessor = new WebAccessor(null);
            in = webAccessor.openInputStream(new URL(url));
            if (in == null) {
                throw new RuntimeException("Unable to open network stream");
            }
            int off = r = in.read(raw);
            while (r > 0) {
                r = in.read(raw, off, max - off);
                off += r;
            }
            String string = new String(raw);
            return string;
        }
        catch (Exception e) {
            System.out.println(e + " while trying to download " + url);
            String string = null;
            return string;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {}
        }
    }

    private void readConfig() {
        this.installXmlString = this.stringFromURL(this.installXmlUrl);
    }

    private void readPacksInfo() {
        String url = this.baseUrl + "/" + packsinfoFilename;
        this.packsInfo = this.stringFromURL(url);
    }

    private ArrayList<PackInfo> parsePacks() {
        try {
            XMLParser parser = new XMLParser();
            IXMLElement xml = parser.parse(this.installXmlString);
            return this.loadPacksList(xml);
        }
        catch (Exception e) {
            System.out.println("WARN: Unable to parse install.xml");
            return null;
        }
    }

    private void parsePacksInfo() {
        try {
            IXMLElement xml;
            XMLParser parser = new XMLParser();
            IXMLElement root = xml = parser.parse(this.packsInfo);
            for (int i = 0; i < root.getChildrenCount(); ++i) {
                IXMLElement packElement = root.getChildAtIndex(i);
                PackInfo packInfo = this.packs.get(i);
                Pack pack = packInfo.getPack();
                pack.nbytes = Long.parseLong(packElement.getAttribute("nbytes"));
            }
        }
        catch (Exception e) {
            System.out.println("WARN: Unable to parse packsinfo.xml");
        }
    }

    public static String getCachedUrl(String url, String tempFolder) throws Exception {
        int max = 1000000;
        byte[] raw = new byte[max];
        try {
            WebAccessor webAccessor = new WebAccessor(null);
            InputStream in = webAccessor.openInputStream(new URL(url));
            int r = in.read(raw);
            File tempDir = new File(tempFolder);
            tempDir.mkdirs();
            File temp = File.createTempFile("izpacktempfile", "jar", new File(tempFolder));
            FileOutputStream fos = new FileOutputStream(temp);
            String path = "file:///" + temp.getAbsolutePath();
            while (r > 0) {
                fos.write(raw, 0, r);
                r = in.read(raw);
            }
            in.close();
            fos.close();
            return path;
        }
        catch (SecurityException e) {
            System.out.println(e + " while trying to write temp file: " + tempFolder);
            throw e;
        }
        catch (Exception e) {
            System.out.println(e + " while trying to download " + url);
            throw e;
        }
    }

    protected ArrayList<PackInfo> loadPacksList(IXMLElement data) throws CompilerException {
        ArrayList<PackInfo> result = new ArrayList<PackInfo>();
        IXMLElement root = this.requireChildNamed(data, "packs");
        List packElements = root.getChildrenNamed("pack");
        if (packElements.isEmpty()) {
            this.parseError(root, "<packs> requires a <pack>");
        }
        for (IXMLElement packElement : packElements) {
            String name = this.requireAttribute(packElement, "name");
            String id = packElement.getAttribute("id");
            boolean loose = "true".equalsIgnoreCase(packElement.getAttribute("loose", "false"));
            String description = this.requireChildNamed(packElement, "description").getContent();
            boolean required = this.requireYesNoAttribute(packElement, "required");
            String group = packElement.getAttribute("group");
            String installGroups = packElement.getAttribute("installGroups");
            String excludeGroup = packElement.getAttribute("excludeGroup");
            boolean uninstall = "yes".equalsIgnoreCase(packElement.getAttribute("uninstall", "yes"));
            String parent = packElement.getAttribute("parent");
            if (required && excludeGroup != null) {
                this.parseError(packElement, "Pack, which has excludeGroup can not be required.", new Exception("Pack, which has excludeGroup can not be required."));
            }
            PackInfo pack = new PackInfo(name, id, description, required, loose, excludeGroup, uninstall);
            pack.setOsConstraints(OsConstraintHelper.getOsList((IXMLElement)packElement));
            pack.setParent(parent);
            if (excludeGroup == null) {
                pack.setPreselected(this.validateYesNoAttribute(packElement, "preselected", YES));
            } else {
                pack.setPreselected(this.validateYesNoAttribute(packElement, "preselected", NO));
            }
            if (group != null) {
                pack.setGroup(group);
            }
            if (installGroups != null) {
                StringTokenizer tokenizer = new StringTokenizer(installGroups, ",");
                while (tokenizer.hasMoreTokens()) {
                    String igroup = tokenizer.nextToken();
                    pack.addInstallGroup(igroup);
                }
            }
            for (IXMLElement parsableElement : packElement.getChildrenNamed("parsable")) {
                String target = parsableElement.getAttribute("targetfile", null);
                SubstitutionType type = SubstitutionType.lookup((String)parsableElement.getAttribute("type", "plain"));
                String encoding = parsableElement.getAttribute("encoding", null);
                List osList = OsConstraintHelper.getOsList((IXMLElement)parsableElement);
                if (target == null) continue;
                pack.addParsable(new ParsableFile(target, type, encoding, osList));
            }
            for (IXMLElement executableElement : packElement.getChildrenNamed("executable")) {
                ExecutableFile executable = new ExecutableFile();
                executable.path = this.requireAttribute(executableElement, "targetfile");
                String val = executableElement.getAttribute("stage", "never");
                if ("postinstall".equalsIgnoreCase(val)) {
                    executable.executionStage = 0;
                } else if ("uninstall".equalsIgnoreCase(val)) {
                    executable.executionStage = 2;
                }
                val = executableElement.getAttribute("type", "bin");
                if ("jar".equalsIgnoreCase(val)) {
                    executable.type = 1;
                    executable.mainClass = executableElement.getAttribute("class");
                }
                if ("abort".equalsIgnoreCase(val = executableElement.getAttribute("failure", "ask"))) {
                    executable.onFailure = 0;
                } else if ("warn".equalsIgnoreCase(val)) {
                    executable.onFailure = 1;
                }
                val = executableElement.getAttribute("keep");
                executable.keepFile = "true".equalsIgnoreCase(val);
                IXMLElement args = executableElement.getFirstChildNamed("args");
                if (null != args) {
                    for (IXMLElement arg : args.getChildrenNamed("arg")) {
                        executable.argList.add(this.requireAttribute(arg, "value"));
                    }
                }
                executable.osList = OsConstraintHelper.getOsList((IXMLElement)executableElement);
                pack.addExecutable(executable);
            }
            for (IXMLElement fileElement : packElement.getChildrenNamed("updatecheck")) {
                String casesensitive = fileElement.getAttribute("casesensitive");
                ArrayList<String> includesList = new ArrayList<String>();
                ArrayList<String> excludesList = new ArrayList<String>();
                for (IXMLElement inc_el : fileElement.getChildrenNamed("include")) {
                    includesList.add(this.requireAttribute(inc_el, "name"));
                }
                for (IXMLElement excl_el : fileElement.getChildrenNamed("exclude")) {
                    excludesList.add(this.requireAttribute(excl_el, "name"));
                }
                pack.addUpdateCheck(new UpdateCheck(includesList, excludesList, casesensitive));
            }
            for (IXMLElement dep : packElement.getChildrenNamed("depends")) {
                String depName = this.requireAttribute(dep, "packname");
                pack.addDependency(depName);
            }
            result.add(pack);
        }
        return result;
    }

    protected void parseError(String message) throws CompilerException {
        throw new CompilerException("install.xml:" + message);
    }

    protected void parseError(IXMLElement parent, String message) throws CompilerException {
        throw new CompilerException("install.xml:" + parent.getLineNr() + ": " + message);
    }

    protected void parseError(IXMLElement parent, String message, Throwable cause) throws CompilerException {
        throw new CompilerException("install.xml:" + parent.getLineNr() + ": " + message, cause);
    }

    protected void parseWarn(IXMLElement parent, String message) {
        System.out.println("install.xml:" + parent.getLineNr() + ": " + message);
    }

    protected IXMLElement requireChildNamed(IXMLElement parent, String name) throws CompilerException {
        IXMLElement child = parent.getFirstChildNamed(name);
        if (child == null) {
            this.parseError(parent, "<" + parent.getName() + "> requires child <" + name + ">");
        }
        return child;
    }

    protected URL requireURLContent(IXMLElement element) throws CompilerException {
        URL url = null;
        try {
            url = new URL(this.requireContent(element));
        }
        catch (MalformedURLException x) {
            this.parseError(element, "<" + element.getName() + "> requires valid URL", x);
        }
        return url;
    }

    protected String requireContent(IXMLElement element) throws CompilerException {
        String content = element.getContent();
        if (content == null || content.length() == 0) {
            this.parseError(element, "<" + element.getName() + "> requires content");
        }
        return content;
    }

    protected String requireAttribute(IXMLElement element, String attribute) throws CompilerException {
        String value = element.getAttribute(attribute);
        if (value == null) {
            this.parseError(element, "<" + element.getName() + "> requires attribute '" + attribute + "'");
        }
        return value;
    }

    protected int requireIntAttribute(IXMLElement element, String attribute) throws CompilerException {
        String value = element.getAttribute(attribute);
        if (value == null || value.length() == 0) {
            this.parseError(element, "<" + element.getName() + "> requires attribute '" + attribute + "'");
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException x) {
            this.parseError(element, "'" + attribute + "' must be an integer");
            return 0;
        }
    }

    protected boolean requireYesNoAttribute(IXMLElement element, String attribute) throws CompilerException {
        String value = this.requireAttribute(element, attribute);
        if ("yes".equalsIgnoreCase(value)) {
            return true;
        }
        if ("no".equalsIgnoreCase(value)) {
            return false;
        }
        this.parseError(element, "<" + element.getName() + "> invalid attribute '" + attribute + "': Expected (yes|no)");
        return false;
    }

    protected boolean validateYesNoAttribute(IXMLElement element, String attribute, boolean defaultValue) {
        if (element == null) {
            return defaultValue;
        }
        String value = element.getAttribute(attribute, defaultValue ? "yes" : "no");
        if ("yes".equalsIgnoreCase(value)) {
            return true;
        }
        if ("no".equalsIgnoreCase(value)) {
            return false;
        }
        this.parseWarn(element, "<" + element.getName() + "> invalid attribute '" + attribute + "': Expected (yes|no) if present");
        return defaultValue;
    }
}

