/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.os;

import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.os.FileQueueOperation;
import com.izforge.izpack.util.os.WinSetupFileQueue;
import java.io.File;
import java.io.IOException;

public class FileQueueCopy
implements FileQueueOperation {
    protected File fromFile = null;
    protected File toFile = null;
    protected int copyStyle = 8;

    public FileQueueCopy(File fromFile, File toFile) {
        this(fromFile, toFile, false, false);
    }

    public FileQueueCopy(File fromFile, File toFile, boolean deleteSource, boolean forceInUse) {
        this.fromFile = fromFile;
        this.toFile = toFile;
        this.setDeleteSource(deleteSource);
        this.setForceInUse(forceInUse);
    }

    public void setDeleteSource(boolean flag) {
        this.copyStyle = flag ? (this.copyStyle |= 1) : (this.copyStyle &= 0xFFFFFFFE);
    }

    public void setForceInUse(boolean flag) {
        this.copyStyle = flag ? (this.copyStyle |= 0x200) : (this.copyStyle &= 0xFFFFFDFF);
    }

    public void setInUseNeedsReboot(boolean flag) {
        this.copyStyle = flag ? (this.copyStyle |= 0x100) : (this.copyStyle &= 0xFFFFFEFF);
    }

    public void setLanguageAware(boolean flag) {
        this.copyStyle = flag ? (this.copyStyle |= 0x20) : (this.copyStyle &= 0xFFFFFFDF);
    }

    public void setNewerOrSame(boolean flag) {
        this.copyStyle = flag ? (this.copyStyle |= 4) : (this.copyStyle &= 0xFFFFFFFB);
    }

    public void setNewerOnly(boolean flag) {
        if (flag) {
            this.copyStyle &= 0x10000;
        }
    }

    public void setReplaceOnly(boolean flag) {
        this.copyStyle = flag ? (this.copyStyle |= 2) : (this.copyStyle &= 0xFFFFFFFD);
    }

    public void setOverwrite(boolean flag) {
        this.copyStyle = flag ? (this.copyStyle &= 0xFFFFFFF7) : (this.copyStyle |= 8);
    }

    @Override
    public void addTo(WinSetupFileQueue filequeue) throws IOException {
        if (this.fromFile.equals(this.toFile)) {
            Debug.log((Object)("Skipping self-copy of " + this.fromFile));
        } else {
            try {
                Debug.log((Object)("Enqueueing copying " + this.fromFile + " to " + this.toFile + " (0x" + Integer.toHexString(this.copyStyle) + ")"));
                filequeue.addCopy(this.fromFile, this.toFile, this.copyStyle);
            }
            catch (IOException ioe) {
                String msg = "Failed to enqueue copying " + this.fromFile + " to " + this.toFile + " due to " + ioe.getMessage();
                throw new IOException(msg);
            }
        }
    }
}

