/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.os;

import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.StringTool;
import com.izforge.izpack.util.os.ShellLink;
import com.izforge.izpack.util.os.Shortcut;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class Win_Shortcut
extends Shortcut {
    private ShellLink shortcut;
    private static String myClass = Win_Shortcut.class.getName() + ": ";
    private static final String CLASS = "Class: ";
    private static final boolean SUPPORTED = true;

    @Override
    public void initialize(int type, String name) throws Exception {
        Debug.log((Object)(CLASS + myClass + ".initialize() '" + Integer.toString(type) + "', '" + name + "'"));
        switch (type) {
            case 1: {
                this.shortcut = new ShellLink(2, name);
                break;
            }
            case 2: {
                this.shortcut = new ShellLink(3, name);
                break;
            }
            case 3: {
                this.shortcut = new ShellLink(1, name);
                break;
            }
            case 4: {
                this.shortcut = new ShellLink(4, name);
                break;
            }
            default: {
                this.shortcut = new ShellLink(2, name);
            }
        }
    }

    @Override
    public String getBasePath() throws Exception {
        String result = this.shortcut.getLinkPath(this.shortcut.getUserType());
        Debug.log((Object)(CLASS + myClass + ".getBasePath() '" + result + "'"));
        return result;
    }

    @Override
    public List<String> getProgramGroups(int userType) {
        int logentry = 0;
        Debug.log((Object)(CLASS + myClass + ".getProgramGroups()-" + logentry++ + " '" + Integer.toString(userType) + "'"));
        int type = 0;
        type = userType == 2 ? 1 : 0;
        String linkPath = this.shortcut.getLinkPath(type);
        Debug.log((Object)(CLASS + myClass + ".getProgramGroups()-" + logentry++ + " '" + linkPath + "'"));
        if (linkPath == null) {
            return new ArrayList<String>();
        }
        File path = new File(linkPath);
        File[] file = path.listFiles();
        ArrayList<String> groups = new ArrayList<String>();
        if (file != null) {
            for (File aFile : file) {
                String aFilename = aFile.getName();
                if (aFile.isDirectory()) {
                    Debug.log((Object)(CLASS + myClass + ".getProgramGroups()-" + logentry++ + " '" + aFilename + "'"));
                    groups.add(aFilename);
                    continue;
                }
                Debug.log((Object)(CLASS + myClass + ".getProgramGroups()-" + logentry++ + " Skip (NoDirectory): '" + aFilename + "'"));
            }
        }
        return groups;
    }

    @Override
    public String getFileName() {
        String aFilename = this.shortcut.getFileName();
        Debug.log((Object)(CLASS + myClass + ".getFileName() '" + aFilename + "'"));
        return aFilename;
    }

    @Override
    public String getDirectoryCreated() {
        String directoryCreated = this.shortcut.getDirectoryCreated();
        Debug.log((Object)(CLASS + myClass + ".getDirectoryCreated() '" + directoryCreated + "'"));
        return directoryCreated;
    }

    @Override
    public boolean multipleUsers() {
        boolean result = false;
        String allUsers = this.shortcut.getallUsersLinkPath();
        Debug.log((Object)(CLASS + myClass + ".multipleUsers()-1 '" + allUsers + "'"));
        String currentUsers = this.shortcut.getcurrentUserLinkPath();
        Debug.log((Object)(CLASS + myClass + ".multipleUsers()-2 '" + currentUsers + "'"));
        result = allUsers == null || currentUsers == null ? false : allUsers.length() > 0 && currentUsers.length() > 0;
        Debug.log((Object)(CLASS + myClass + ".multipleUsers()-3 '" + result + "'"));
        return result;
    }

    @Override
    public boolean supported() {
        Debug.log((Object)(CLASS + myClass + ".supported() '" + true + "'"));
        return true;
    }

    @Override
    public void setArguments(String arguments) {
        Debug.log((Object)(CLASS + myClass + ".setArguments() '" + arguments + "'"));
        this.shortcut.setArguments(arguments);
    }

    @Override
    public void setDescription(String description) {
        Debug.log((Object)(CLASS + myClass + ".setDescription() '" + description + "'"));
        this.shortcut.setDescription(description);
    }

    @Override
    public void setIconLocation(String path, int index) {
        Debug.log((Object)(CLASS + myClass + ".setIconLocation() '" + path + "', '" + Integer.toString(index) + "'"));
        this.shortcut.setIconLocation(path, index);
    }

    @Override
    public String getIconLocation() {
        String result = this.shortcut.getIconLocation();
        Debug.log((Object)(CLASS + myClass + ".getIconLocation() '" + result + "'"));
        return result;
    }

    @Override
    public void setProgramGroup(String groupName) {
        Debug.log((Object)(CLASS + myClass + ".setProgramGroup() '" + groupName + "'"));
        this.shortcut.setProgramGroup(groupName);
    }

    @Override
    public void setShowCommand(int show) throws IllegalArgumentException {
        Debug.log((Object)(CLASS + myClass + ".setShowCommand() '" + Integer.toString(show) + "'"));
        switch (show) {
            case 0: {
                this.shortcut.setShowCommand(7);
                break;
            }
            case 1: {
                this.shortcut.setShowCommand(1);
                break;
            }
            case 2: {
                this.shortcut.setShowCommand(7);
                break;
            }
            case 3: {
                this.shortcut.setShowCommand(3);
                break;
            }
            default: {
                throw new IllegalArgumentException(show + "is not recognized as a show command");
            }
        }
    }

    @Override
    public int getShowCommand() {
        int showCommand = this.shortcut.getShowCommand();
        Debug.log((Object)(CLASS + myClass + ".getShowCommand() '" + Integer.toString(showCommand) + "'"));
        switch (showCommand) {
            case 1: {
                showCommand = 1;
                break;
            }
            case 2: 
            case 7: {
                showCommand = 2;
                break;
            }
            case 3: {
                showCommand = 3;
                break;
            }
        }
        return showCommand;
    }

    @Override
    public void setTargetPath(String path) {
        Debug.log((Object)(CLASS + myClass + ".setTargetPath() '" + path + "'"));
        this.shortcut.setTargetPath(path);
    }

    @Override
    public void setWorkingDirectory(String dir) {
        Debug.log((Object)(CLASS + myClass + ".setWorkingDirectory() '" + dir + "'"));
        this.shortcut.setWorkingDirectory(dir);
    }

    @Override
    public String getWorkingDirectory() {
        String result = this.shortcut.getWorkingDirectory();
        Debug.log((Object)(CLASS + myClass + ".getWorkingDirectory() '" + result + "'"));
        return result;
    }

    @Override
    public void setLinkName(String name) {
        Debug.log((Object)(CLASS + myClass + ".setLinkName() '" + name + "'"));
        this.shortcut.setLinkName(name);
    }

    @Override
    public int getLinkType() {
        int typ = this.shortcut.getLinkType();
        Debug.log((Object)(CLASS + myClass + ".getLinkType() '" + typ + "'"));
        switch (typ) {
            case 1: {
                typ = 3;
                break;
            }
            case 2: {
                typ = 1;
                break;
            }
            case 3: {
                typ = 2;
                break;
            }
            case 4: {
                typ = 4;
                break;
            }
        }
        return typ;
    }

    @Override
    public void setLinkType(int type) throws IllegalArgumentException, UnsupportedEncodingException {
        Debug.log((Object)(CLASS + myClass + ".setLinkType() '" + type + "'"));
        switch (type) {
            case 3: {
                this.shortcut.setLinkType(1);
                break;
            }
            case 1: {
                this.shortcut.setLinkType(2);
                break;
            }
            case 2: {
                this.shortcut.setLinkType(3);
                break;
            }
            case 4: {
                this.shortcut.setLinkType(4);
                break;
            }
            default: {
                throw new IllegalArgumentException(type + "is not recognized as a valid link type");
            }
        }
    }

    @Override
    public int getUserType() {
        int utype = this.shortcut.getUserType();
        Debug.log((Object)(CLASS + myClass + ".getUserType() '" + utype + "'"));
        switch (utype) {
            case 1: {
                utype = 2;
                break;
            }
            case 0: {
                utype = 1;
            }
        }
        return utype;
    }

    @Override
    public void setUserType(int type) {
        Debug.log((Object)(CLASS + myClass + ".setUserType() '" + type + "'"));
        if (type == 1) {
            if (this.shortcut.getcurrentUserLinkPath().length() > 0) {
                this.shortcut.setUserType(0);
            }
        } else if (type == 2 && this.shortcut.getallUsersLinkPath().length() > 0) {
            this.shortcut.setUserType(1);
        }
    }

    @Override
    public void save() throws Exception {
        this.shortcut.save();
    }

    @Override
    public int getHotkey() {
        int result = this.shortcut.getHotkey();
        Debug.log((Object)(CLASS + myClass + ".getHotkey() '" + result + "'"));
        return result;
    }

    @Override
    public void setHotkey(int hotkey) {
        Debug.log((Object)(CLASS + myClass + ".setHotkey() '" + hotkey + "'"));
        this.shortcut.setHotkey(hotkey);
    }

    @Override
    public String getProgramsFolder(int current_user) {
        int USER = 0;
        if (current_user == 1) {
            USER = 0;
        } else if (current_user == 2) {
            USER = 1;
        }
        String result = null;
        try {
            result = new String(this.shortcut.getLinkPath(USER).getBytes(StringTool.getPlatformEncoding()), StringTool.getPlatformEncoding());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        Debug.log((Object)(CLASS + myClass + ".getProgramsFolder() '" + current_user + "', '" + result + "'"));
        return result;
    }
}

