/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.console;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.installer.console.AbstractPanelConsole;
import com.izforge.izpack.util.Console;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public abstract class AbstractTextPanelConsole
extends AbstractPanelConsole {
    private static final Logger logger = Logger.getLogger(AbstractTextPanelConsole.class.getName());

    @Override
    public boolean runConsoleFromProperties(InstallData installData, Properties properties) {
        return true;
    }

    @Override
    public boolean runConsole(InstallData installData, Console console) {
        boolean result;
        String text = this.getText();
        if (text != null) {
            result = this.paginateText(text, console);
        } else {
            logger.warning("No text to display");
            result = false;
        }
        return result && this.promptEndPanel(installData, console);
    }

    protected abstract String getText();

    protected boolean paginateText(String text, Console console) {
        boolean result = true;
        int lines = 22;
        int line = 0;
        StringTokenizer tokens = new StringTokenizer(text, "\n");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            console.println(token);
            if (++line < lines || !tokens.hasMoreTokens()) continue;
            if (!this.promptContinue(console)) {
                result = false;
                break;
            }
            line = 0;
        }
        return result;
    }

    protected boolean promptContinue(Console console) {
        String value = console.prompt("\nPress Enter to continue, X to exit", "x");
        console.println();
        return !value.equalsIgnoreCase("x");
    }
}

