/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.console;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.installer.base.InstallerBase;
import com.izforge.izpack.installer.console.ConsoleAction;
import com.izforge.izpack.installer.console.ConsoleInstallAction;
import com.izforge.izpack.installer.console.ConsolePanelView;
import com.izforge.izpack.installer.console.ConsolePanels;
import com.izforge.izpack.installer.console.GeneratePropertiesAction;
import com.izforge.izpack.installer.console.PropertyInstallAction;
import com.izforge.izpack.installer.data.UninstallDataWriter;
import com.izforge.izpack.installer.requirement.RequirementsChecker;
import com.izforge.izpack.util.Console;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.file.FileUtils;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConsoleInstaller
extends InstallerBase {
    private final ConsolePanels panels;
    private InstallData installData;
    private final RequirementsChecker requirements;
    private UninstallDataWriter uninstallDataWriter;
    private Console console;
    private final Housekeeper housekeeper;
    private static final Logger logger = Logger.getLogger(ConsoleInstaller.class.getName());

    public ConsoleInstaller(ConsolePanels panels, AutomatedInstallData installData, RequirementsChecker requirements, UninstallDataWriter uninstallDataWriter, Console console, Housekeeper housekeeper) {
        this.panels = panels;
        this.installData = installData;
        this.requirements = requirements;
        this.uninstallDataWriter = uninstallDataWriter;
        this.console = console;
        this.housekeeper = housekeeper;
    }

    public boolean canInstall() {
        boolean success = true;
        for (ConsolePanelView panel : this.panels.getPanelViews()) {
            if (panel.getViewClass() != null) continue;
            success = false;
            logger.warning("No console implementation of panel: " + panel.getPanel().getClassName());
        }
        return success;
    }

    public void setMediaPath(String path) {
        this.installData.setMediaPath(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(int type, String path) {
        boolean success = false;
        ConsoleAction action = null;
        if (!this.canInstall()) {
            this.console.println("Console installation is not supported by this installer");
            this.shutdown(false, false);
        } else {
            try {
                if (this.requirements.check()) {
                    action = this.createConsoleAction(type, path, this.console);
                    this.panels.setAction(action);
                    while (this.panels.hasNext() && (success = this.panels.next())) {
                    }
                    if (success && (success = this.panels.isValid())) {
                        success = action.complete();
                    }
                }
            }
            catch (Throwable t) {
                success = false;
                logger.log(Level.SEVERE, t.getMessage(), t);
            }
            finally {
                if (action != null && action.isInstall()) {
                    this.shutdown(success, this.console);
                } else {
                    this.shutdown(success, false);
                }
            }
        }
    }

    protected void shutdown(boolean exitSuccess, Console console) {
        boolean reboot = false;
        if (this.installData.isRebootNecessary()) {
            console.println("[ There are file operations pending after reboot ]");
            switch (this.installData.getInfo().getRebootAction()) {
                case 3: {
                    reboot = true;
                }
            }
            if (reboot) {
                console.println("[ Rebooting now automatically ]");
            }
        }
        this.shutdown(exitSuccess, reboot);
    }

    protected void shutdown(boolean exitSuccess, boolean reboot) {
        if (exitSuccess && !this.installData.isInstallSuccess()) {
            logger.severe("Expected successful exit status, but installation data is reporting failure");
            exitSuccess = false;
        }
        this.installData.setInstallSuccess(exitSuccess);
        if (exitSuccess) {
            this.console.println("[ Console installation done ]");
        } else {
            this.console.println("[ Console installation FAILED! ]");
        }
        this.terminate(exitSuccess, reboot);
    }

    protected void terminate(boolean exitSuccess, boolean reboot) {
        this.housekeeper.shutDown(exitSuccess ? 0 : 1, reboot);
    }

    protected Console getConsole() {
        return this.console;
    }

    private ConsoleAction createConsoleAction(int type, String path, Console console) throws IOException {
        ConsoleAction action;
        switch (type) {
            case 1: {
                action = this.createGeneratePropertiesAction(path);
                break;
            }
            case 2: {
                action = this.createInstallFromPropertiesFileAction(path);
                break;
            }
            case 3: {
                action = new PropertyInstallAction(this.installData, this.uninstallDataWriter, System.getProperties());
                break;
            }
            case 4: {
                action = this.createInstallFromSystemPropertiesMergeAction(path, console);
                break;
            }
            default: {
                action = this.createInstallAction();
            }
        }
        return action;
    }

    private ConsoleAction createInstallAction() {
        return new ConsoleInstallAction(this.console, this.installData, this.uninstallDataWriter);
    }

    private ConsoleAction createGeneratePropertiesAction(String path) throws IOException {
        return new GeneratePropertiesAction(this.installData, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConsoleAction createInstallFromPropertiesFileAction(String path) throws IOException {
        FileInputStream in = new FileInputStream(path);
        try {
            Properties properties = new Properties();
            properties.load(in);
            PropertyInstallAction propertyInstallAction = new PropertyInstallAction(this.installData, this.uninstallDataWriter, properties);
            return propertyInstallAction;
        }
        finally {
            FileUtils.close((Closeable)in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConsoleAction createInstallFromSystemPropertiesMergeAction(String path, Console console) throws IOException {
        FileInputStream in = new FileInputStream(path);
        try {
            Properties properties = new Properties();
            properties.load(in);
            Properties systemProperties = System.getProperties();
            Enumeration<?> e = systemProperties.propertyNames();
            while (e.hasMoreElements()) {
                String newValue;
                String key = (String)e.nextElement();
                String oldValue = (String)properties.setProperty(key, newValue = systemProperties.getProperty(key));
                if (oldValue == null) continue;
                console.println("Warning: Property " + key + " overwritten: '" + oldValue + "' --> '" + newValue + "'");
            }
            PropertyInstallAction propertyInstallAction = new PropertyInstallAction(this.installData, this.uninstallDataWriter, properties);
            return propertyInstallAction;
        }
        finally {
            FileUtils.close((Closeable)in);
        }
    }
}

