/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.console;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.api.factory.ObjectFactory;
import com.izforge.izpack.api.handler.AbstractUIHandler;
import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.core.handler.ConsolePrompt;
import com.izforge.izpack.core.handler.PromptUIHandler;
import com.izforge.izpack.installer.console.PanelConsole;
import com.izforge.izpack.installer.panel.PanelView;
import com.izforge.izpack.util.Console;

public class ConsolePanelView
extends PanelView<PanelConsole> {
    private final Console console;
    private final ConsolePrompt prompt;

    public ConsolePanelView(Panel panel, ObjectFactory factory, InstallData installData, Console console) {
        super(panel, PanelConsole.class, factory, installData);
        this.console = console;
        this.prompt = new ConsolePrompt(console);
    }

    public Class<PanelConsole> getViewClass() {
        Panel panel = this.getPanel();
        Class<PanelConsole> result = this.getClass(panel.getClassName() + "Console");
        if (result == null) {
            result = this.getClass(panel.getClassName() + "ConsoleHelper");
        }
        return result;
    }

    @Override
    protected PanelConsole createView(Panel panel, Class<PanelConsole> viewClass) {
        Class<PanelConsole> impl = this.getViewClass();
        if (impl == null) {
            throw new IzPackException("Console implementation not found for panel: " + panel.getClassName());
        }
        return (PanelConsole)this.getFactory().create(impl, new Object[0]);
    }

    @Override
    protected AbstractUIHandler getHandler() {
        return new PromptUIHandler((Prompt)this.prompt){

            public void emitNotification(String message) {
                ConsolePanelView.this.console.println(message);
            }
        };
    }
}

