/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.console;

import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.api.factory.ObjectFactory;
import com.izforge.izpack.installer.console.PanelConsole;
import java.util.logging.Logger;

class PanelConsoleFactory {
    private final ObjectFactory factory;
    private static final Logger logger = Logger.getLogger(PanelConsoleFactory.class.getName());

    public PanelConsoleFactory(ObjectFactory factory) {
        this.factory = factory;
    }

    public PanelConsole create(Panel panel) throws InstallerException {
        Class<PanelConsole> impl = this.getClass(panel);
        return (PanelConsole)this.factory.create(impl, new Object[0]);
    }

    public Class<PanelConsole> getClass(Panel panel) {
        Class<PanelConsole> result = this.getClass(panel.getClassName() + "Console");
        if (result == null) {
            result = this.getClass(panel.getClassName() + "ConsoleHelper");
        }
        return result;
    }

    private Class<PanelConsole> getClass(String name) {
        Class<PanelConsole> result = null;
        try {
            Class<PanelConsole> type = Class.forName(name);
            if (!PanelConsole.class.isAssignableFrom(type)) {
                logger.warning(name + " does not implement " + PanelConsole.class.getName() + ", ignoring");
            } else {
                result = type;
            }
        }
        catch (ClassNotFoundException e) {
            logger.fine("No PanelConsole found for class " + name + ": " + e.toString());
        }
        return result;
    }
}

