/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.container.provider;

import com.izforge.izpack.api.data.GUIPrefs;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.resource.Locales;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.core.data.DefaultVariables;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.container.provider.AbstractInstallDataProvider;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.util.Housekeeper;
import com.izforge.izpack.util.OsVersion;
import com.izforge.izpack.util.PlatformModelMatcher;
import java.awt.Color;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;

public class GUIInstallDataProvider
extends AbstractInstallDataProvider {
    private static final Logger logger = Logger.getLogger(GUIInstallDataProvider.class.getName());
    private static Map<String, String> substanceVariants = new HashMap<String, String>();
    private static Map<String, String> looksVariants = new HashMap<String, String>();

    public GUIInstallData provide(Resources resources, Locales locales, DefaultVariables variables, Housekeeper housekeeper, PlatformModelMatcher matcher) throws Exception {
        GUIInstallData guiInstallData = new GUIInstallData((Variables)variables, matcher.getCurrentPlatform());
        this.loadInstallData(guiInstallData, resources, matcher, housekeeper);
        this.loadGUIInstallData(guiInstallData, resources);
        this.loadInstallerRequirements(guiInstallData, resources);
        this.loadDynamicVariables((Variables)variables, (InstallData)guiInstallData, resources);
        this.loadDynamicConditions(guiInstallData, resources);
        this.loadDefaultLocale(guiInstallData, locales);
        this.addCustomLangpack(guiInstallData, locales);
        this.loadLookAndFeel(guiInstallData);
        if (UIManager.getColor("Button.background") != null) {
            guiInstallData.buttonsHColor = UIManager.getColor("Button.background");
        }
        return guiInstallData;
    }

    protected void loadLookAndFeel(GUIInstallData installData) throws Exception {
        String variant;
        String syskey = "unix";
        if (OsVersion.IS_WINDOWS) {
            syskey = "windows";
        } else if (OsVersion.IS_OSX) {
            syskey = "mac";
        }
        String lookAndFeelName = null;
        if (installData.guiPrefs.lookAndFeelMapping.containsKey(syskey)) {
            lookAndFeelName = (String)installData.guiPrefs.lookAndFeelMapping.get(syskey);
        }
        boolean useButtonIcons = true;
        if (installData.guiPrefs.modifier.containsKey("useButtonIcons") && "no".equalsIgnoreCase((String)installData.guiPrefs.modifier.get("useButtonIcons"))) {
            useButtonIcons = false;
        }
        ButtonFactory.useButtonIcons((boolean)useButtonIcons);
        boolean useLabelIcons = true;
        if (installData.guiPrefs.modifier.containsKey("useLabelIcons") && "no".equalsIgnoreCase((String)installData.guiPrefs.modifier.get("useLabelIcons"))) {
            useLabelIcons = false;
        }
        LabelFactory.setUseLabelIcons((boolean)useLabelIcons);
        if (installData.guiPrefs.modifier.containsKey("labelFontSize")) {
            String valStr = (String)installData.guiPrefs.modifier.get("labelFontSize");
            try {
                LabelFactory.setLabelFontSize((float)Float.parseFloat(valStr));
            }
            catch (NumberFormatException ex) {
                logger.warning("Error parsing guiprefs 'labelFontSize' value (" + valStr + ')');
            }
        }
        if (lookAndFeelName == null) {
            if (!"mac".equals(syskey)) {
                if ("unix".equals(syskey)) {
                    Locale.setDefault(Locale.ENGLISH);
                }
                String syslaf = UIManager.getSystemLookAndFeelClassName();
                UIManager.setLookAndFeel(syslaf);
                if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel) {
                    ButtonFactory.useButtonIcons((boolean)useButtonIcons);
                }
            }
            return;
        }
        if ("kunststoff".equals(lookAndFeelName)) {
            ButtonFactory.useHighlightButtons();
            ButtonFactory.useButtonIcons((boolean)useButtonIcons);
            installData.buttonsHColor = new Color(255, 255, 255);
            Class<?> lafClass = Class.forName("com.incors.plaf.kunststoff.KunststoffLookAndFeel");
            Class<?> mtheme = Class.forName("javax.swing.plaf.metal.MetalTheme");
            Class[] params = new Class[]{mtheme};
            Class<?> theme = Class.forName("com.izforge.izpack.gui.IzPackKMetalTheme");
            Method setCurrentThemeMethod = lafClass.getMethod("setCurrentTheme", params);
            LookAndFeel kunststoff = (LookAndFeel)lafClass.newInstance();
            MetalTheme ktheme = (MetalTheme)theme.newInstance();
            Object[] kparams = new Object[]{ktheme};
            UIManager.setLookAndFeel(kunststoff);
            setCurrentThemeMethod.invoke((Object)kunststoff, kparams);
            return;
        }
        if ("liquid".equals(lookAndFeelName)) {
            String value;
            UIManager.setLookAndFeel("com.birosoft.liquid.LiquidLookAndFeel");
            Map params = (Map)installData.guiPrefs.lookAndFeelParams.get(lookAndFeelName);
            if (params.containsKey("decorate.frames") && "yes".equals(value = (String)params.get("decorate.frames"))) {
                JFrame.setDefaultLookAndFeelDecorated(true);
            }
            if (params.containsKey("decorate.dialogs") && "yes".equals(value = (String)params.get("decorate.dialogs"))) {
                JDialog.setDefaultLookAndFeelDecorated(true);
            }
            return;
        }
        if ("metouia".equals(lookAndFeelName)) {
            UIManager.setLookAndFeel("net.sourceforge.mlf.metouia.MetouiaLookAndFeel");
            return;
        }
        if ("nimbus".equals(lookAndFeelName)) {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
            return;
        }
        if ("looks".equals(lookAndFeelName)) {
            String param;
            variant = looksVariants.get("plasticXP");
            Map params = (Map)installData.guiPrefs.lookAndFeelParams.get(lookAndFeelName);
            if (params.containsKey("variant") && looksVariants.containsKey(param = (String)params.get("variant"))) {
                variant = looksVariants.get(param);
            }
            UIManager.setLookAndFeel(variant);
            return;
        }
        if ("substance".equals(lookAndFeelName)) {
            String param;
            Map params = (Map)installData.guiPrefs.lookAndFeelParams.get(lookAndFeelName);
            variant = params.containsKey("variant") ? (substanceVariants.containsKey(param = (String)params.get("variant")) ? substanceVariants.get(param) : substanceVariants.get("default")) : substanceVariants.get("default");
            logger.info("Using laf " + variant);
            UIManager.setLookAndFeel(variant);
            UIManager.getLookAndFeelDefaults().put("ClassLoader", JPanel.class.getClassLoader());
            this.checkSubstanceLafLoaded();
        }
    }

    private void checkSubstanceLafLoaded() throws ClassNotFoundException {
        UIDefaults defaults = UIManager.getDefaults();
        String uiClassName = (String)defaults.get("PanelUI");
        ClassLoader cl = (ClassLoader)defaults.get("ClassLoader");
        ClassLoader classLoader = cl != null ? cl : JPanel.class.getClassLoader();
        Class<?> aClass = (Class<?>)defaults.get(uiClassName);
        logger.info("PanelUI : " + uiClassName);
        logger.info("ClassLoader : " + classLoader);
        logger.info("Cached class : " + aClass);
        if (aClass != null) {
            return;
        }
        if (classLoader == null) {
            logger.info("Using system loader to load " + uiClassName);
            aClass = Class.forName(uiClassName, true, Thread.currentThread().getContextClassLoader());
            logger.info("Done loading");
        } else {
            logger.info("Using custom loader to load " + uiClassName);
            aClass = classLoader.loadClass(uiClassName);
            logger.info("Done loading");
        }
        if (aClass != null) {
            logger.info("Loaded class : " + aClass.getName());
        } else {
            logger.info("Couldn't load the class");
        }
    }

    private void loadGUIInstallData(GUIInstallData installData, Resources resources) throws Exception {
        installData.guiPrefs = (GUIPrefs)resources.getObject("GUIPrefs");
    }

    static {
        substanceVariants.put("default", "org.pushingpixels.substance.api.skin.SubstanceBusinessLookAndFeel");
        substanceVariants.put("business", "org.pushingpixels.substance.api.skin.SubstanceBusinessLookAndFeel");
        substanceVariants.put("business-blue", "org.pushingpixels.substance.api.skin.SubstanceBusinessBlueSteelLookAndFeel");
        substanceVariants.put("business-black", "org.pushingpixels.substance.api.skin.SubstanceBusinessBlackSteelLookAndFeel");
        substanceVariants.put("creme", "org.pushingpixels.substance.api.skin.SubstanceCremeLookAndFeel");
        substanceVariants.put("creme-coffee", "org.pushingpixels.substance.api.skin.SubstanceCremeCoffeeLookAndFeel");
        substanceVariants.put("sahara", "org.pushingpixels.substance.api.skin.SubstanceSaharaLookAndFeel");
        substanceVariants.put("graphite", "org.pushingpixels.substance.api.skin.SubstanceGraphiteLookAndFeel");
        substanceVariants.put("moderate", "org.pushingpixels.substance.api.skin.SubstanceModerateLookAndFeel");
        substanceVariants.put("nebula", "org.pushingpixels.substance.api.skin.SubstanceNebulaLookAndFeel");
        substanceVariants.put("nebula-brick-wall", "org.pushingpixels.substance.api.skin.SubstanceNebulaBrickWallLookAndFeel");
        substanceVariants.put("autumn", "org.pushingpixels.substance.api.skin.SubstanceAutumnLookAndFeel");
        substanceVariants.put("mist-silver", "org.pushingpixels.substance.api.skin.SubstanceMistSilverLookAndFeel");
        substanceVariants.put("mist-aqua", "org.pushingpixels.substance.api.skin.SubstanceMistAquaLookAndFeel");
        substanceVariants.put("dust", "org.pushingpixels.substance.api.skin.SubstanceDustLookAndFeel");
        substanceVariants.put("dust-coffee", "org.pushingpixels.substance.api.skin.SubstanceDustCoffeeLookAndFeel");
        substanceVariants.put("gemini", "org.pushingpixels.substance.api.skin.SubstanceGeminiLookAndFeel");
        substanceVariants.put("mariner", "org.pushingpixels.substance.api.skin.SubstanceMarinerLookAndFeel");
        substanceVariants.put("officesilver", "org.pushingpixels.substance.api.skin.SubstanceOfficeSilver2007LookAndFeel");
        substanceVariants.put("officeblue", "org.pushingpixels.substance.api.skin.SubstanceOfficeBlue2007LookAndFeel");
        substanceVariants.put("officeblack", "org.pushingpixels.substance.api.skin.SubstanceOfficeBlack2007LookAndFeel");
        looksVariants.put("windows", "com.jgoodies.looks.windows.WindowsLookAndFeel");
        looksVariants.put("plastic", "com.jgoodies.looks.plastic.PlasticLookAndFeel");
        looksVariants.put("plastic3D", "com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
        looksVariants.put("plasticXP", "com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
    }
}

