/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.panel;

import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.installer.panel.PanelView;
import com.izforge.izpack.installer.panel.PanelViews;
import com.izforge.izpack.installer.panel.Panels;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractPanels<T extends PanelView<V>, V>
implements Panels,
PanelViews<T, V> {
    private final List<Panel> panels = new ArrayList<Panel>();
    private final List<T> panelViews;
    private final Variables variables;
    private int index = -1;
    private boolean nextEnabled;
    private boolean previousEnabled;
    private static final Logger logger = Logger.getLogger(AbstractPanels.class.getName());

    public AbstractPanels(List<T> panels, Variables variables) {
        this.panelViews = panels;
        this.variables = variables;
        this.nextEnabled = !panels.isEmpty();
        int index = 0;
        for (PanelView panelView : panels) {
            panelView.setIndex(index++);
            this.panels.add(panelView.getPanel());
        }
    }

    @Override
    public List<Panel> getPanels() {
        return this.panels;
    }

    @Override
    public Panel getPanel() {
        return this.index >= 0 && this.index < this.panels.size() ? this.panels.get(this.index) : null;
    }

    @Override
    public List<T> getPanelViews() {
        return this.panelViews;
    }

    @Override
    public V getView() {
        T panelView = this.getPanelView();
        return panelView != null ? (V)((PanelView)panelView).getView() : null;
    }

    @Override
    public T getPanelView() {
        return this.getPanelView(this.index);
    }

    @Override
    public boolean isValid() {
        T panel = this.getPanelView();
        return panel != null && this.executeValidationActions(panel, true);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean hasNext() {
        return this.getNext(this.index, false) != -1;
    }

    @Override
    public void setNextEnabled(boolean enable) {
        this.nextEnabled = enable;
    }

    @Override
    public boolean isNextEnabled() {
        return this.nextEnabled && this.hasNext();
    }

    @Override
    public boolean next() {
        return this.next(true);
    }

    @Override
    public boolean next(boolean validate) {
        int newIndex;
        boolean isValid;
        boolean result = false;
        T panel = this.getPanelView();
        boolean bl = isValid = panel == null || this.executeValidationActions(panel, validate);
        if (isValid && this.isNextEnabled() && (newIndex = this.getNext(this.index, false)) != -1) {
            result = this.switchPanel(newIndex);
        }
        return result;
    }

    @Override
    public void setPreviousEnabled(boolean enable) {
        this.previousEnabled = enable;
    }

    @Override
    public boolean isPreviousEnabled() {
        return this.previousEnabled && this.hasPrevious();
    }

    @Override
    public boolean hasPrevious() {
        return this.getPrevious(this.index, false) != -1;
    }

    @Override
    public boolean previous() {
        return this.previous(this.index);
    }

    @Override
    public boolean previous(int index) {
        int newIndex;
        boolean result = false;
        if (this.isPreviousEnabled() && (newIndex = this.getPrevious(index, true)) != -1) {
            result = this.switchPanel(newIndex);
        }
        return result;
    }

    @Override
    public int getNext(int index, boolean visibleOnly) {
        int result = -1;
        List<T> panels = this.getPanelViews();
        for (int i = index + 1; i < panels.size(); ++i) {
            if (!this.canShow((PanelView)panels.get(i), visibleOnly)) continue;
            result = i;
            break;
        }
        return result;
    }

    @Override
    public int getPrevious(int index, boolean visibleOnly) {
        int result = -1;
        for (int i = index - 1; i >= 0; --i) {
            if (!this.canShow(this.getPanelView(i), visibleOnly)) continue;
            result = i;
            break;
        }
        return result;
    }

    @Override
    public int getVisibleIndex(T panel) {
        int result = -1;
        if (((PanelView)panel).isVisible()) {
            for (int i = 0; i <= ((PanelView)panel).getIndex() && i < this.panelViews.size(); ++i) {
                if (!((PanelView)this.panelViews.get(i)).isVisible()) continue;
                ++result;
            }
        }
        return result;
    }

    @Override
    public int getVisible() {
        int result = 0;
        for (PanelView panel : this.panelViews) {
            if (!panel.isVisible()) continue;
            ++result;
        }
        return result;
    }

    protected boolean switchPanel(int newIndex) {
        boolean result;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Selecting panel=" + newIndex + ", old index=" + this.index);
        }
        this.variables.refresh();
        T oldPanel = this.getPanelView(this.index);
        T newPanel = this.getPanelView(newIndex);
        int oldIndex = this.index;
        this.index = newIndex;
        if (this.switchPanel(newPanel, oldPanel)) {
            result = true;
        } else {
            this.index = oldIndex;
            result = false;
        }
        return result;
    }

    protected abstract boolean switchPanel(T var1, T var2);

    protected boolean executeValidationActions(T panel, boolean validate) {
        this.variables.refresh();
        ((PanelView)panel).executePreValidationActions();
        boolean isValid = !validate || ((PanelView)panel).isValid();
        ((PanelView)panel).executePostValidationActions();
        return isValid;
    }

    private T getPanelView(int index) {
        List<T> panels = this.getPanelViews();
        return (T)(index >= 0 && index < panels.size() ? (PanelView)panels.get(index) : null);
    }

    private boolean canShow(T panel, boolean visibleOnly) {
        return (!visibleOnly || ((PanelView)panel).isVisible()) && ((PanelView)panel).canShow();
    }
}

