/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.os;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.exception.ResourceNotFoundException;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.StringTool;
import com.izforge.izpack.util.os.Shortcut;
import com.izforge.izpack.util.os.Unix_ShortcutConstants;
import com.izforge.izpack.util.unix.ShellScript;
import com.izforge.izpack.util.unix.UnixHelper;
import com.izforge.izpack.util.unix.UnixUser;
import com.izforge.izpack.util.unix.UnixUsers;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Unix_Shortcut
extends Shortcut
implements Unix_ShortcutConstants {
    private static final Logger logger = Logger.getLogger(Unix_Shortcut.class.getName());
    private static String version = "$Id$";
    private static String rev = "$Revision$";
    private static String DESKTOP_EXT = ".desktop";
    private static String template = "";
    private static final String N = "\n";
    private static final String H = "#";
    private static final String S = " ";
    private static final String C = "# ";
    private static final String QM = "\"";
    private int ShortcutType;
    private static ShellScript rootScript = null;
    private static ShellScript uninstallScript = null;
    private List<UnixUser> users;
    private String createdDirectory;
    private int itsUserType;
    private String itsGroupName;
    private String itsName;
    private String itsFileName;
    private Properties props;
    public StringBuffer hlp;
    public ShellScript myInstallScript;
    public final String FS = File.separator;
    public final String myHome = System.getProperty("user.home");
    private String su;
    private String xdgDesktopIconCmd;
    private String myXdgDesktopIconScript;
    private String myXdgDesktopIconCmd;
    private final Resources resources;
    private final InstallData installData;
    private String writtenFileName;

    public Unix_Shortcut(Resources resources, InstallData installData) {
        this.resources = resources;
        this.installData = installData;
        this.hlp = new StringBuffer();
        String userLanguage = System.getProperty("user.language", "en");
        this.hlp.append("[Desktop Entry]\n");
        this.hlp.append("Categories=$Categories\n");
        this.hlp.append("Comment=$Comment\n");
        this.hlp.append("Comment[").append(userLanguage).append("]=$Comment\n");
        this.hlp.append("Encoding=$Encoding\n");
        this.hlp.append("Exec=$E_QUOT$Exec$E_QUOT $Arguments\n");
        this.hlp.append("GenericName=$GenericName\n");
        this.hlp.append("GenericName[").append(userLanguage).append("]=$GenericName\n");
        this.hlp.append("Icon=$Icon\n");
        this.hlp.append("MimeType=$MimeType\n");
        this.hlp.append("Name=$Name\n");
        this.hlp.append("Name[").append(userLanguage).append("]=$Name\n");
        this.hlp.append("Path=$P_QUOT$Path$P_QUOT\n");
        this.hlp.append("ServiceTypes=$ServiceTypes\n");
        this.hlp.append("SwallowExec=$SwallowExec\n");
        this.hlp.append("SwallowTitle=$SwallowTitle\n");
        this.hlp.append("Terminal=$Terminal\n");
        this.hlp.append("TerminalOptions=$Options_For_Terminal\n");
        this.hlp.append("Type=$Type\n");
        this.hlp.append("URL=$URL\n");
        this.hlp.append("X-KDE-SubstituteUID=$X_KDE_SubstituteUID\n");
        this.hlp.append("X-KDE-Username=$X_KDE_Username\n");
        this.hlp.append(N);
        this.hlp.append("# created by ").append(this.getClass().getName()).append(S).append(rev).append(N);
        this.hlp.append(C).append(version);
        template = this.hlp.toString();
        this.props = new Properties();
        this.initProps();
        if (rootScript == null) {
            rootScript = new ShellScript();
        }
        if (uninstallScript == null) {
            uninstallScript = new ShellScript();
        }
        if (this.myInstallScript == null) {
            this.myInstallScript = new ShellScript();
        }
    }

    private void initProps() {
        String[] propsArray;
        for (String aPropsArray : propsArray = new String[]{"$Comment", "$$LANG_Comment", "$Encoding", "$Exec", "$Arguments", "$GenericName", "$$LANG_GenericName", "$MimeType", "$Name", "$$LANG_Name", "$Path", "$ServiceTypes", "$SwallowExec", "$SwallowTitle", "$Terminal", "$Options_For_Terminal", "$Type", "$X_KDE_SubstituteUID", "$X_KDE_Username", "$Icon", "$URL", "$E_QUOT", "$P_QUOT", "$Categories", "$TryExec"}) {
            this.props.put(aPropsArray, "");
        }
    }

    @Override
    public void initialize(int aType, String aName) throws Exception {
        this.itsName = aName;
        this.props.put("$Name", aName);
    }

    @Override
    public boolean supported() {
        return true;
    }

    @Override
    public String getDirectoryCreated() {
        return this.createdDirectory;
    }

    @Override
    public String getFileName() {
        return this.itsFileName;
    }

    @Override
    public List<String> getProgramGroups(int userType) {
        ArrayList<String> groups = new ArrayList<String>();
        File kdeShareApplnk = this.getKdeShareApplnkFolder(userType);
        try {
            File[] listing;
            for (File aListing : listing = kdeShareApplnk.listFiles()) {
                if (!aListing.isDirectory()) continue;
                groups.add(aListing.getName());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return groups;
    }

    @Override
    public String getProgramsFolder(int current_user) {
        String result = "";
        result = this.getKdeShareApplnkFolder(current_user).toString();
        return result;
    }

    private File getKdeShareApplnkFolder(int userType) {
        if (userType == 2) {
            return new File(File.separator + "usr" + File.separator + "share" + File.separator + "applications");
        }
        return new File(System.getProperty("user.home") + File.separator + ".local" + File.separator + "share" + File.separator + "applications");
    }

    @Override
    public boolean multipleUsers() {
        return true;
    }

    @Override
    public void save() throws Exception {
        Object target = null;
        String shortCutDef = this.replace();
        boolean rootUser4All = this.getUserType() == 2;
        boolean create4All = this.getCreateForAll();
        if ("".equals(this.itsGroupName) && this.getLinkType() == 3) {
            this.itsFileName = target;
            File shortCutLocation = null;
            String ApplicationShortcutPathName = this.installData.getVariable("ApplicationShortcutPath");
            if (null != ApplicationShortcutPathName && !ApplicationShortcutPathName.equals("")) {
                File ApplicationShortcutPath = new File(ApplicationShortcutPathName);
                if (ApplicationShortcutPath.isAbsolute()) {
                    if (!ApplicationShortcutPath.exists() && ApplicationShortcutPath.mkdirs() && ApplicationShortcutPath.canWrite()) {
                        shortCutLocation = ApplicationShortcutPath;
                    }
                    if (ApplicationShortcutPath.exists() && ApplicationShortcutPath.isDirectory() && ApplicationShortcutPath.canWrite()) {
                        shortCutLocation = ApplicationShortcutPath;
                    }
                } else {
                    File relativePath = new File(this.installData.getInstallPath() + this.FS + ApplicationShortcutPath);
                    relativePath.mkdirs();
                    shortCutLocation = new File(relativePath.toString());
                }
            } else {
                shortCutLocation = new File(this.installData.getInstallPath());
            }
            File writtenDesktopFile = this.writeAppShortcutWithOutSpace(shortCutLocation.toString(), this.itsName, shortCutDef);
            this.uninstaller.addFile(writtenDesktopFile.toString(), true);
            String cmd = this.getXdgDesktopIconCmd();
            if (cmd != null) {
                this.createExtXdgDesktopIconCmd(shortCutLocation);
                this.myInstallScript.appendln(new String[]{this.myXdgDesktopIconCmd, "install", "--novendor", StringTool.escapeSpaces((String)writtenDesktopFile.toString())});
                ShellScript myUninstallScript = new ShellScript();
                myUninstallScript.appendln(new String[]{this.myXdgDesktopIconCmd, "uninstall", "--novendor", StringTool.escapeSpaces((String)writtenDesktopFile.toString())});
                this.uninstaller.addUninstallScript(myUninstallScript.getContentAsString());
            } else {
                File myDesktopFile;
                while ((myDesktopFile = new File(this.myHome + this.FS + "Desktop" + writtenDesktopFile.getName() + "-" + System.currentTimeMillis() + DESKTOP_EXT)).exists()) {
                }
                Unix_Shortcut.copyTo(writtenDesktopFile, myDesktopFile);
                this.uninstaller.addFile(myDesktopFile.toString(), true);
            }
            if (rootUser4All && create4All) {
                if (cmd != null) {
                    this.installDesktopFileToAllUsersDesktop(writtenDesktopFile);
                } else {
                    this.copyDesktopFileToAllUsersDesktop(writtenDesktopFile);
                }
            }
        } else if (rootUser4All && create4All) {
            File theIcon = new File(this.getIconLocation());
            File commonIcon = new File("/usr/share/pixmaps/" + theIcon.getName());
            try {
                Unix_Shortcut.copyTo(theIcon, commonIcon);
                this.uninstaller.addFile(commonIcon.toString(), true);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Could not copy " + theIcon + " to " + commonIcon + "( " + e.getMessage() + " )", e);
            }
            this.itsFileName = target;
            File writtenFile = this.writeAppShortcut("/usr/share/applications/", this.itsName, shortCutDef);
            this.setWrittenFileName(writtenFile.getName());
            this.uninstaller.addFile(writtenFile.toString(), true);
        } else {
            String localApps = this.myHome + "/.local/share/applications/";
            String localPixmaps = this.myHome + "/.local/share/pixmaps/";
            try {
                File file = new File(localApps);
                file.mkdirs();
                file = new File(localPixmaps);
                file.mkdirs();
            }
            catch (Exception ignore) {
                logger.warning("Failed creating " + localApps + " or " + localPixmaps);
            }
            File theIcon = new File(this.getIconLocation());
            File commonIcon = new File(localPixmaps + theIcon.getName());
            try {
                Unix_Shortcut.copyTo(theIcon, commonIcon);
                this.uninstaller.addFile(commonIcon.toString(), true);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Could not copy " + theIcon + " to " + commonIcon + "( " + e.getMessage() + " )", e);
            }
            this.itsFileName = target;
            File writtenFile = this.writeAppShortcut(localApps, this.itsName, shortCutDef);
            this.setWrittenFileName(writtenFile.getName());
            this.uninstaller.addFile(writtenFile.toString(), true);
        }
    }

    public void createExtXdgDesktopIconCmd(File shortCutLocation) throws IOException, ResourceNotFoundException {
        ShellScript myXdgDesktopIconScript = new ShellScript(null);
        String lines = "";
        lines = this.resources.getString("/com/izforge/izpack/util/unix/xdgdesktopiconscript.sh", null);
        myXdgDesktopIconScript.append((Object)lines);
        this.myXdgDesktopIconCmd = new String(shortCutLocation + this.FS + "IzPackLocaleEnabledXdgDesktopIconScript.sh");
        myXdgDesktopIconScript.write(this.myXdgDesktopIconCmd);
        FileExecutor.getExecOutput((String[])new String[]{UnixHelper.getCustomCommand((String)"chmod"), "+x", this.myXdgDesktopIconCmd}, (boolean)true);
    }

    private void installDesktopFileToAllUsersDesktop(File writtenDesktopFile) {
        for (UnixUser user : this.getUsers()) {
            if (user.getHome().equals(this.myHome)) {
                logger.info("Skipping self-copy: " + user.getHome() + " == " + this.myHome);
                continue;
            }
            try {
                rootScript.append(new String[]{this.getSuCommand(), user.getName(), "-c"});
                rootScript.appendln(new String[]{QM + this.myXdgDesktopIconCmd, "install", "--novendor", StringTool.escapeSpaces((String)writtenDesktopFile.toString()) + QM});
                uninstallScript.append(new String[]{this.getSuCommand(), user.getName(), "-c"});
                uninstallScript.appendln(new String[]{QM + this.myXdgDesktopIconCmd, "uninstall", "--novendor", StringTool.escapeSpaces((String)writtenDesktopFile.toString()) + QM});
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
        logger.fine("==============================");
        logger.fine(rootScript.getContentAsString());
    }

    private String getSuCommand() {
        if (this.su == null) {
            this.su = UnixHelper.getSuCommand();
        }
        return this.su;
    }

    private String getXdgDesktopIconCmd() {
        if (this.xdgDesktopIconCmd == null) {
            this.xdgDesktopIconCmd = UnixHelper.getCustomCommand((String)"xdg-desktop-icon");
        }
        return this.xdgDesktopIconCmd;
    }

    private List<UnixUser> getUsers() {
        if (this.users == null) {
            this.users = UnixUsers.getUsersWithValidShellsExistingHomesAndDesktops();
        }
        return this.users;
    }

    private void copyDesktopFileToAllUsersDesktop(File writtenDesktopFile) throws IOException {
        String chmod = UnixHelper.getCustomCommand((String)"chmod");
        String chown = UnixHelper.getCustomCommand((String)"chown");
        String rm = UnixHelper.getRmCommand();
        String copy = UnixHelper.getCpCommand();
        File dest = null;
        File tempFile = File.createTempFile(this.getClass().getName(), Long.toString(System.currentTimeMillis()) + ".tmp");
        Unix_Shortcut.copyTo(writtenDesktopFile, tempFile);
        FileExecutor.getExecOutput((String[])new String[]{chmod, "uga+rwx", tempFile.toString()});
        for (UnixUser user : this.getUsers()) {
            if (user.getHome().equals(this.myHome)) {
                logger.info("Skipping self-copy: " + user.getHome() + " == " + this.myHome);
                continue;
            }
            try {
                dest = new File(user.getHome() + this.FS + "Desktop" + this.FS + writtenDesktopFile.getName());
                rootScript.append((Object)this.getSuCommand());
                rootScript.append((Object)S);
                rootScript.append((Object)user.getName());
                rootScript.append((Object)S);
                rootScript.append((Object)"-c");
                rootScript.append((Object)S);
                rootScript.append('\"');
                rootScript.append((Object)copy);
                rootScript.append((Object)S);
                rootScript.append((Object)tempFile.toString());
                rootScript.append((Object)S);
                rootScript.append((Object)StringTool.replace((String)dest.toString(), (String)S, (String)"\\ "));
                rootScript.appendln('\"');
                rootScript.append('\n');
                rootScript.append((Object)chown);
                rootScript.append((Object)S);
                rootScript.append((Object)user.getName());
                rootScript.append((Object)S);
                rootScript.appendln((Object)StringTool.replace((String)dest.toString(), (String)S, (String)"\\ "));
                rootScript.append('\n');
                rootScript.append('\n');
                uninstallScript.append((Object)this.getSuCommand());
                uninstallScript.append((Object)S);
                uninstallScript.append((Object)user.getName());
                uninstallScript.append((Object)S);
                uninstallScript.append((Object)"-c");
                uninstallScript.append((Object)S);
                uninstallScript.append('\"');
                uninstallScript.append((Object)rm);
                uninstallScript.append((Object)S);
                uninstallScript.append((Object)StringTool.replace((String)dest.toString(), (String)S, (String)"\\ "));
                uninstallScript.appendln('\"');
                uninstallScript.appendln();
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Could not copy as root: " + e.getMessage(), e);
            }
        }
        rootScript.append((Object)rm);
        rootScript.append((Object)S);
        rootScript.appendln((Object)tempFile.toString());
        rootScript.appendln();
    }

    @Override
    public void execPostAction() {
        logger.fine("Launching post execution action");
        String pseudoUnique = this.getClass().getName() + Long.toString(System.currentTimeMillis());
        String scriptFilename = null;
        try {
            scriptFilename = File.createTempFile(pseudoUnique, ".sh").toString();
        }
        catch (IOException e) {
            scriptFilename = System.getProperty("java.io.tmpdir", "/tmp") + "/" + pseudoUnique + ".sh";
            e.printStackTrace();
        }
        rootScript.write(scriptFilename);
        rootScript.exec();
        rootScript.delete();
        logger.fine(rootScript.toString());
        pseudoUnique = this.getClass().getName() + Long.toString(System.currentTimeMillis());
        try {
            scriptFilename = File.createTempFile(pseudoUnique, ".sh").toString();
        }
        catch (IOException e) {
            scriptFilename = System.getProperty("java.io.tmpdir", "/tmp") + "/" + pseudoUnique + ".sh";
            e.printStackTrace();
        }
        this.myInstallScript.write(scriptFilename);
        this.myInstallScript.exec();
        this.myInstallScript.delete();
        logger.fine(this.myInstallScript.toString());
        logger.fine(uninstallScript.toString());
        this.uninstaller.addUninstallScript(uninstallScript.getContentAsString());
    }

    public static void copyTo(File inFile, File outFile) throws IOException {
        char[] cbuff = new char[32768];
        BufferedReader reader = new BufferedReader(new FileReader(inFile));
        BufferedWriter writer = new BufferedWriter(new FileWriter(outFile));
        int readBytes = 0;
        while ((readBytes = reader.read(cbuff, 0, cbuff.length)) != -1) {
            writer.write(cbuff, 0, readBytes);
        }
        reader.close();
        writer.close();
    }

    public String getWrittenFileName() {
        return this.writtenFileName;
    }

    protected void setWrittenFileName(String s) {
        this.writtenFileName = s;
    }

    private File writeAppShortcut(String targetPath, String shortcutName, String shortcutDef) {
        return this.writeAppShortcutWithSimpleSpacehandling(targetPath, shortcutName, shortcutDef, false);
    }

    private File writeAppShortcutWithOutSpace(String targetPath, String shortcutName, String shortcutDef) {
        return this.writeAppShortcutWithSimpleSpacehandling(targetPath, shortcutName, shortcutDef, true);
    }

    private File writeAppShortcutWithSimpleSpacehandling(String targetPath, String shortcutName, String shortcutDef, boolean replaceSpacesWithMinus) {
        File shortcutFile;
        if (!targetPath.endsWith("/") && !targetPath.endsWith("\\")) {
            targetPath = targetPath + File.separatorChar;
        }
        while ((shortcutFile = new File(targetPath + (replaceSpacesWithMinus ? StringTool.replaceSpacesWithMinus((String)shortcutName) : shortcutName) + "-" + System.currentTimeMillis() + DESKTOP_EXT)).exists()) {
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(shortcutFile);
        }
        catch (IOException e1) {
            System.out.println(e1.getMessage());
        }
        try {
            fileWriter.write(shortcutDef);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            fileWriter.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return shortcutFile;
    }

    @Override
    public void setArguments(String args) {
        this.props.put("$Arguments", args);
    }

    @Override
    public void setDescription(String description) {
        this.props.put("$Comment", description);
    }

    @Override
    public void setIconLocation(String path, int index) {
        this.props.put("$Icon", path);
    }

    @Override
    public void setLinkName(String aName) {
        this.itsName = aName;
        this.props.put("$Name", aName);
    }

    @Override
    public void setLinkType(int aType) throws IllegalArgumentException, UnsupportedEncodingException {
        this.ShortcutType = aType;
    }

    @Override
    public void setProgramGroup(String aGroupName) {
        this.itsGroupName = aGroupName;
    }

    @Override
    public void setShowCommand(int show) {
    }

    @Override
    public void setTargetPath(String aPath) {
        StringTokenizer whiteSpaceTester = new StringTokenizer(aPath);
        if (whiteSpaceTester.countTokens() > 1) {
            this.props.put("$E_QUOT", QM);
        }
        this.props.put("$Exec", aPath);
    }

    @Override
    public void setUserType(int aUserType) {
        this.itsUserType = aUserType;
    }

    @Override
    public void setWorkingDirectory(String aDirectory) {
        StringTokenizer whiteSpaceTester = new StringTokenizer(aDirectory);
        if (whiteSpaceTester.countTokens() > 1) {
            this.props.put("$P_QUOT", QM);
        }
        this.props.put("$Path", aDirectory);
    }

    public String toString() {
        return this.itsName + N + template;
    }

    public String replace() {
        String result = template;
        Enumeration<Object> enumeration = this.props.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            result = StringTool.replace((String)result, (String)key, (String)this.props.getProperty(key));
        }
        return result;
    }

    @Override
    public void setEncoding(String aEncoding) {
        this.props.put("$Encoding", aEncoding);
    }

    @Override
    public void setKdeSubstUID(String trueFalseOrNothing) {
        this.props.put("$X_KDE_SubstituteUID", trueFalseOrNothing);
    }

    @Override
    public void setKdeUserName(String aUserName) {
        this.props.put("$X_KDE_Username", aUserName);
    }

    @Override
    public void setMimetype(String aMimetype) {
        this.props.put("$MimeType", aMimetype);
    }

    @Override
    public void setTerminal(String trueFalseOrNothing) {
        this.props.put("$Terminal", trueFalseOrNothing);
    }

    @Override
    public void setTerminalOptions(String someTerminalOptions) {
        this.props.put("$Options_For_Terminal", someTerminalOptions);
    }

    @Override
    public void setType(String aType) {
        this.props.put("$Type", aType);
    }

    @Override
    public void setURL(String anUrl) {
        this.props.put("$URL", anUrl);
    }

    @Override
    public int getUserType() {
        return this.itsUserType;
    }

    @Override
    public void setCategories(String theCategories) {
        this.props.put("$Categories", theCategories);
    }

    @Override
    public void setTryExec(String aTryExec) {
        this.props.put("$TryExec", aTryExec);
    }

    @Override
    public int getLinkType() {
        return this.ShortcutType;
    }
}

