/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.jar;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.archiver.util.EnumeratedAttribute;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.archiver.zip.ZipEntry;
import org.codehaus.plexus.archiver.zip.ZipFile;
import org.codehaus.plexus.archiver.zip.ZipOutputStream;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.util.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarArchiver
extends ZipArchiver {
    private static final String META_INF_NAME = "META-INF";
    private static final String INDEX_NAME = "META-INF/INDEX.LIST";
    private static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    private Manifest configuredManifest;
    private Manifest savedConfiguredManifest;
    private Manifest filesetManifest;
    private Manifest originalManifest;
    private FilesetManifestConfig filesetManifestConfig;
    private boolean mergeManifestsMain = true;
    private Manifest manifest;
    private String manifestEncoding;
    private File manifestFile;
    private boolean index = false;
    private boolean createEmpty = false;
    private Vector<String> rootEntries;
    private ArrayList<String> indexJars;

    public JarArchiver() {
        this.archiveType = "jar";
        this.setEncoding("UTF8");
        this.rootEntries = new Vector();
    }

    public void setIndex(boolean flag) {
        this.index = flag;
    }

    public void setManifestEncoding(String manifestEncoding) {
        this.manifestEncoding = manifestEncoding;
    }

    public void addConfiguredManifest(Manifest newManifest) throws ManifestException {
        if (this.configuredManifest == null) {
            this.configuredManifest = newManifest;
        } else {
            this.configuredManifest.merge(newManifest);
        }
        this.savedConfiguredManifest = this.configuredManifest;
    }

    public void setManifest(File manifestFile) throws ArchiverException {
        if (!manifestFile.exists()) {
            throw new ArchiverException("Manifest file: " + manifestFile + " does not exist.");
        }
        this.manifestFile = manifestFile;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Manifest getManifest(File manifestFile) throws ArchiverException {
        Manifest manifest;
        FileInputStream in = null;
        try {
            in = new FileInputStream(manifestFile);
            InputStreamReader reader = this.manifestEncoding == null ? new InputStreamReader(in) : new InputStreamReader((InputStream)in, this.manifestEncoding);
            manifest = this.getManifest(reader);
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new ArchiverException("Unsupported encoding while reading manifest: " + e.getMessage(), e);
                catch (IOException e2) {
                    throw new ArchiverException("Unable to read manifest file: " + manifestFile + " (" + e2.getMessage() + ")", e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(in);
                throw throwable;
            }
        }
        IOUtil.close((InputStream)in);
        return manifest;
    }

    private Manifest getManifest(Reader r) throws ArchiverException {
        try {
            return new Manifest(r);
        }
        catch (ManifestException e) {
            this.getLogger().error("Manifest is invalid: " + e.getMessage());
            throw new ArchiverException("Invalid Manifest: " + this.manifestFile, e);
        }
        catch (IOException e) {
            throw new ArchiverException("Unable to read manifest file (" + e.getMessage() + ")", e);
        }
    }

    public void setFilesetmanifest(FilesetManifestConfig config) {
        this.filesetManifestConfig = config;
        this.mergeManifestsMain = "merge".equals(config.getValue());
        if (this.filesetManifestConfig != null && !this.filesetManifestConfig.getValue().equals("skip")) {
            this.doubleFilePass = true;
        }
    }

    public void addConfiguredIndexJars(File indexJar) {
        if (this.indexJars == null) {
            this.indexJars = new ArrayList();
        }
        this.indexJars.add(indexJar.getAbsolutePath());
    }

    @Override
    protected void initZipOutputStream(ZipOutputStream zOut) throws IOException, ArchiverException {
        if (!this.skipWriting) {
            Manifest jarManifest = this.createManifest();
            this.writeManifest(zOut, jarManifest);
        }
    }

    @Override
    protected boolean hasVirtualFiles() {
        this.getLogger().debug("\n\n\nChecking for jar manifest virtual files...\n\n\n");
        System.out.flush();
        return this.configuredManifest != null || this.manifest != null || this.manifestFile != null || super.hasVirtualFiles();
    }

    private Manifest createManifest() throws ArchiverException {
        try {
            Manifest finalManifest = Manifest.getDefaultManifest();
            if (this.manifest == null && this.manifestFile != null) {
                this.manifest = this.getManifest(this.manifestFile);
            }
            if (this.isInUpdateMode()) {
                finalManifest.merge(this.originalManifest);
            }
            finalManifest.merge(this.filesetManifest);
            finalManifest.merge(this.configuredManifest);
            finalManifest.merge(this.manifest, !this.mergeManifestsMain);
            return finalManifest;
        }
        catch (ManifestException e) {
            this.getLogger().error("Manifest is invalid: " + e.getMessage());
            throw new ArchiverException("Invalid Manifest", e);
        }
    }

    private void writeManifest(ZipOutputStream zOut, Manifest manifest) throws IOException, ArchiverException {
        Enumeration e = manifest.getWarnings();
        while (e.hasMoreElements()) {
            this.getLogger().warn("Manifest warning: " + e.nextElement());
        }
        this.zipDir(null, zOut, "META-INF/", 16877);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, "UTF-8");
        PrintWriter writer = new PrintWriter(osw);
        manifest.write(writer);
        writer.flush();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        super.zipFile(bais, zOut, MANIFEST_NAME, System.currentTimeMillis(), null, 33188);
        super.initZipOutputStream(zOut);
    }

    @Override
    protected void finalizeZipOutputStream(ZipOutputStream zOut) throws IOException, ArchiverException {
        if (this.index) {
            this.createIndexList(zOut);
        }
    }

    private void createIndexList(ZipOutputStream zOut) throws IOException, ArchiverException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)baos, "UTF8"));
        writer.println("JarIndex-Version: 1.0");
        writer.println();
        writer.println(this.getDestFile().getName());
        HashSet filteredDirs = new HashSet(this.addedDirs.keySet());
        if (filteredDirs.contains("META-INF/")) {
            boolean add = false;
            for (String entry : this.entries.keySet()) {
                if (!entry.startsWith("META-INF/") || entry.equals(INDEX_NAME) || entry.equals(MANIFEST_NAME)) continue;
                add = true;
                break;
            }
            if (!add) {
                filteredDirs.remove("META-INF/");
            }
        }
        this.writeIndexLikeList(new ArrayList<String>(filteredDirs), this.rootEntries, writer);
        writer.println();
        if (this.indexJars != null) {
            Manifest mf = this.createManifest();
            Manifest.Attribute classpath = mf.getMainSection().getAttribute("Class-Path");
            String[] cpEntries = null;
            if (classpath != null) {
                StringTokenizer tok = new StringTokenizer(classpath.getValue(), " ");
                cpEntries = new String[tok.countTokens()];
                int c = 0;
                while (tok.hasMoreTokens()) {
                    cpEntries[c++] = tok.nextToken();
                }
            }
            for (String indexJar : this.indexJars) {
                String name = JarArchiver.findJarName(indexJar, cpEntries);
                if (name == null) continue;
                ArrayList<String> dirs = new ArrayList<String>();
                ArrayList<String> files = new ArrayList<String>();
                JarArchiver.grabFilesAndDirs(indexJar, dirs, files);
                if (dirs.size() + files.size() <= 0) continue;
                writer.println(name);
                this.writeIndexLikeList(dirs, files, writer);
                writer.println();
            }
        }
        writer.flush();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        super.zipFile(bais, zOut, INDEX_NAME, System.currentTimeMillis(), null, 33188);
    }

    @Override
    protected void zipFile(InputStream is, ZipOutputStream zOut, String vPath, long lastModified, File fromArchive, int mode) throws IOException, ArchiverException {
        if (MANIFEST_NAME.equalsIgnoreCase(vPath)) {
            if (!this.doubleFilePass || this.skipWriting) {
                this.filesetManifest(fromArchive, is);
            }
        } else if (INDEX_NAME.equalsIgnoreCase(vPath) && this.index) {
            this.getLogger().warn("Warning: selected " + this.archiveType + " files include a META-INF/INDEX.LIST which will" + " be replaced by a newly generated one.");
        } else {
            if (this.index && !vPath.contains("/")) {
                this.rootEntries.addElement(vPath);
            }
            super.zipFile(is, zOut, vPath, lastModified, fromArchive, mode);
        }
    }

    private void filesetManifest(File file, InputStream is) throws ArchiverException {
        if (this.manifestFile != null && this.manifestFile.equals(file)) {
            this.getLogger().debug("Found manifest " + file);
            try {
                if (is != null) {
                    InputStreamReader reader = this.manifestEncoding == null ? new InputStreamReader(is) : new InputStreamReader(is, this.manifestEncoding);
                    this.manifest = this.getManifest(reader);
                }
                this.manifest = this.getManifest(file);
            }
            catch (UnsupportedEncodingException e) {
                throw new ArchiverException("Unsupported encoding while reading manifest: " + e.getMessage(), e);
            }
        } else if (this.filesetManifestConfig != null && !this.filesetManifestConfig.getValue().equals("skip")) {
            this.getLogger().debug("Found manifest to merge in file " + file);
            try {
                Manifest newManifest;
                if (is != null) {
                    InputStreamReader reader = this.manifestEncoding == null ? new InputStreamReader(is) : new InputStreamReader(is, this.manifestEncoding);
                    newManifest = this.getManifest(reader);
                } else {
                    newManifest = this.getManifest(file);
                }
                if (this.filesetManifest == null) {
                    this.filesetManifest = newManifest;
                } else {
                    this.filesetManifest.merge(newManifest);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new ArchiverException("Unsupported encoding while reading manifest: " + e.getMessage(), e);
            }
            catch (ManifestException e) {
                this.getLogger().error("Manifest in file " + file + " is invalid: " + e.getMessage());
                throw new ArchiverException("Invalid Manifest", e);
            }
        }
    }

    @Override
    protected boolean createEmptyZip(File zipFile) throws ArchiverException {
        if (!this.createEmpty) {
            return true;
        }
        ZipOutputStream zOut = null;
        try {
            this.getLogger().debug("Building MANIFEST-only jar: " + this.getDestFile().getAbsolutePath());
            zOut = new ZipOutputStream(new FileOutputStream(this.getDestFile()));
            zOut.setEncoding(this.getEncoding());
            if (this.isCompress()) {
                zOut.setMethod(8);
            } else {
                zOut.setMethod(0);
            }
            this.initZipOutputStream(zOut);
            this.finalizeZipOutputStream(zOut);
        }
        catch (IOException ioe) {
            try {
                throw new ArchiverException("Could not create almost empty JAR archive (" + ioe.getMessage() + ")", ioe);
            }
            catch (Throwable throwable) {
                IOUtil.close(zOut);
                this.createEmpty = false;
                throw throwable;
            }
        }
        IOUtil.close((OutputStream)zOut);
        this.createEmpty = false;
        return true;
    }

    @Override
    protected void cleanUp() {
        super.cleanUp();
        if (!this.doubleFilePass || !this.skipWriting) {
            this.manifest = null;
            this.configuredManifest = this.savedConfiguredManifest;
            this.filesetManifest = null;
            this.originalManifest = null;
        }
        this.rootEntries.removeAllElements();
    }

    @Override
    public void reset() {
        super.reset();
        this.configuredManifest = null;
        this.filesetManifestConfig = null;
        this.mergeManifestsMain = false;
        this.manifestFile = null;
        this.index = false;
    }

    protected final void writeIndexLikeList(List<String> dirs, List<String> files, PrintWriter writer) {
        Collections.sort(dirs);
        Collections.sort(files);
        for (String dir : dirs) {
            if ((dir = dir.replace('\\', '/')).startsWith("./")) {
                dir = dir.substring(2);
            }
            while (dir.startsWith("/")) {
                dir = dir.substring(1);
            }
            int pos = dir.lastIndexOf(47);
            if (pos != -1) {
                dir = dir.substring(0, pos);
            }
            writer.println(dir);
        }
        Iterator<String> iter = files.iterator();
        while (iter.hasNext()) {
            writer.println((Object)iter.next());
        }
    }

    protected static String findJarName(String fileName, String[] classpath) {
        if (classpath == null) {
            return new File(fileName).getName();
        }
        fileName = fileName.replace(File.separatorChar, '/');
        TreeMap<String, String> matches = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1 != null && o2 != null) {
                    return o2.length() - o1.length();
                }
                return 0;
            }
        });
        block0: for (String aClasspath : classpath) {
            if (fileName.endsWith(aClasspath)) {
                matches.put(aClasspath, aClasspath);
                continue;
            }
            int slash = aClasspath.indexOf("/");
            String candidate = aClasspath;
            while (slash > -1) {
                if (fileName.endsWith(candidate = candidate.substring(slash + 1))) {
                    matches.put(candidate, aClasspath);
                    continue block0;
                }
                slash = candidate.indexOf("/");
            }
        }
        return matches.size() == 0 ? null : (String)matches.get(matches.firstKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void grabFilesAndDirs(String file, List<String> dirs, List<String> files) throws IOException {
        File zipFile = new File(file);
        if (!zipFile.exists()) {
            ConsoleLogger logger = new ConsoleLogger(1, "console");
            logger.error("JarArchive skipping non-existing file: " + zipFile.getAbsolutePath());
        } else if (zipFile.isDirectory()) {
            ConsoleLogger logger = new ConsoleLogger(1, "console");
            logger.info("JarArchiver skipping indexJar " + zipFile + " because it is not a jar");
        } else {
            ZipFile zf = null;
            try {
                zf = new ZipFile(file, "utf-8");
                Enumeration<ZipEntry> entries = zf.getEntries();
                HashSet<String> dirSet = new HashSet<String>();
                while (entries.hasMoreElements()) {
                    ZipEntry ze = entries.nextElement();
                    String name = ze.getName();
                    if (name.equals(META_INF_NAME) || name.equals("META-INF/") || name.equals(INDEX_NAME) || name.equals(MANIFEST_NAME)) continue;
                    if (ze.isDirectory()) {
                        dirSet.add(name);
                        continue;
                    }
                    if (!name.contains("/")) {
                        files.add(name);
                        continue;
                    }
                    dirSet.add(name.substring(0, name.lastIndexOf("/") + 1));
                }
                dirs.addAll(dirSet);
            }
            finally {
                if (zf != null) {
                    zf.close();
                }
            }
        }
    }

    public static class FilesetManifestConfig
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"skip", "merge", "mergewithoutmain"};
        }
    }
}

