/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.taskqueue;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Configurable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.taskqueue.Task;
import org.codehaus.plexus.taskqueue.TaskEntryEvaluator;
import org.codehaus.plexus.taskqueue.TaskExitEvaluator;
import org.codehaus.plexus.taskqueue.TaskQueue;
import org.codehaus.plexus.taskqueue.TaskQueueException;
import org.codehaus.plexus.taskqueue.TaskViabilityEvaluator;

public class DefaultTaskQueue
extends AbstractLogEnabled
implements TaskQueue,
Contextualizable,
Configurable,
Initializable {
    private PlexusContainer container;
    private List taskEntryEvaluators;
    private List taskExitEvaluators;
    private List taskViabilityEvaluators;
    private BlockingQueue queue;

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    public void configure(PlexusConfiguration config) throws PlexusConfigurationException {
        PlexusConfiguration entryEvaluatorsConfiguration = config.getChild("task-entry-evaluators");
        this.taskEntryEvaluators = new ArrayList();
        if (entryEvaluatorsConfiguration != null) {
            PlexusConfiguration[] entryEvaluators = entryEvaluatorsConfiguration.getChildren("task-entry-evaluator");
            for (int i = 0; i < entryEvaluators.length; ++i) {
                this.configureEntryEvaluator(entryEvaluators[i]);
            }
        }
        PlexusConfiguration exitEvaluatorsConfiguration = config.getChild("task-exit-evaluators");
        this.taskExitEvaluators = new ArrayList();
        if (exitEvaluatorsConfiguration != null) {
            PlexusConfiguration[] exitEvaluators = exitEvaluatorsConfiguration.getChildren("task-exit-evaluator");
            for (int i = 0; i < exitEvaluators.length; ++i) {
                this.configureExitEvaluator(exitEvaluators[i]);
            }
        }
        PlexusConfiguration viabilityEvaluatorsConfiguration = config.getChild("task-viability-evaluators");
        this.taskViabilityEvaluators = new ArrayList();
        if (viabilityEvaluatorsConfiguration != null) {
            PlexusConfiguration[] viabilityEvaluators = viabilityEvaluatorsConfiguration.getChildren("task-viability-evaluator");
            for (int i = 0; i < viabilityEvaluators.length; ++i) {
                this.configureViabilityEvaluator(viabilityEvaluators[i]);
            }
        }
    }

    public void initialize() throws InitializationException {
        this.queue = new LinkedBlockingQueue();
    }

    public boolean put(Task task) throws TaskQueueException {
        Iterator it = this.taskEntryEvaluators.iterator();
        while (it.hasNext()) {
            TaskEntryEvaluator taskEntryEvaluator = (TaskEntryEvaluator)it.next();
            boolean result = taskEntryEvaluator.evaluate(task);
            if (result) continue;
            return false;
        }
        this.enqueue(task);
        it = this.taskViabilityEvaluators.iterator();
        while (it.hasNext()) {
            TaskViabilityEvaluator taskViabilityEvaluator = (TaskViabilityEvaluator)it.next();
            Collection toBeRemoved = taskViabilityEvaluator.evaluate(Collections.unmodifiableCollection(this.queue));
            Iterator it2 = toBeRemoved.iterator();
            while (it2.hasNext()) {
                Task t = (Task)it2.next();
                this.queue.remove((Object)t);
            }
        }
        return true;
    }

    public Task take() throws TaskQueueException {
        Task task;
        block0: do {
            if ((task = this.dequeue()) == null) {
                return null;
            }
            Iterator it = this.taskExitEvaluators.iterator();
            while (it.hasNext()) {
                TaskExitEvaluator taskExitEvaluator = (TaskExitEvaluator)it.next();
                boolean result = taskExitEvaluator.evaluate(task);
                if (result) continue;
                task = null;
                continue block0;
            }
        } while (task == null);
        return task;
    }

    public Task poll(int timeout, TimeUnit timeUnit) throws InterruptedException {
        return (Task)this.queue.poll((long)timeout, timeUnit);
    }

    public boolean remove(Task task) throws ClassCastException, NullPointerException {
        return this.queue.remove((Object)task);
    }

    public boolean removeAll(List tasks) throws ClassCastException, NullPointerException {
        return this.queue.removeAll((Collection)tasks);
    }

    public List getQueueSnapshot() throws TaskQueueException {
        return Collections.unmodifiableList(new ArrayList(this.queue));
    }

    private void enqueue(Task task) {
        this.queue.offer((Object)task);
    }

    private Task dequeue() {
        return (Task)this.queue.poll();
    }

    protected void configureEntryEvaluator(PlexusConfiguration config) throws PlexusConfigurationException {
        String name = config.getValue();
        TaskEntryEvaluator taskEntryEvaluator = null;
        try {
            taskEntryEvaluator = (TaskEntryEvaluator)this.container.lookup(TaskEntryEvaluator.ROLE, name);
        }
        catch (ComponentLookupException e) {
            throw new PlexusConfigurationException("Couldn't look up task entry evaluator '" + name + "'.", (Throwable)e);
        }
        this.taskEntryEvaluators.add(taskEntryEvaluator);
    }

    protected void configureExitEvaluator(PlexusConfiguration config) throws PlexusConfigurationException {
        String name = config.getValue();
        TaskExitEvaluator taskExitEvaluator = null;
        try {
            taskExitEvaluator = (TaskExitEvaluator)this.container.lookup(TaskExitEvaluator.ROLE, name);
        }
        catch (ComponentLookupException e) {
            throw new PlexusConfigurationException("Couldn't look up task exit evaluator '" + name + "'.", (Throwable)e);
        }
        this.taskExitEvaluators.add(taskExitEvaluator);
    }

    protected void configureViabilityEvaluator(PlexusConfiguration config) throws PlexusConfigurationException {
        String name = config.getValue();
        TaskViabilityEvaluator taskViabilityEvaluator = null;
        try {
            taskViabilityEvaluator = (TaskViabilityEvaluator)this.container.lookup(TaskViabilityEvaluator.ROLE, name);
        }
        catch (ComponentLookupException e) {
            throw new PlexusConfigurationException("Couldn't look up task viability evaluator '" + name + "'.", (Throwable)e);
        }
        catch (NullPointerException e) {
            throw new PlexusConfigurationException("NullPointerException look up task viability evaluator '" + name + "'.", (Throwable)e);
        }
        this.taskViabilityEvaluators.add(taskViabilityEvaluator);
    }
}

