/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.taskqueue.execution;

import edu.emory.mathcs.backport.java.util.concurrent.CancellationException;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutionException;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import edu.emory.mathcs.backport.java.util.concurrent.Future;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.TimeoutException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Startable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.StartingException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.StoppingException;
import org.codehaus.plexus.taskqueue.Task;
import org.codehaus.plexus.taskqueue.TaskQueue;
import org.codehaus.plexus.taskqueue.execution.TaskExecutionException;
import org.codehaus.plexus.taskqueue.execution.TaskExecutor;
import org.codehaus.plexus.taskqueue.execution.TaskQueueExecutor;
import org.codehaus.plexus.util.StringUtils;

public class ThreadedTaskQueueExecutor
extends AbstractLogEnabled
implements TaskQueueExecutor,
Initializable,
Startable {
    private static final int SHUTDOWN = 1;
    private static final int CANCEL_TASK = 2;
    private TaskQueue queue;
    private TaskExecutor executor;
    private String name;
    private ExecutorRunnable executorRunnable;
    private ExecutorService executorService;
    private Task currentTask;

    public void initialize() throws InitializationException {
        if (StringUtils.isEmpty((String)this.name)) {
            throw new IllegalArgumentException("'name' must be set.");
        }
    }

    public void start() throws StartingException {
        this.getLogger().info("Starting task executor, thread name '" + this.name + "'.");
        this.executorService = Executors.newSingleThreadExecutor();
        this.executorRunnable = new ExecutorRunnable();
        this.executorRunnable.setDaemon(true);
        this.executorRunnable.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws StoppingException {
        this.executorRunnable.shutdown();
        int maxSleep = 10000;
        int interval = 1000;
        long endTime = System.currentTimeMillis() + (long)maxSleep;
        while (!this.executorRunnable.isDone() && this.executorRunnable.isAlive()) {
            if (System.currentTimeMillis() > endTime) {
                this.getLogger().warn("Timeout waiting for executor thread '" + this.name + "' to stop, aborting");
                break;
            }
            this.getLogger().info("Waiting until task executor '" + this.name + "' is idling...");
            try {
                ExecutorRunnable executorRunnable = this.executorRunnable;
                synchronized (executorRunnable) {
                    this.executorRunnable.wait(interval);
                }
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            this.executorRunnable.shutdown();
        }
    }

    public Task getCurrentTask() {
        return this.currentTask;
    }

    public synchronized boolean cancelTask(Task task) {
        return this.executorRunnable.cancelTask(task);
    }

    private class ExecutorRunnable
    extends Thread {
        private volatile int command;
        private boolean done;

        private ExecutorRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.command != 1) {
                Task task;
                ThreadedTaskQueueExecutor.this.currentTask = null;
                try {
                    task = ThreadedTaskQueueExecutor.this.queue.poll(100, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    ThreadedTaskQueueExecutor.this.getLogger().info("Executor thread interrupted, command: " + (this.command == 1 ? "Shutdown" : (this.command == 2 ? "Cancel task" : "Unknown")));
                    continue;
                }
                if (task == null) continue;
                ThreadedTaskQueueExecutor.this.currentTask = task;
                Future future = ThreadedTaskQueueExecutor.this.executorService.submit(new Runnable(){

                    public void run() {
                        try {
                            ThreadedTaskQueueExecutor.this.executor.executeTask(task);
                        }
                        catch (TaskExecutionException e) {
                            ThreadedTaskQueueExecutor.this.getLogger().error("Error executing task", (Throwable)e);
                        }
                    }
                });
                try {
                    this.waitForTask(task, future);
                }
                catch (ExecutionException e) {
                    ThreadedTaskQueueExecutor.this.getLogger().error("Error executing task", (Throwable)e);
                }
            }
            ThreadedTaskQueueExecutor.this.currentTask = null;
            ThreadedTaskQueueExecutor.this.getLogger().info("Executor thread '" + ThreadedTaskQueueExecutor.this.name + "' exited.");
            this.done = true;
            ExecutorRunnable executorRunnable = this;
            synchronized (executorRunnable) {
                this.notifyAll();
            }
        }

        private void waitForTask(Task task, Future future) throws ExecutionException {
            boolean stop = false;
            while (!stop) {
                try {
                    if (task.getMaxExecutionTime() == 0L) {
                        ThreadedTaskQueueExecutor.this.getLogger().debug("Waiting indefinitely for task to complete");
                        future.get();
                        return;
                    }
                    ThreadedTaskQueueExecutor.this.getLogger().debug("Waiting at most " + task.getMaxExecutionTime() + "ms for task completion");
                    future.get(task.getMaxExecutionTime(), TimeUnit.MILLISECONDS);
                    ThreadedTaskQueueExecutor.this.getLogger().debug("Task completed within " + task.getMaxExecutionTime() + "ms");
                    return;
                }
                catch (InterruptedException e) {
                    switch (this.command) {
                        case 1: {
                            ThreadedTaskQueueExecutor.this.getLogger().info("Shutdown command received. Cancelling task.");
                            this.cancel(future);
                            return;
                        }
                        case 2: {
                            this.command = 0;
                            ThreadedTaskQueueExecutor.this.getLogger().info("Cancelling task");
                            this.cancel(future);
                            return;
                        }
                    }
                    ThreadedTaskQueueExecutor.this.getLogger().warn("Interrupted while waiting for task to complete; ignoring", (Throwable)e);
                }
                catch (TimeoutException e) {
                    ThreadedTaskQueueExecutor.this.getLogger().warn("Task " + task + " didn't complete within time, cancelling it.");
                    this.cancel(future);
                    return;
                }
                catch (CancellationException e) {
                    ThreadedTaskQueueExecutor.this.getLogger().warn("The task was cancelled", (Throwable)e);
                    return;
                }
            }
        }

        private void cancel(Future future) {
            if (!future.cancel(true)) {
                if (!future.isDone() && !future.isCancelled()) {
                    ThreadedTaskQueueExecutor.this.getLogger().warn("Unable to cancel task");
                } else {
                    ThreadedTaskQueueExecutor.this.getLogger().warn("Task not cancelled (Flags: done: " + future.isDone() + " cancelled: " + future.isCancelled() + ")");
                }
            } else {
                ThreadedTaskQueueExecutor.this.getLogger().debug("Task successfully cancelled");
            }
        }

        public synchronized void shutdown() {
            ThreadedTaskQueueExecutor.this.getLogger().debug("Signalling executor thread to shutdown");
            this.command = 1;
            this.interrupt();
        }

        public synchronized boolean cancelTask(Task task) {
            if (!task.equals(ThreadedTaskQueueExecutor.this.currentTask)) {
                ThreadedTaskQueueExecutor.this.getLogger().debug("Not cancelling task - it is not running");
                return false;
            }
            if (this.command != 1) {
                ThreadedTaskQueueExecutor.this.getLogger().debug("Signalling executor thread to cancel task");
                this.command = 2;
                this.interrupt();
            } else {
                ThreadedTaskQueueExecutor.this.getLogger().debug("Executor thread already stopping; task will be cancelled automatically");
            }
            return true;
        }

        public boolean isDone() {
            return this.done;
        }
    }
}

