/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.Lists;
import java.util.List;
import org.sonar.java.ast.visitors.PublicApiChecker;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

public class AbstractDeprecatedChecker
extends SubscriptionBaseVisitor {
    private static final Tree.Kind[] CLASS_KINDS = PublicApiChecker.classKinds();
    private static final Tree.Kind[] METHOD_KINDS = PublicApiChecker.methodKinds();
    private static final Tree.Kind[] API_KINDS = PublicApiChecker.apiKinds();
    private final PublicApiChecker publicApiChecker = new PublicApiChecker();

    public List<Tree.Kind> nodesToVisit() {
        return Lists.newArrayList((Object[])API_KINDS);
    }

    public boolean hasJavadocDeprecatedTag(Tree tree) {
        String javadoc = this.publicApiChecker.getApiJavadoc(tree);
        return AbstractDeprecatedChecker.hasJavadocDeprecatedTag(javadoc);
    }

    public static boolean hasJavadocDeprecatedTag(String comment) {
        return comment != null && comment.startsWith("/**") && comment.contains("@deprecated");
    }

    public boolean hasDeprecatedAnnotation(Tree tree) {
        if (tree.is(CLASS_KINDS)) {
            return this.hasDeprecatedAnnotation((ClassTree)tree);
        }
        if (tree.is(METHOD_KINDS)) {
            return this.hasDeprecatedAnnotation((MethodTree)tree);
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            return this.hasDeprecatedAnnotation((VariableTree)tree);
        }
        return false;
    }

    private boolean hasDeprecatedAnnotation(ClassTree classTree) {
        return this.hasDeprecatedAnnotation(classTree.modifiers().annotations());
    }

    private boolean hasDeprecatedAnnotation(VariableTree variableTree) {
        return this.hasDeprecatedAnnotation(variableTree.modifiers().annotations());
    }

    private boolean hasDeprecatedAnnotation(MethodTree methodTree) {
        return this.hasDeprecatedAnnotation(methodTree.modifiers().annotations());
    }

    private boolean hasDeprecatedAnnotation(Iterable<AnnotationTree> annotations) {
        for (AnnotationTree annotationTree : annotations) {
            if (!this.isDeprecated(annotationTree)) continue;
            return true;
        }
        return false;
    }

    public boolean isDeprecated(AnnotationTree tree) {
        return tree.annotationType().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && "Deprecated".equals(((IdentifierTree)tree.annotationType()).name());
    }
}

