/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1294", priority=Priority.CRITICAL, tags={"convention"})
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class ArrayEqualsCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S1294";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S1294");
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitMethodInvocation(MethodInvocationTree tree) {
        AbstractTypedTree typedTree;
        MemberSelectExpressionTree mset;
        if (tree.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && "equals".equals((mset = (MemberSelectExpressionTree)tree.methodSelect()).identifier().name()) && (typedTree = (AbstractTypedTree)mset.expression()).getSymbolType().isTagged(11)) {
            this.context.addIssue((Tree)tree, this.ruleKey, "Use the '==' operator instead of calling the equals() method to prevent any misunderstandings");
        }
        super.visitMethodInvocation(tree);
    }
}

