/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;

@Rule(key="S1125", priority=Priority.MINOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MINOR)
public class BooleanLiteralCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.EQUAL_TO, (Object)Tree.Kind.NOT_EQUAL_TO, (Object)Tree.Kind.CONDITIONAL_AND, (Object)Tree.Kind.CONDITIONAL_OR, (Object)Tree.Kind.LOGICAL_COMPLEMENT);
    }

    public void visitNode(Tree tree) {
        String literal = tree.is(new Tree.Kind[]{Tree.Kind.LOGICAL_COMPLEMENT}) ? this.getBooleanLiteral((Tree)((UnaryExpressionTree)tree).expression()) : this.getBooleanLiteralOperands((BinaryExpressionTree)tree);
        if (literal != null) {
            this.addIssue(tree, "Remove the literal \"" + literal + "\" boolean value.");
        }
    }

    private String getBooleanLiteral(Tree tree) {
        String result = null;
        if (tree.is(new Tree.Kind[]{Tree.Kind.BOOLEAN_LITERAL})) {
            result = ((LiteralTree)tree).value();
        }
        return result;
    }

    private String getBooleanLiteralOperands(BinaryExpressionTree tree) {
        String result = this.getBooleanLiteral((Tree)tree.leftOperand());
        if (result == null) {
            result = this.getBooleanLiteral((Tree)tree.rightOperand());
        }
        return result;
    }
}

