/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1157", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class CaseInsensitiveComparisonCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S1157";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S1157");
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitMethodInvocation(MethodInvocationTree tree) {
        if (tree.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            boolean issue;
            MemberSelectExpressionTree memberSelect = (MemberSelectExpressionTree)tree.methodSelect();
            boolean bl = issue = "equals".equals(memberSelect.identifier().name()) && (this.isToUpperCaseOrToLowerCase(memberSelect.expression()) || tree.arguments().size() == 1 && this.isToUpperCaseOrToLowerCase((ExpressionTree)tree.arguments().get(0)));
            if (issue) {
                this.context.addIssue((Tree)tree, this.ruleKey, "Replace these toUpperCase()/toLowerCase() and equals() calls with a single equalsIgnoreCase() call.");
            }
        }
        super.visitMethodInvocation(tree);
    }

    private boolean isToUpperCaseOrToLowerCase(ExpressionTree expression) {
        MethodInvocationTree methodInvocation;
        if (expression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && (methodInvocation = (MethodInvocationTree)expression).methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            MemberSelectExpressionTree memberSelect = (MemberSelectExpressionTree)methodInvocation.methodSelect();
            String name = memberSelect.identifier().name();
            return "toUpperCase".equals(name) || "toLowerCase".equals(name);
        }
        return false;
    }
}

