/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.UnionTypeTree;

@Rule(key="S2235", priority=Priority.CRITICAL, tags={"bug", "multi-threading"})
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class CatchIllegalMonitorStateExceptionCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CATCH);
    }

    public void visitNode(Tree tree) {
        CatchTree catchTree = (CatchTree)tree;
        Tree parameterTypeTree = catchTree.parameter().type();
        if (parameterTypeTree.is(new Tree.Kind[]{Tree.Kind.UNION_TYPE})) {
            UnionTypeTree unionTypeTree = (UnionTypeTree)parameterTypeTree;
            for (Tree exceptionTypeTree : unionTypeTree.typeAlternatives()) {
                this.checkExceptionType(exceptionTypeTree);
            }
        } else {
            this.checkExceptionType(parameterTypeTree);
        }
    }

    private void checkExceptionType(Tree exceptionTypeTree) {
        Type exceptionType = ((AbstractTypedTree)exceptionTypeTree).getSymbolType();
        if (exceptionType.is("java.lang.IllegalMonitorStateException")) {
            this.addIssue(exceptionTypeTree, "Refactor this piece of code to not catch IllegalMonitorStateException");
        }
    }
}

