/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2114", priority=Priority.CRITICAL, tags={"bug"})
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class CollectionCallingItselfCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        if (this.hasSemantic()) {
            MethodInvocationTree methodInvocationTree = (MethodInvocationTree)tree;
            Symbol symbolReference = null;
            Symbol.MethodSymbol method = null;
            String reportedName = "";
            if (methodInvocationTree.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                MemberSelectExpressionTree mse = (MemberSelectExpressionTree)methodInvocationTree.methodSelect();
                IdentifierTree identifier = mse.identifier();
                reportedName = identifier.name();
                method = (Symbol.MethodSymbol)this.getSemanticModel().getReference(identifier);
                if (mse.expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                    symbolReference = this.getSemanticModel().getReference((IdentifierTree)mse.expression());
                }
            }
            if (symbolReference != null && method != null && this.isMethodFromCollection(method)) {
                this.reportIssueForParameters(methodInvocationTree, symbolReference, reportedName);
            }
        }
    }

    private void reportIssueForParameters(MethodInvocationTree methodInvocationTree, Symbol symbolReference, String reportedName) {
        for (ExpressionTree arg : methodInvocationTree.arguments()) {
            Symbol reference;
            if (!arg.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) || (reference = this.getSemanticModel().getReference((IdentifierTree)arg)) != symbolReference) continue;
            this.addIssue((Tree)methodInvocationTree, "Remove or correct this \"" + reportedName + "\" call.");
        }
    }

    private boolean isMethodFromCollection(Symbol.MethodSymbol methodSymbol) {
        Symbol.TypeSymbol owner = (Symbol.TypeSymbol)methodSymbol.owner();
        for (Type.ClassType classType : owner.superTypes()) {
            if (!classType.is("java.util.Collection")) continue;
            return true;
        }
        return false;
    }
}

