/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.expression.MethodInvocationTreeImpl;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2200", priority=Priority.MAJOR, tags={"bug"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class CompareToResultTestCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.EQUAL_TO, (Object)Tree.Kind.NOT_EQUAL_TO);
    }

    public void visitNode(Tree tree) {
        BinaryExpressionTree binaryExpression = (BinaryExpressionTree)tree;
        if (this.isInvalidTest(binaryExpression.leftOperand(), binaryExpression.rightOperand())) {
            this.addIssue(tree, "Only the sign of the result should be examined.");
        }
    }

    private boolean isInvalidTest(ExpressionTree operand1, ExpressionTree operand2) {
        return this.isNonZeroInt(operand1) && this.isCompareToResult(operand2) || this.isNonZeroInt(operand2) && this.isCompareToResult(operand1);
    }

    private boolean isCompareToResult(ExpressionTree expression) {
        if (this.hasSemantic()) {
            if (expression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                return this.isCompareToInvocation((MethodInvocationTreeImpl)expression);
            }
            if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                return this.isIdentifierContainingCompareToResult((IdentifierTree)expression);
            }
        }
        return false;
    }

    private boolean isCompareToInvocation(MethodInvocationTreeImpl invocation) {
        Symbol method = invocation.getSymbol();
        if ("compareTo".equals(method.getName()) && invocation.arguments().size() == 1) {
            Symbol.TypeSymbol methodOwner = method.owner().enclosingClass();
            Set superTypes = methodOwner.superTypes();
            for (Type.ClassType classType : superTypes) {
                if (!classType.is("java.lang.Comparable")) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isIdentifierContainingCompareToResult(IdentifierTree identifier) {
        ExpressionTree initializer;
        Symbol variableSymbol = this.getSemanticModel().getReference(identifier);
        if (variableSymbol == null) {
            return false;
        }
        VariableTree variableDefinition = (VariableTree)this.getSemanticModel().getTree(variableSymbol);
        if (variableDefinition != null && (initializer = variableDefinition.initializer()) != null && initializer.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && variableSymbol.owner().isKind(16)) {
            Tree method = this.getSemanticModel().getTree(variableSymbol.owner());
            return this.isCompareToInvocation((MethodInvocationTreeImpl)initializer) && !this.isReassigned(variableSymbol, method);
        }
        return false;
    }

    private boolean isNonZeroInt(ExpressionTree expression) {
        return this.isNonZeroIntLiteral(expression) || expression.is(new Tree.Kind[]{Tree.Kind.UNARY_MINUS}) && this.isNonZeroIntLiteral(((UnaryExpressionTree)expression).expression());
    }

    private boolean isNonZeroIntLiteral(ExpressionTree expression) {
        return expression.is(new Tree.Kind[]{Tree.Kind.INT_LITERAL}) && !"0".equals(((LiteralTree)expression).value());
    }

    private boolean isReassigned(Symbol variableSymbol, Tree method) {
        Collection usages = this.getSemanticModel().getUsages(variableSymbol);
        ReAssignmentFinder reAssignmentFinder = new ReAssignmentFinder(usages);
        method.accept((TreeVisitor)reAssignmentFinder);
        return reAssignmentFinder.foundReAssignment;
    }

    private static class ReAssignmentFinder
    extends BaseTreeVisitor {
        private final Collection<IdentifierTree> usages;
        private boolean foundReAssignment = false;

        public ReAssignmentFinder(Collection<IdentifierTree> usages) {
            this.usages = usages;
        }

        public void visitUnaryExpression(UnaryExpressionTree unaryExp) {
            if (unaryExp.is(new Tree.Kind[]{Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.PREFIX_INCREMENT, Tree.Kind.PREFIX_DECREMENT})) {
                this.checkReAssignment(unaryExp.expression());
            }
            super.visitUnaryExpression(unaryExp);
        }

        public void visitAssignmentExpression(AssignmentExpressionTree assignmentExpression) {
            this.checkReAssignment(assignmentExpression.variable());
            super.visitAssignmentExpression(assignmentExpression);
        }

        private void checkReAssignment(ExpressionTree expression) {
            IdentifierTree identifier;
            if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && this.usages.contains(identifier = (IdentifierTree)expression)) {
                this.foundReAssignment = true;
            }
        }
    }
}

