/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.Sets;
import java.util.HashSet;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1153", priority=Priority.MINOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MINOR)
public class ConcatenationWithStringValueOfCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S1153";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S1153");
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitBinaryExpression(BinaryExpressionTree tree) {
        if (!tree.is(new Tree.Kind[]{Tree.Kind.PLUS})) {
            super.visitBinaryExpression(tree);
            return;
        }
        HashSet valueOfTrees = Sets.newHashSet();
        boolean flagIssue = false;
        BinaryExpressionTree current = tree;
        while (current.is(new Tree.Kind[]{Tree.Kind.PLUS})) {
            BinaryExpressionTree binOp = current;
            this.scan((Tree)binOp.rightOperand());
            if (ConcatenationWithStringValueOfCheck.isStringValueOf(binOp.rightOperand())) {
                valueOfTrees.add(binOp.rightOperand());
            }
            flagIssue |= binOp.leftOperand().is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL});
            if (!valueOfTrees.isEmpty()) {
                flagIssue |= binOp.rightOperand().is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL});
            }
            current = current.leftOperand();
        }
        if (flagIssue) {
            for (ExpressionTree valueOfTree : valueOfTrees) {
                this.addIssue(valueOfTree);
            }
        }
        this.scan((Tree)current);
    }

    private void addIssue(ExpressionTree tree) {
        this.context.addIssue((Tree)tree, this.ruleKey, "Directly append the argument of String.valueOf().");
    }

    private static boolean isStringValueOf(ExpressionTree tree) {
        if (!tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            return false;
        }
        return ConcatenationWithStringValueOfCheck.isStringValueOf((MethodInvocationTree)tree);
    }

    private static boolean isStringValueOf(MethodInvocationTree tree) {
        if (!tree.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return false;
        }
        return tree.arguments().size() == 1 && ConcatenationWithStringValueOfCheck.isStringValueOf((MemberSelectExpressionTree)tree.methodSelect());
    }

    private static boolean isStringValueOf(MemberSelectExpressionTree tree) {
        if (!tree.expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return false;
        }
        return "valueOf".equals(tree.identifier().name()) && "String".equals(((IdentifierTree)tree.expression()).name());
    }
}

