/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.annotations.VisibleForTesting;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.model.declaration.ClassTreeImpl;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="MaximumInheritanceDepth", priority=Priority.MAJOR)
public class DITCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "MaximumInheritanceDepth";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"MaximumInheritanceDepth");
    public static final int DEFAULT_MAX = 5;
    private JavaFileScannerContext context;
    @RuleProperty(defaultValue="5")
    private Integer max = 5;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        if (context.getSemanticModel() != null) {
            this.scan((Tree)context.getTree());
        }
    }

    public void visitClass(ClassTree tree) {
        Symbol.TypeSymbol typeSymbol = ((ClassTreeImpl)tree).getSymbol();
        int dit = 0;
        while (typeSymbol.getSuperclass() != null) {
            ++dit;
            typeSymbol = ((Type.ClassType)typeSymbol.getSuperclass()).getSymbol();
        }
        if (dit > this.max) {
            this.context.addIssue((Tree)tree, this.ruleKey, "This class has " + dit + " parents which is greater than " + this.max + " authorized.");
        }
        super.visitClass(tree);
    }

    @VisibleForTesting
    void setMax(int max) {
        this.max = max;
    }

    public String toString() {
        return "MaximumInheritanceDepth rule";
    }
}

