/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.java.resolve.Symbol;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1206", priority=Priority.BLOCKER, tags={"bug"})
@BelongsToProfile(title="Sonar way", priority=Priority.BLOCKER)
public class EqualsOverridenWithHashCodeCheck
extends SubscriptionBaseVisitor {
    private static final String HASHCODE = "hashCode";
    private static final String EQUALS = "equals";

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (classTree.is(new Tree.Kind[]{Tree.Kind.CLASS})) {
            MethodTree equalsMethod = null;
            MethodTree hashCodeMethod = null;
            for (Tree memberTree : classTree.members()) {
                if (!memberTree.is(new Tree.Kind[]{Tree.Kind.METHOD})) continue;
                MethodTree methodTree = (MethodTree)memberTree;
                if (this.isEquals(methodTree)) {
                    equalsMethod = methodTree;
                    continue;
                }
                if (!this.isHashCode(methodTree)) continue;
                hashCodeMethod = methodTree;
            }
            if (equalsMethod != null && hashCodeMethod == null) {
                this.addIssue((Tree)equalsMethod, this.getMessage(EQUALS, HASHCODE));
            } else if (hashCodeMethod != null && equalsMethod == null) {
                this.addIssue((Tree)hashCodeMethod, this.getMessage(HASHCODE, EQUALS));
            }
        }
    }

    private boolean isEquals(MethodTree methodTree) {
        return EQUALS.equals(methodTree.simpleName().name()) && this.hasObjectParam(methodTree) && this.returnsType(methodTree, 8);
    }

    private boolean isHashCode(MethodTree methodTree) {
        return HASHCODE.equals(methodTree.simpleName().name()) && methodTree.parameters().isEmpty() && this.returnsType(methodTree, 4);
    }

    private boolean hasObjectParam(MethodTree tree) {
        if (tree.parameters().size() == 1) {
            Tree type = ((VariableTree)tree.parameters().get(0)).type();
            String name = "";
            if (type.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                name = ((MemberSelectExpressionTree)type).identifier().name();
            } else if (type.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                name = ((IdentifierTree)type).name();
            }
            return name.endsWith("Object");
        }
        return false;
    }

    private boolean returnsType(MethodTree tree, int typeTag) {
        Symbol.MethodSymbol methodSymbol = ((MethodTreeImpl)tree).getSymbol();
        return methodSymbol != null && methodSymbol.getReturnType().getType().isTagged(typeTag);
    }

    private String getMessage(String overridenMethod, String methodToOverride) {
        return "This class overrides \"" + overridenMethod + "()\" and should therefore also override \"" + methodToOverride + "()\".";
    }
}

