/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1194", priority=Priority.MAJOR, tags={"error-handling"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class ErrorClassExtendedCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S1194";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S1194");
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitClass(ClassTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS}) && tree.superClass() != null) {
            MemberSelectExpressionTree mse;
            if (tree.superClass().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                IdentifierTree idt = (IdentifierTree)tree.superClass();
                if ("Error".equals(idt.name())) {
                    this.context.addIssue((Tree)tree, this.ruleKey, "Extend \"java.lang.Exception\" or one of its subclasses.");
                }
            } else if (tree.superClass().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && "Error".equals((mse = (MemberSelectExpressionTree)tree.superClass()).identifier().name()) && this.isJavaLang(mse.expression())) {
                this.context.addIssue((Tree)tree, this.ruleKey, "Extend \"java.lang.Exception\" or one of its subclasses.");
            }
        }
        super.visitClass(tree);
    }

    private boolean isJavaLang(ExpressionTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            MemberSelectExpressionTree mse = (MemberSelectExpressionTree)tree;
            if (!"lang".equals(mse.identifier().name())) {
                return false;
            }
            if (mse.expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                IdentifierTree idt = (IdentifierTree)mse.expression();
                return "java".equals(idt.name());
            }
        }
        return false;
    }
}

