/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.model.declaration.ClassTreeImpl;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.java.resolve.Symbol;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1701", priority=Priority.MAJOR, tags={"brain-overload"})
public class FieldMatchMethodNameCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S1701";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S1701");
    private JavaFileScannerContext context;
    private SemanticModel semanticModel;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.semanticModel = (SemanticModel)context.getSemanticModel();
        if (this.semanticModel != null) {
            this.scan((Tree)context.getTree());
        }
    }

    public void visitClass(ClassTree tree) {
        Symbol.TypeSymbol classSymbol = ((ClassTreeImpl)tree).getSymbol();
        if (classSymbol != null) {
            HashMap indexSymbol = Maps.newHashMap();
            HashMultiset fields = HashMultiset.create();
            HashMap fieldsOriginal = Maps.newHashMap();
            HashSet methodNames = Sets.newHashSet();
            Collection symbols = classSymbol.members().scopeSymbols();
            for (Symbol sym : symbols) {
                String symName = sym.getName().toLowerCase();
                if (sym.isKind(4)) {
                    indexSymbol.put(symName, sym);
                    fields.add((Object)symName);
                    fieldsOriginal.put(symName, sym.getName());
                }
                if (!sym.isKind(16)) continue;
                methodNames.add(symName);
            }
            fields.addAll((Collection)methodNames);
            for (Multiset.Entry entry : fields.entrySet()) {
                Tree field;
                if (entry.getCount() <= 1 || (field = this.semanticModel.getTree((Symbol)indexSymbol.get(entry.getElement()))) == null) continue;
                this.context.addIssue(field, this.ruleKey, "Rename the \"" + (String)fieldsOriginal.get(entry.getElement()) + "\" member.");
            }
        }
        super.visitClass(tree);
    }
}

