/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2039", priority=Priority.MAJOR, tags={"security"})
public class FieldModifierCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS, (Object)Tree.Kind.ENUM);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        for (Tree member : classTree.members()) {
            if (!member.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) || !this.hasNoVisibilityModifier((VariableTree)member)) continue;
            this.addIssue(member, "Explicitly declare the visibility for \"" + ((VariableTree)member).simpleName().name() + "\".");
        }
    }

    private boolean hasNoVisibilityModifier(VariableTree member) {
        return !this.hasModifier(member, Modifier.PUBLIC) && !this.hasModifier(member, Modifier.PRIVATE) && !this.hasModifier(member, Modifier.PROTECTED);
    }

    private boolean hasModifier(VariableTree member, Modifier modifier) {
        return member.modifiers().modifiers().contains(modifier);
    }
}

