/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.Lists;
import java.util.Collection;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.model.declaration.ClassTreeImpl;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.java.resolve.Symbol;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1700", priority=Priority.MAJOR, tags={"brain-overload"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class FieldNameMatchingTypeNameCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S1700";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S1700");
    private JavaFileScannerContext context;
    private SemanticModel semanticModel;
    private String currentClassName;
    private Collection<Tree> fields;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.semanticModel = (SemanticModel)context.getSemanticModel();
        this.currentClassName = "";
        this.fields = Lists.newArrayList();
        if (this.semanticModel != null) {
            this.scan((Tree)context.getTree());
        }
    }

    public void visitClass(ClassTree tree) {
        if (tree.simpleName() != null) {
            Symbol.TypeSymbol classSymbol = ((ClassTreeImpl)tree).getSymbol();
            Collection members = classSymbol.members().scopeSymbols();
            for (Symbol sym : members) {
                if (!sym.isKind(4) || this.staticFieldSameType(classSymbol, sym)) continue;
                this.fields.add(this.semanticModel.getTree(sym));
            }
            this.currentClassName = tree.simpleName().name();
        }
        super.visitClass(tree);
        this.currentClassName = "";
        this.fields.clear();
    }

    private boolean staticFieldSameType(Symbol.TypeSymbol classSymbol, Symbol sym) {
        return sym.getType() != null && sym.getType().equals(classSymbol.getType()) && sym.isStatic();
    }

    public void visitVariable(VariableTree tree) {
        String name = tree.simpleName().name();
        if (this.fields.contains(tree) && this.currentClassName.equalsIgnoreCase(name)) {
            this.context.addIssue((Tree)tree, this.ruleKey, "Rename field \"" + name + "\"");
        }
        super.visitVariable(tree);
    }
}

