/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2068", priority=Priority.CRITICAL, tags={"cwe", "owasp-top10", "sans-top25-2011", "security"})
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class HardCodedCredentialsCheck
extends SubscriptionBaseVisitor {
    private static final Pattern PASSWORD_LITERAL_PATTERN = Pattern.compile("password=..", 2);
    private static final Pattern PASSWORD_VARIABLE_PATTERN = Pattern.compile("password", 2);

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.STRING_LITERAL, (Object)Tree.Kind.VARIABLE, (Object)Tree.Kind.ASSIGNMENT);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            String literalValue = ((LiteralTree)tree).value();
            if (PASSWORD_LITERAL_PATTERN.matcher(literalValue).find()) {
                this.addIssue(tree);
            }
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            VariableTree variable = (VariableTree)tree;
            if (this.isStringLiteral(variable.initializer()) && this.isPasswordVariableName(variable.simpleName())) {
                this.addIssue(tree);
            }
        } else {
            AssignmentExpressionTree assignmentExpression = (AssignmentExpressionTree)tree;
            if (this.isStringLiteral(assignmentExpression.expression()) && this.isPasswordVariable(assignmentExpression.variable())) {
                this.addIssue(tree);
            }
        }
    }

    private boolean isStringLiteral(ExpressionTree initializer) {
        return initializer != null && initializer.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL});
    }

    private boolean isPasswordVariableName(IdentifierTree identifierTree) {
        return PASSWORD_VARIABLE_PATTERN.matcher(identifierTree.name()).find();
    }

    private boolean isPasswordVariable(ExpressionTree variable) {
        if (variable.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            return this.isPasswordVariableName(((MemberSelectExpressionTree)variable).identifier());
        }
        if (variable.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return this.isPasswordVariableName((IdentifierTree)variable);
        }
        return false;
    }

    private void addIssue(Tree tree) {
        this.addIssue(tree, "Remove this hard-coded password.");
    }
}

