/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.expression.MethodInvocationTreeImpl;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2201", priority=Priority.CRITICAL, tags={"bug"})
public class IgnoredReturnValueCheck
extends SubscriptionBaseVisitor {
    private static List<String> CHECKED_TYPES = ImmutableList.builder().add((Object)"java.lang.String").add((Object)"java.lang.Boolean").add((Object)"java.lang.Integer").add((Object)"java.lang.Double").add((Object)"java.lang.Float").add((Object)"java.lang.Byte").add((Object)"java.lang.Character").add((Object)"java.lang.Short").add((Object)"java.lang.StackTraceElement").build();

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.EXPRESSION_STATEMENT);
    }

    public void visitNode(Tree tree) {
        MethodInvocationTree mit;
        Type methodType;
        ExpressionStatementTree est = (ExpressionStatementTree)tree;
        if (est.expression().is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && !this.returnsVoid(methodType = ((AbstractTypedTree)(mit = (MethodInvocationTree)est.expression())).getSymbolType()) && this.isCheckedType(mit)) {
            this.addIssue(tree, "The return value of \"" + this.methodName(mit) + "\" must be used.");
        }
    }

    private boolean isCheckedType(MethodInvocationTree mit) {
        Symbol owner = ((MethodInvocationTreeImpl)mit).getSymbol().owner();
        for (String type : CHECKED_TYPES) {
            if (!owner.getType().is(type)) continue;
            return true;
        }
        return false;
    }

    private boolean returnsVoid(Type methodType) {
        return methodType.isTagged(9) || methodType.isTagged(14);
    }

    private String methodName(MethodInvocationTree mit) {
        return this.getIdentifier(mit).name();
    }

    private IdentifierTree getIdentifier(MethodInvocationTree mit) {
        IdentifierTree id = mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) ? (IdentifierTree)mit.methodSelect() : ((MemberSelectExpressionTree)mit.methodSelect()).identifier();
        return id;
    }
}

