/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1213", priority=Priority.MINOR, tags={"convention"})
@BelongsToProfile(title="Sonar way", priority=Priority.MINOR)
public class IncorrectOrderOfMembersCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S1213";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S1213");
    private static final String[] NAMES = new String[]{"variable", "constructor", "method"};
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitClass(ClassTree tree) {
        int prev = 0;
        for (int i = 0; i < tree.members().size(); ++i) {
            int priority;
            Tree member = (Tree)tree.members().get(i);
            if (member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
                priority = 0;
            } else if (member.is(new Tree.Kind[]{Tree.Kind.CONSTRUCTOR})) {
                priority = 1;
            } else {
                if (!member.is(new Tree.Kind[]{Tree.Kind.METHOD})) continue;
                priority = 2;
            }
            if (priority < prev) {
                this.context.addIssue(member, this.ruleKey, "Move this " + NAMES[priority] + " to comply with Java Code Conventions.");
                continue;
            }
            prev = priority;
        }
        super.visitClass(tree);
    }
}

