/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="LowerCaseLongSuffixCheck", priority=Priority.MAJOR, tags={"convention"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class LowerCaseLongSuffixCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.LONG_LITERAL);
    }

    public void visitNode(Tree tree) {
        LiteralTree literalTree = (LiteralTree)tree;
        if (literalTree.value().endsWith("l")) {
            this.addIssue(tree, "Replace this lower case \"l\" long suffix by an upper case \"L\".");
        }
    }
}

