/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.List;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S109", priority=Priority.MINOR)
public class MagicNumberCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S109";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S109");
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitLiteral(LiteralTree tree) {
        if (this.isNumberLiteral(tree)) {
            DecimalFormat decimalFormat = new DecimalFormat();
            decimalFormat.setParseBigDecimal(true);
            BigDecimal checked = null;
            try {
                checked = (BigDecimal)decimalFormat.parse(tree.value());
            }
            catch (ParseException e) {
                // empty catch block
            }
            if (checked != null && !this.isExcluded(checked)) {
                this.context.addIssue((Tree)tree, this.ruleKey, "Assign this magic number " + tree.value() + " to a well-named constant, and use the constant instead.");
            }
        }
    }

    private boolean isNumberLiteral(LiteralTree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.DOUBLE_LITERAL}) || tree.is(new Tree.Kind[]{Tree.Kind.FLOAT_LITERAL}) || tree.is(new Tree.Kind[]{Tree.Kind.LONG_LITERAL}) || tree.is(new Tree.Kind[]{Tree.Kind.INT_LITERAL});
    }

    private boolean isExcluded(BigDecimal bigDecimal) {
        return bigDecimal.compareTo(BigDecimal.ONE) == 0 || bigDecimal.compareTo(BigDecimal.ZERO) == 0 || bigDecimal.compareTo(BigDecimal.ONE.negate()) == 0;
    }

    public void visitAnnotation(AnnotationTree annotationTree) {
    }

    public void visitVariable(VariableTree tree) {
        List modifiers = tree.modifiers().modifiers();
        if (!modifiers.contains(Modifier.STATIC) || !modifiers.contains(Modifier.FINAL)) {
            super.visitVariable(tree);
        }
    }
}

