/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1223", priority=Priority.MAJOR, tags={"pitfall"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class MethodNameSameAsClassCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S1223";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S1223");
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitClass(ClassTree tree) {
        for (Tree member : tree.members()) {
            if (!member.is(new Tree.Kind[]{Tree.Kind.METHOD})) continue;
            MethodTree method = (MethodTree)member;
            if (tree.simpleName() == null || !method.simpleName().name().equals(tree.simpleName().name())) continue;
            this.context.addIssue((Tree)method, this.ruleKey, "Rename this method to prevent any misunderstanding or make it a constructor.");
        }
        super.visitClass(tree);
    }
}

