/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1185", priority=Priority.MINOR, tags={"brain-overload"})
@BelongsToProfile(title="Sonar way", priority=Priority.MINOR)
public class MethodOnlyCallsSuperCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (this.isSingleStatementMethod(methodTree) && this.isUselessSuperCall(methodTree) && !this.hasAnnotationDifferentFromOverride(methodTree.modifiers().annotations())) {
            this.addIssue((Tree)methodTree, "Remove this method to simply inherit it.");
        }
    }

    private boolean isSingleStatementMethod(MethodTree methodTree) {
        BlockTree block = methodTree.block();
        return block != null && block.body().size() == 1;
    }

    private boolean isUselessSuperCall(MethodTree methodTree) {
        ExpressionTree callToSuper = null;
        StatementTree statementTree = (StatementTree)methodTree.block().body().get(0);
        if (this.returnsVoid(methodTree) && statementTree.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT})) {
            callToSuper = ((ExpressionStatementTree)statementTree).expression();
        } else if (statementTree.is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT})) {
            callToSuper = ((ReturnStatementTree)statementTree).expression();
        }
        return callToSuper != null && this.isCallToSuper(methodTree, (Tree)callToSuper);
    }

    private boolean isCallToSuper(MethodTree methodTree, Tree callToSuper) {
        MemberSelectExpressionTree mset;
        MethodInvocationTree methodInvocationTree;
        return callToSuper.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && (methodInvocationTree = (MethodInvocationTree)callToSuper).methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && this.callSuperMethodWithSameName(mset = (MemberSelectExpressionTree)methodInvocationTree.methodSelect(), methodTree) && this.callsWithSameParameters(methodInvocationTree.arguments(), methodTree.parameters());
    }

    private boolean callSuperMethodWithSameName(MemberSelectExpressionTree mset, MethodTree methodTree) {
        return mset.expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && "super".equals(((IdentifierTree)mset.expression()).name()) && mset.identifier().name().equals(methodTree.simpleName().name());
    }

    private boolean callsWithSameParameters(List<ExpressionTree> arguments, List<VariableTree> parameters) {
        if (arguments.size() != parameters.size()) {
            return false;
        }
        for (int i = 0; i < arguments.size(); ++i) {
            ExpressionTree arg = arguments.get(i);
            VariableTree param = parameters.get(i);
            if (arg.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && ((IdentifierTree)arg).name().equals(param.simpleName().name())) continue;
            return false;
        }
        return true;
    }

    private boolean returnsVoid(MethodTree methodTree) {
        Tree returnType = methodTree.returnType();
        return returnType != null && returnType.is(new Tree.Kind[]{Tree.Kind.PRIMITIVE_TYPE}) && "void".equals(((PrimitiveTypeTree)returnType).keyword().text());
    }

    private boolean hasAnnotationDifferentFromOverride(List<AnnotationTree> annotations) {
        for (AnnotationTree annotation : annotations) {
            if (annotation.annotationType().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && "Override".equals(((IdentifierTree)annotation.annotationType()).name())) continue;
            return true;
        }
        return false;
    }
}

