/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifierKeywordTree;
import org.sonar.plugins.java.api.tree.ModifierTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="ModifiersOrderCheck", priority=Priority.MINOR, tags={"convention"})
@BelongsToProfile(title="Sonar way", priority=Priority.MINOR)
public class ModifiersOrderCheck
extends SubscriptionBaseVisitor {
    private Set<Tree> alreadyReported = Sets.newHashSet();

    public void scanFile(JavaFileScannerContext context) {
        this.alreadyReported.clear();
        super.scanFile(context);
    }

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.MODIFIERS);
    }

    public void visitNode(Tree tree) {
        if (!this.alreadyReported.contains(tree)) {
            this.alreadyReported.add(tree);
            ModifierTree badlyOrderedModifier = ModifiersOrderCheck.getFirstBadlyOrdered((ModifiersTree)tree);
            if (badlyOrderedModifier != null) {
                this.addIssue((Tree)badlyOrderedModifier, "Reorder the modifiers to comply with the Java Language Specification.");
            }
        }
    }

    private static ModifierTree getFirstBadlyOrdered(ModifiersTree modifiersTree) {
        int modifierIndex = -1;
        Modifier[] modifiers = Modifier.values();
        for (ModifierTree modifier : modifiersTree) {
            if (modifier.is(new Tree.Kind[]{Tree.Kind.ANNOTATION})) {
                if (modifierIndex < 0) continue;
                return modifier;
            }
            if (modifierIndex < 0) {
                modifierIndex = 0;
            }
            ModifierKeywordTree mkt = (ModifierKeywordTree)modifier;
            while (modifierIndex < modifiers.length && !mkt.modifier().equals((Object)modifiers[modifierIndex])) {
                ++modifierIndex;
            }
            if (modifierIndex != modifiers.length) continue;
            return modifier;
        }
        return null;
    }
}

